/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.AlphaTestFunction;
import net.coderbot.iris.gl.blending.BlendMode;
import net.coderbot.iris.gl.blending.BlendModeFunction;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.blending.BufferBlendInformation;
import net.coderbot.iris.gl.buffer.ShaderStorageInfo;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.texture.PixelFormat;
import net.coderbot.iris.gl.texture.PixelType;
import net.coderbot.iris.gl.texture.TextureDefinition;
import net.coderbot.iris.gl.texture.TextureScaleOverride;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.helpers.Tri;
import net.coderbot.iris.shaderpack.CloudSetting;
import net.coderbot.iris.shaderpack.ImageInformation;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.OrderBackedProperties;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ParticleRenderingSettings;
import net.coderbot.iris.shaderpack.ShadowCullState;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.preprocessor.PropertiesPreprocessor;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.uniforms.custom.CustomUniforms;

public class ShaderProperties {
    private int customTexAmount;
    private CloudSetting cloudSetting = CloudSetting.DEFAULT;
    private OptionalBoolean oldHandLight = OptionalBoolean.DEFAULT;
    private OptionalBoolean dynamicHandLight = OptionalBoolean.DEFAULT;
    private OptionalBoolean supportsColorCorrection = OptionalBoolean.DEFAULT;
    private OptionalBoolean oldLighting = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowTerrain = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowTranslucent = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowEntities = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowPlayer = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowBlockEntities = OptionalBoolean.DEFAULT;
    private OptionalBoolean underwaterOverlay = OptionalBoolean.DEFAULT;
    private OptionalBoolean sun = OptionalBoolean.DEFAULT;
    private OptionalBoolean moon = OptionalBoolean.DEFAULT;
    private OptionalBoolean vignette = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceSolid = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceCutout = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceCutoutMipped = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceTranslucent = OptionalBoolean.DEFAULT;
    private OptionalBoolean rainDepth = OptionalBoolean.DEFAULT;
    private OptionalBoolean concurrentCompute = OptionalBoolean.DEFAULT;
    private OptionalBoolean beaconBeamDepth = OptionalBoolean.DEFAULT;
    private OptionalBoolean separateAo = OptionalBoolean.DEFAULT;
    private OptionalBoolean voxelizeLightBlocks = OptionalBoolean.DEFAULT;
    private OptionalBoolean separateEntityDraws = OptionalBoolean.DEFAULT;
    private OptionalBoolean frustumCulling = OptionalBoolean.DEFAULT;
    private ShadowCullState shadowCulling = ShadowCullState.DEFAULT;
    private OptionalBoolean shadowEnabled = OptionalBoolean.DEFAULT;
    private Optional<ParticleRenderingSettings> particleRenderingSettings = Optional.empty();
    private OptionalBoolean prepareBeforeShadow = OptionalBoolean.DEFAULT;
    private List<String> sliderOptions = new ArrayList<String>();
    private final Map<String, List<String>> profiles = new LinkedHashMap<String, List<String>>();
    private List<String> mainScreenOptions = null;
    private final Map<String, List<String>> subScreenOptions = new HashMap<String, List<String>>();
    private Integer mainScreenColumnCount = null;
    private final Map<String, Integer> subScreenColumnCount = new HashMap<String, Integer>();
    private final Object2ObjectMap<String, AlphaTest> alphaTestOverrides = new Object2ObjectOpenHashMap();
    private final Object2FloatMap<String> viewportScaleOverrides = new Object2FloatOpenHashMap();
    private final Object2ObjectMap<String, TextureScaleOverride> textureScaleOverrides = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, BlendModeOverride> blendModeOverrides = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, ArrayList<BufferBlendInformation>> bufferBlendOverrides = new Object2ObjectOpenHashMap();
    private final EnumMap<TextureStage, Object2ObjectMap<String, TextureDefinition>> customTextures = new EnumMap(TextureStage.class);
    private final Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> customTexturePatching = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, TextureDefinition> irisCustomTextures = new Object2ObjectOpenHashMap();
    private final List<ImageInformation> irisCustomImages = new ArrayList<ImageInformation>();
    private final Int2ObjectArrayMap<ShaderStorageInfo> bufferObjects = new Int2ObjectArrayMap();
    private final Object2ObjectMap<String, Object2BooleanMap<String>> explicitFlips = new Object2ObjectOpenHashMap();
    private String noiseTexturePath = null;
    CustomUniforms.Builder customUniforms = new CustomUniforms.Builder();
    private Object2ObjectMap<String, String> conditionallyEnabledPrograms = new Object2ObjectOpenHashMap();
    private List<String> requiredFeatureFlags = new ArrayList<String>();
    private List<String> optionalFeatureFlags = new ArrayList<String>();

    private ShaderProperties() {
    }

    public ShaderProperties(String string, ShaderPackOptions shaderPackOptions, Iterable<StringPair> iterable) {
        String string2 = PropertiesPreprocessor.preprocessSource(string, shaderPackOptions, iterable);
        OrderBackedProperties orderBackedProperties = new OrderBackedProperties();
        OrderBackedProperties orderBackedProperties2 = new OrderBackedProperties();
        try {
            orderBackedProperties.load(new StringReader(string2));
            orderBackedProperties2.load(new StringReader(string));
        }
        catch (IOException iOException) {
            Iris.logger.error("Error loading shaders.properties!", iOException);
        }
        ((Properties)orderBackedProperties).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> {
            String string = (String)object;
            String string5 = (String)object2;
            if ("texture.noise".equals(string)) {
                this.noiseTexturePath = string5;
                return;
            }
            if ("clouds".equals(string)) {
                if ("off".equals(string5)) {
                    this.cloudSetting = CloudSetting.OFF;
                } else if ("fast".equals(string5)) {
                    this.cloudSetting = CloudSetting.FAST;
                } else if ("fancy".equals(string5)) {
                    this.cloudSetting = CloudSetting.FANCY;
                } else {
                    Iris.logger.error("Unrecognized clouds setting: " + string5);
                }
            }
            if ("shadow.culling".equals(string)) {
                if ("false".equals(string5)) {
                    this.shadowCulling = ShadowCullState.DISTANCE;
                } else if ("true".equals(string5)) {
                    this.shadowCulling = ShadowCullState.ADVANCED;
                } else if ("reversed".equals(string5)) {
                    this.shadowCulling = ShadowCullState.REVERSED;
                } else {
                    Iris.logger.error("Unrecognized shadow culling setting: " + string5);
                }
            }
            ShaderProperties.handleBooleanDirective(string, string5, "oldHandLight", optionalBoolean -> {
                this.oldHandLight = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "dynamicHandLight", optionalBoolean -> {
                this.dynamicHandLight = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "oldLighting", optionalBoolean -> {
                this.oldLighting = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "shadowTerrain", optionalBoolean -> {
                this.shadowTerrain = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "shadowTranslucent", optionalBoolean -> {
                this.shadowTranslucent = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "shadowEntities", optionalBoolean -> {
                this.shadowEntities = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "shadowPlayer", optionalBoolean -> {
                this.shadowPlayer = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "shadowBlockEntities", optionalBoolean -> {
                this.shadowBlockEntities = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "underwaterOverlay", optionalBoolean -> {
                this.underwaterOverlay = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "sun", optionalBoolean -> {
                this.sun = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "moon", optionalBoolean -> {
                this.moon = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "vignette", optionalBoolean -> {
                this.vignette = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "backFace.solid", optionalBoolean -> {
                this.backFaceSolid = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "backFace.cutout", optionalBoolean -> {
                this.backFaceCutout = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "backFace.cutoutMipped", optionalBoolean -> {
                this.backFaceCutoutMipped = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "backFace.translucent", optionalBoolean -> {
                this.backFaceTranslucent = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "rain.depth", optionalBoolean -> {
                this.rainDepth = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "allowConcurrentCompute", optionalBoolean -> {
                this.concurrentCompute = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "beacon.beam.depth", optionalBoolean -> {
                this.beaconBeamDepth = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "separateAo", optionalBoolean -> {
                this.separateAo = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "voxelizeLightBlocks", optionalBoolean -> {
                this.voxelizeLightBlocks = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "separateEntityDraws", optionalBoolean -> {
                this.separateEntityDraws = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "frustum.culling", optionalBoolean -> {
                this.frustumCulling = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "shadow.enabled", optionalBoolean -> {
                this.shadowEnabled = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "particles.before.deferred", optionalBoolean -> {
                if (optionalBoolean.orElse(false) && this.particleRenderingSettings.isEmpty()) {
                    this.particleRenderingSettings = Optional.of(ParticleRenderingSettings.BEFORE);
                }
            });
            ShaderProperties.handleBooleanDirective(string, string5, "prepareBeforeShadow", optionalBoolean -> {
                this.prepareBeforeShadow = optionalBoolean;
            });
            ShaderProperties.handleBooleanDirective(string, string5, "supportsColorCorrection", optionalBoolean -> {
                this.supportsColorCorrection = optionalBoolean;
            });
            if (string.startsWith("particles.ordering")) {
                Optional<ParticleRenderingSettings> optional = ParticleRenderingSettings.fromString(string5.trim().toUpperCase(Locale.US));
                if (optional.isPresent()) {
                    this.particleRenderingSettings = optional;
                } else {
                    throw new RuntimeException("Failed to parse particle rendering order! " + string5);
                }
            }
            ShaderProperties.handlePassDirective("scale.", string, string5, string2 -> {
                float f;
                try {
                    f = Float.parseFloat(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    Iris.logger.error("Unable to parse scale directive for " + string2 + ": " + string5, numberFormatException);
                    return;
                }
                this.viewportScaleOverrides.put(string2, f);
            });
            ShaderProperties.handlePassDirective("size.buffer.", string, string5, string2 -> {
                String[] stringArray = string5.split(" ");
                if (stringArray.length != 2) {
                    Iris.logger.error("Unable to parse size.buffer directive for " + string2 + ": " + string5);
                    return;
                }
                this.textureScaleOverrides.put(string2, (Object)new TextureScaleOverride(stringArray[0], stringArray[1]));
            });
            ShaderProperties.handlePassDirective("alphaTest.", string, string5, string2 -> {
                float f;
                if ("off".equals(string5) || "false".equals(string5)) {
                    this.alphaTestOverrides.put(string2, (Object)AlphaTest.ALWAYS);
                    return;
                }
                String[] stringArray = string5.split(" ");
                if (stringArray.length > 2) {
                    Iris.logger.warn("Weird alpha test directive for " + string2 + " contains more parts than we expected: " + string5);
                } else if (stringArray.length < 2) {
                    Iris.logger.error("Invalid alpha test directive for " + string2 + ": " + string5);
                    return;
                }
                Optional<AlphaTestFunction> optional = AlphaTestFunction.fromString(stringArray[0]);
                if (!optional.isPresent()) {
                    Iris.logger.error("Unable to parse alpha test directive for " + string2 + ", unknown alpha test function " + stringArray[0] + ": " + string5);
                    return;
                }
                try {
                    f = Float.parseFloat(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    Iris.logger.error("Unable to parse alpha test directive for " + string2 + ": " + string5, numberFormatException);
                    return;
                }
                this.alphaTestOverrides.put(string2, (Object)new AlphaTest(optional.get(), f));
            });
            ShaderProperties.handlePassDirective("blend.", string, string5, string2 -> {
                void var8_16;
                if (string2.contains(".")) {
                    Object object2;
                    if (!IrisRenderSystem.supportsBufferBlending()) {
                        throw new RuntimeException("Buffer blending is not supported on this platform, however it was attempted to be used!");
                    }
                    String[] stringArray = string2.split("\\.");
                    int n = PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.indexOf((Object)stringArray[1]);
                    if (n == -1 && stringArray[1].startsWith("colortex")) {
                        object2 = stringArray[1].substring("colortex".length());
                        try {
                            n = Integer.parseInt((String)object2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new RuntimeException("Failed to parse buffer blend!", numberFormatException);
                        }
                    }
                    if (n == -1) {
                        throw new RuntimeException("Failed to parse buffer blend! index = " + n);
                    }
                    if ("off".equals(string5)) {
                        ((ArrayList)this.bufferBlendOverrides.computeIfAbsent((Object)stringArray[0], object -> new ArrayList())).add(new BufferBlendInformation(n, null));
                        return;
                    }
                    object2 = string5.split(" ");
                    int[] nArray = new int[((String[])object2).length];
                    int n2 = 0;
                    for (String string3 : object2) {
                        nArray[n2] = BlendModeFunction.fromString(string3).get().getGlId();
                        ++n2;
                    }
                    ((ArrayList)this.bufferBlendOverrides.computeIfAbsent((Object)stringArray[0], object -> new ArrayList())).add(new BufferBlendInformation(n, new BlendMode(nArray[0], nArray[1], nArray[2], nArray[3])));
                    return;
                }
                if ("off".equals(string5)) {
                    this.blendModeOverrides.put(string2, (Object)BlendModeOverride.OFF);
                    return;
                }
                String[] stringArray = string5.split(" ");
                int[] nArray = new int[stringArray.length];
                int n = 0;
                String[] stringArray2 = stringArray;
                int n2 = stringArray2.length;
                boolean bl = false;
                while (var8_16 < n2) {
                    String string4 = stringArray2[var8_16];
                    nArray[n] = BlendModeFunction.fromString(string4).get().getGlId();
                    ++n;
                    ++var8_16;
                }
                this.blendModeOverrides.put(string2, (Object)new BlendModeOverride(new BlendMode(nArray[0], nArray[1], nArray[2], nArray[3])));
            });
            ShaderProperties.handleProgramEnabledDirective("program.", string, string5, string2 -> this.conditionallyEnabledPrograms.put(string2, (Object)string5));
            ShaderProperties.handlePassDirective("bufferObject.", string, string5, string2 -> {
                String[] stringArray = string5.split(" ");
                if (stringArray.length == 1) {
                    int n;
                    int n2;
                    try {
                        n2 = Integer.parseInt(string2);
                        n = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Iris.logger.error("Number format exception parsing SSBO index/size!", numberFormatException);
                        return;
                    }
                    if (n2 > 8) {
                        Iris.logger.fatal("SSBO's cannot use buffer numbers higher than 8, they're reserved!");
                        return;
                    }
                    this.bufferObjects.put(n2, (Object)new ShaderStorageInfo(n, false, 0.0f, 0.0f));
                } else {
                    float f;
                    float f2;
                    boolean bl;
                    int n;
                    int n3;
                    try {
                        n3 = Integer.parseInt(string2);
                        n = Integer.parseInt(stringArray[0]);
                        bl = Boolean.parseBoolean(stringArray[1]);
                        f2 = Float.parseFloat(stringArray[2]);
                        f = Float.parseFloat(stringArray[3]);
                    }
                    catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
                        Iris.logger.error("Number format exception parsing SSBO index/size, or not correct format!", runtimeException);
                        return;
                    }
                    if (n3 > 8) {
                        Iris.logger.fatal("SSBO's cannot use buffer numbers higher than 8, they're reserved!");
                        return;
                    }
                    this.bufferObjects.put(n3, (Object)new ShaderStorageInfo(n, bl, f2, f));
                }
            });
            ShaderProperties.handleTwoArgDirective("texture.", string, string5, (string3, string4) -> {
                String[] stringArray = string5.split(" ");
                string4 = string4.split("\\.")[0];
                Optional<TextureStage> optional = TextureStage.parse(string3);
                if (!optional.isPresent()) {
                    Iris.logger.warn("Unknown texture stage \"" + string3 + "\", ignoring custom texture directive for " + string);
                    return;
                }
                TextureStage textureStage2 = optional.get();
                if (stringArray.length > 1) {
                    String string5 = "customtex" + this.customTexAmount;
                    ++this.customTexAmount;
                    TextureType textureType = null;
                    if (stringArray.length == 6) {
                        textureType = TextureType.TEXTURE_1D;
                        this.irisCustomTextures.put((Object)string5, (Object)new TextureDefinition.RawDefinition(stringArray[0], TextureType.valueOf(stringArray[1].toUpperCase(Locale.ROOT)), InternalTextureFormat.fromString(stringArray[2]).orElseThrow(IllegalArgumentException::new), Integer.parseInt(stringArray[3]), 0, 0, PixelFormat.fromString(stringArray[4]).orElseThrow(IllegalArgumentException::new), PixelType.fromString(stringArray[5]).orElseThrow(IllegalArgumentException::new)));
                    } else if (stringArray.length == 7) {
                        textureType = TextureType.valueOf(stringArray[1].toUpperCase(Locale.ROOT));
                        this.irisCustomTextures.put((Object)string5, (Object)new TextureDefinition.RawDefinition(stringArray[0], TextureType.valueOf(stringArray[1].toUpperCase(Locale.ROOT)), InternalTextureFormat.fromString(stringArray[2]).orElseThrow(IllegalArgumentException::new), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]), 0, PixelFormat.fromString(stringArray[5]).orElseThrow(IllegalArgumentException::new), PixelType.fromString(stringArray[6]).orElseThrow(IllegalArgumentException::new)));
                    } else if (stringArray.length == 8) {
                        textureType = TextureType.TEXTURE_3D;
                        this.irisCustomTextures.put((Object)string5, (Object)new TextureDefinition.RawDefinition(stringArray[0], TextureType.valueOf(stringArray[1].toUpperCase(Locale.ROOT)), InternalTextureFormat.fromString(stringArray[2]).orElseThrow(IllegalArgumentException::new), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]), Integer.parseInt(stringArray[5]), PixelFormat.fromString(stringArray[6]).orElseThrow(IllegalArgumentException::new), PixelType.fromString(stringArray[7]).orElseThrow(IllegalArgumentException::new)));
                    } else {
                        Iris.logger.warn("Unknown texture directive for " + string + ": " + string5);
                    }
                    this.customTexturePatching.put(new Tri<String, TextureType, TextureStage>((String)string4, textureType, textureStage2), (Object)string5);
                    return;
                }
                this.customTextures.computeIfAbsent(textureStage2, textureStage -> new Object2ObjectOpenHashMap()).put(string4, (Object)new TextureDefinition.PNGDefinition(string5));
            });
            ShaderProperties.handlePassDirective("customTexture.", string, string5, string3 -> {
                String[] stringArray = string5.split(" ");
                if (stringArray.length > 1) {
                    if (stringArray.length == 6) {
                        this.irisCustomTextures.put(string3, (Object)new TextureDefinition.RawDefinition(stringArray[0], TextureType.valueOf(stringArray[1].toUpperCase(Locale.ROOT)), InternalTextureFormat.fromString(stringArray[2]).orElseThrow(IllegalArgumentException::new), Integer.parseInt(stringArray[3]), 0, 0, PixelFormat.fromString(stringArray[4]).orElseThrow(IllegalArgumentException::new), PixelType.fromString(stringArray[5]).orElseThrow(IllegalArgumentException::new)));
                    } else if (stringArray.length == 7) {
                        this.irisCustomTextures.put(string3, (Object)new TextureDefinition.RawDefinition(stringArray[0], TextureType.valueOf(stringArray[1].toUpperCase(Locale.ROOT)), InternalTextureFormat.fromString(stringArray[2]).orElseThrow(IllegalArgumentException::new), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]), 0, PixelFormat.fromString(stringArray[5]).orElseThrow(IllegalArgumentException::new), PixelType.fromString(stringArray[6]).orElseThrow(IllegalArgumentException::new)));
                    } else if (stringArray.length == 8) {
                        this.irisCustomTextures.put(string3, (Object)new TextureDefinition.RawDefinition(stringArray[0], TextureType.valueOf(stringArray[1].toUpperCase(Locale.ROOT)), InternalTextureFormat.fromString(stringArray[2]).orElseThrow(IllegalArgumentException::new), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]), Integer.parseInt(stringArray[5]), PixelFormat.fromString(stringArray[6]).orElseThrow(IllegalArgumentException::new), PixelType.fromString(stringArray[7]).orElseThrow(IllegalArgumentException::new)));
                    } else {
                        Iris.logger.warn("Unknown texture directive for " + string + ": " + string5);
                    }
                    return;
                }
                this.irisCustomTextures.put(string3, (Object)new TextureDefinition.PNGDefinition(string5));
            });
            ShaderProperties.handlePassDirective("image.", string, string5, string3 -> {
                ImageInformation imageInformation;
                String[] stringArray = string5.split(" ");
                String string4 = string.substring(6);
                if (this.irisCustomImages.size() > 15) {
                    Iris.logger.error("Only up to 16 images are allowed, but tried to add another image! " + string);
                    return;
                }
                String string5 = stringArray[0];
                if (string5.equals("none")) {
                    string5 = null;
                }
                PixelFormat pixelFormat = PixelFormat.fromString(stringArray[1]).orElse(null);
                InternalTextureFormat internalTextureFormat = InternalTextureFormat.fromString(stringArray[2]).orElse(null);
                PixelType pixelType = PixelType.fromString(stringArray[3]).orElse(null);
                if (pixelFormat == null || internalTextureFormat == null || pixelType == null) {
                    Iris.logger.error("Image " + string4 + " is invalid! Format: " + pixelFormat + " Internal format: " + internalTextureFormat + " Pixel type: " + pixelType);
                }
                boolean bl = Boolean.parseBoolean(stringArray[4]);
                boolean bl2 = Boolean.parseBoolean(stringArray[5]);
                if (bl2) {
                    float f = Float.parseFloat(stringArray[6]);
                    float f2 = Float.parseFloat(stringArray[7]);
                    imageInformation = new ImageInformation(string4, string5, TextureType.TEXTURE_2D, pixelFormat, internalTextureFormat, pixelType, 0, 0, 0, bl, true, f, f2);
                } else {
                    int n;
                    int n2;
                    int n3;
                    TextureType textureType;
                    if (stringArray.length == 7) {
                        textureType = TextureType.TEXTURE_1D;
                        n3 = Integer.parseInt(stringArray[6]);
                        n2 = 0;
                        n = 0;
                    } else if (stringArray.length == 8) {
                        textureType = TextureType.TEXTURE_2D;
                        n3 = Integer.parseInt(stringArray[6]);
                        n2 = Integer.parseInt(stringArray[7]);
                        n = 0;
                    } else if (stringArray.length == 9) {
                        textureType = TextureType.TEXTURE_3D;
                        n3 = Integer.parseInt(stringArray[6]);
                        n2 = Integer.parseInt(stringArray[7]);
                        n = Integer.parseInt(stringArray[8]);
                    } else {
                        Iris.logger.error("Unknown image type! " + string4 + " = " + string5);
                        return;
                    }
                    imageInformation = new ImageInformation(string4, string5, textureType, pixelFormat, internalTextureFormat, pixelType, n3, n2, n, bl, false, 0.0f, 0.0f);
                }
                this.irisCustomImages.add(imageInformation);
            });
            ShaderProperties.handleTwoArgDirective("flip.", string, string5, (string3, string4) -> ShaderProperties.handleBooleanValue(string, string5, bl -> ((Object2BooleanMap)this.explicitFlips.computeIfAbsent(string3, object -> new Object2BooleanOpenHashMap())).put(string4, bl)));
            ShaderProperties.handlePassDirective("variable.", string, string5, string3 -> {
                String[] stringArray = string3.split("\\.");
                if (stringArray.length != 2) {
                    Iris.logger.warn("Custom variables should take the form of `variable.<type>.<name> = <expression>. Ignoring " + string);
                    return;
                }
                this.customUniforms.addVariable(stringArray[0], stringArray[1], string5, false);
            });
            ShaderProperties.handlePassDirective("uniform.", string, string5, string3 -> {
                String[] stringArray = string3.split("\\.");
                if (stringArray.length != 2) {
                    Iris.logger.warn("Custom uniforms should take the form of `uniform.<type>.<name> = <expression>. Ignoring " + string);
                    return;
                }
                this.customUniforms.addVariable(stringArray[0], stringArray[1], string5, true);
            });
            ShaderProperties.handleWhitespacedListDirective(string, string5, "iris.features.required", list -> {
                this.requiredFeatureFlags = list;
            });
            ShaderProperties.handleWhitespacedListDirective(string, string5, "iris.features.optional", list -> {
                this.optionalFeatureFlags = list;
            });
        }));
        ((Properties)orderBackedProperties2).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> {
            String string = (String)object;
            String string2 = (String)object2;
            ShaderProperties.handleWhitespacedListDirective(string, string2, "sliders", list -> {
                this.sliderOptions = list;
            });
            ShaderProperties.handlePrefixedWhitespacedListDirective("profile.", string, string2, this.profiles::put);
            if (ShaderProperties.handleIntDirective(string, string2, "screen.columns", n -> {
                this.mainScreenColumnCount = n;
            })) {
                return;
            }
            if (ShaderProperties.handleAffixedIntDirective("screen.", ".columns", string, string2, this.subScreenColumnCount::put)) {
                return;
            }
            ShaderProperties.handleWhitespacedListDirective(string, string2, "screen", list -> {
                this.mainScreenOptions = list;
            });
            ShaderProperties.handlePrefixedWhitespacedListDirective("screen.", string, string2, this.subScreenOptions::put);
        }));
    }

    private static void handleBooleanValue(String string, String string2, BooleanConsumer booleanConsumer) {
        if ("true".equals(string2)) {
            booleanConsumer.accept(true);
        } else if ("false".equals(string2)) {
            booleanConsumer.accept(false);
        } else {
            Iris.logger.warn("Unexpected value for boolean key " + string + " in shaders.properties: got " + string2 + ", but expected either true or false");
        }
    }

    private static void handleBooleanDirective(String string, String string2, String string3, Consumer<OptionalBoolean> consumer) {
        if (!string3.equals(string)) {
            return;
        }
        if ("true".equals(string2)) {
            consumer.accept(OptionalBoolean.TRUE);
        } else if ("false".equals(string2)) {
            consumer.accept(OptionalBoolean.FALSE);
        } else {
            Iris.logger.warn("Unexpected value for boolean key " + string + " in shaders.properties: got " + string2 + ", but expected either true or false");
        }
    }

    private static boolean handleIntDirective(String string, String string2, String string3, Consumer<Integer> consumer) {
        if (!string3.equals(string)) {
            return false;
        }
        try {
            int n = Integer.parseInt(string2);
            consumer.accept(n);
        }
        catch (NumberFormatException numberFormatException) {
            Iris.logger.warn("Unexpected value for integer key " + string + " in shaders.properties: got " + string2 + ", but expected an integer");
        }
        return true;
    }

    private static boolean handleAffixedIntDirective(String string, String string2, String string3, String string4, BiConsumer<String, Integer> biConsumer) {
        if (string3.startsWith(string) && string3.endsWith(string2)) {
            int n = string.length();
            int n2 = string3.length() - string2.length();
            if (n2 <= n) {
                return false;
            }
            String string5 = string3.substring(n, n2);
            try {
                int n3 = Integer.parseInt(string4);
                biConsumer.accept(string5, n3);
            }
            catch (NumberFormatException numberFormatException) {
                Iris.logger.warn("Unexpected value for integer key " + string3 + " in shaders.properties: got " + string4 + ", but expected an integer");
            }
            return true;
        }
        return false;
    }

    private static void handlePassDirective(String string, String string2, String string3, Consumer<String> consumer) {
        if (string2.startsWith(string)) {
            String string4 = string2.substring(string.length());
            consumer.accept(string4);
        }
    }

    private static void handleProgramEnabledDirective(String string, String string2, String string3, Consumer<String> consumer) {
        if (string2.startsWith(string)) {
            String string4 = string2.substring(string.length(), string2.indexOf(".", string.length()));
            consumer.accept(string4);
        }
    }

    private static void handleWhitespacedListDirective(String string, String string2, String string3, Consumer<List<String>> consumer) {
        if (!string3.equals(string)) {
            return;
        }
        String[] stringArray = string2.split(" +");
        consumer.accept(Arrays.asList(stringArray));
    }

    private static void handlePrefixedWhitespacedListDirective(String string, String string2, String string3, BiConsumer<String, List<String>> biConsumer) {
        if (string2.startsWith(string)) {
            String string4 = string2.substring(string.length());
            String[] stringArray = string3.split(" +");
            biConsumer.accept(string4, Arrays.asList(stringArray));
        }
    }

    private static void handleTwoArgDirective(String string, String string2, String string3, BiConsumer<String, String> biConsumer) {
        if (string2.startsWith(string)) {
            int n = string2.indexOf(".", string.length());
            String string4 = string2.substring(string.length(), n);
            String string5 = string2.substring(n + 1);
            biConsumer.accept(string4, string5);
        }
    }

    public static ShaderProperties empty() {
        return new ShaderProperties();
    }

    public CloudSetting getCloudSetting() {
        return this.cloudSetting;
    }

    public OptionalBoolean getOldHandLight() {
        return this.oldHandLight;
    }

    public OptionalBoolean getDynamicHandLight() {
        return this.dynamicHandLight;
    }

    public OptionalBoolean getOldLighting() {
        return this.oldLighting;
    }

    public OptionalBoolean getShadowTerrain() {
        return this.shadowTerrain;
    }

    public OptionalBoolean getShadowTranslucent() {
        return this.shadowTranslucent;
    }

    public OptionalBoolean getShadowEntities() {
        return this.shadowEntities;
    }

    public OptionalBoolean getShadowPlayer() {
        return this.shadowPlayer;
    }

    public OptionalBoolean getShadowBlockEntities() {
        return this.shadowBlockEntities;
    }

    public OptionalBoolean getUnderwaterOverlay() {
        return this.underwaterOverlay;
    }

    public OptionalBoolean getSun() {
        return this.sun;
    }

    public OptionalBoolean getMoon() {
        return this.moon;
    }

    public OptionalBoolean getVignette() {
        return this.vignette;
    }

    public OptionalBoolean getBackFaceSolid() {
        return this.backFaceSolid;
    }

    public OptionalBoolean getBackFaceCutout() {
        return this.backFaceCutout;
    }

    public OptionalBoolean getBackFaceCutoutMipped() {
        return this.backFaceCutoutMipped;
    }

    public OptionalBoolean getBackFaceTranslucent() {
        return this.backFaceTranslucent;
    }

    public OptionalBoolean getRainDepth() {
        return this.rainDepth;
    }

    public OptionalBoolean getBeaconBeamDepth() {
        return this.beaconBeamDepth;
    }

    public OptionalBoolean getSeparateAo() {
        return this.separateAo;
    }

    public OptionalBoolean getVoxelizeLightBlocks() {
        return this.voxelizeLightBlocks;
    }

    public OptionalBoolean getSeparateEntityDraws() {
        return this.separateEntityDraws;
    }

    public OptionalBoolean getFrustumCulling() {
        return this.frustumCulling;
    }

    public ShadowCullState getShadowCulling() {
        return this.shadowCulling;
    }

    public Object2ObjectMap<String, AlphaTest> getAlphaTestOverrides() {
        return this.alphaTestOverrides;
    }

    public OptionalBoolean getShadowEnabled() {
        return this.shadowEnabled;
    }

    public Optional<ParticleRenderingSettings> getParticleRenderingSettings() {
        if (this.separateEntityDraws == OptionalBoolean.TRUE) {
            return Optional.of(ParticleRenderingSettings.MIXED);
        }
        return this.particleRenderingSettings;
    }

    public OptionalBoolean getConcurrentCompute() {
        return this.concurrentCompute;
    }

    public OptionalBoolean getPrepareBeforeShadow() {
        return this.prepareBeforeShadow;
    }

    public Object2FloatMap<String> getViewportScaleOverrides() {
        return this.viewportScaleOverrides;
    }

    public Object2ObjectMap<String, TextureScaleOverride> getTextureScaleOverrides() {
        return this.textureScaleOverrides;
    }

    public Object2ObjectMap<String, BlendModeOverride> getBlendModeOverrides() {
        return this.blendModeOverrides;
    }

    public Object2ObjectMap<String, ArrayList<BufferBlendInformation>> getBufferBlendOverrides() {
        return this.bufferBlendOverrides;
    }

    public Int2ObjectArrayMap<ShaderStorageInfo> getBufferObjects() {
        return this.bufferObjects;
    }

    public EnumMap<TextureStage, Object2ObjectMap<String, TextureDefinition>> getCustomTextures() {
        return this.customTextures;
    }

    public Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> getCustomTexturePatching() {
        return this.customTexturePatching;
    }

    public Object2ObjectMap<String, TextureDefinition> getIrisCustomTextures() {
        return this.irisCustomTextures;
    }

    public List<ImageInformation> getIrisCustomImages() {
        return this.irisCustomImages;
    }

    public Optional<String> getNoiseTexturePath() {
        return Optional.ofNullable(this.noiseTexturePath);
    }

    public Object2ObjectMap<String, String> getConditionallyEnabledPrograms() {
        return this.conditionallyEnabledPrograms;
    }

    public List<String> getSliderOptions() {
        return this.sliderOptions;
    }

    public Map<String, List<String>> getProfiles() {
        return this.profiles;
    }

    public Optional<List<String>> getMainScreenOptions() {
        return Optional.ofNullable(this.mainScreenOptions);
    }

    public Map<String, List<String>> getSubScreenOptions() {
        return this.subScreenOptions;
    }

    public Optional<Integer> getMainScreenColumnCount() {
        return Optional.ofNullable(this.mainScreenColumnCount);
    }

    public Map<String, Integer> getSubScreenColumnCount() {
        return this.subScreenColumnCount;
    }

    public Object2ObjectMap<String, Object2BooleanMap<String>> getExplicitFlips() {
        return this.explicitFlips;
    }

    public List<String> getRequiredFeatureFlags() {
        return this.requiredFeatureFlags;
    }

    public List<String> getOptionalFeatureFlags() {
        return this.optionalFeatureFlags;
    }

    public OptionalBoolean supportsColorCorrection() {
        return this.supportsColorCorrection;
    }
}

