/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import net.coderbot.iris.Iris;
import net.coderbot.iris.mixin.texture.AnimationMetadataSectionAccessor;
import net.coderbot.iris.mixin.texture.TextureAtlasAccessor;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.texture.mipmap.ChannelMipmapGenerator;
import net.coderbot.iris.texture.mipmap.CustomMipmapGenerator;
import net.coderbot.iris.texture.mipmap.LinearBlendFunction;
import net.coderbot.iris.texture.pbr.PBRAtlasTexture;
import net.coderbot.iris.texture.pbr.PBRSpriteHolder;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.texture.pbr.SpriteContentsExtension;
import net.coderbot.iris.texture.pbr.loader.PBRTextureLoader;
import net.coderbot.iris.texture.util.ImageManipulationUtil;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_7368;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import org.jetbrains.annotations.Nullable;

public class AtlasPBRLoader
implements PBRTextureLoader<class_1059> {
    public static final ChannelMipmapGenerator LINEAR_MIPMAP_GENERATOR = new ChannelMipmapGenerator(LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE);

    @Override
    public void load(class_1059 class_10592, class_3300 class_33002, PBRTextureLoader.PBRTextureConsumer pBRTextureConsumer) {
        TextureAtlasAccessor textureAtlasAccessor = (TextureAtlasAccessor)class_10592;
        int n = textureAtlasAccessor.callGetWidth();
        int n2 = textureAtlasAccessor.callGetHeight();
        int n3 = textureAtlasAccessor.getMipLevel();
        PBRAtlasTexture pBRAtlasTexture = null;
        PBRAtlasTexture pBRAtlasTexture2 = null;
        for (class_1058 class_10582 : ((TextureAtlasAccessor)class_10592).getTexturesByName().values()) {
            PBRSpriteHolder pBRSpriteHolder;
            PBRTextureAtlasSprite pBRTextureAtlasSprite = this.createPBRSprite(class_10582, class_33002, class_10592, n, n2, n3, PBRType.NORMAL);
            PBRTextureAtlasSprite pBRTextureAtlasSprite2 = this.createPBRSprite(class_10582, class_33002, class_10592, n, n2, n3, PBRType.SPECULAR);
            if (pBRTextureAtlasSprite != null) {
                if (pBRAtlasTexture == null) {
                    pBRAtlasTexture = new PBRAtlasTexture(class_10592, PBRType.NORMAL);
                }
                pBRAtlasTexture.addSprite(pBRTextureAtlasSprite);
                pBRSpriteHolder = ((SpriteContentsExtension)class_10582.method_45851()).getOrCreatePBRHolder();
                pBRSpriteHolder.setNormalSprite(pBRTextureAtlasSprite);
            }
            if (pBRTextureAtlasSprite2 == null) continue;
            if (pBRAtlasTexture2 == null) {
                pBRAtlasTexture2 = new PBRAtlasTexture(class_10592, PBRType.SPECULAR);
            }
            pBRAtlasTexture2.addSprite(pBRTextureAtlasSprite2);
            pBRSpriteHolder = ((SpriteContentsExtension)class_10582.method_45851()).getOrCreatePBRHolder();
            pBRSpriteHolder.setSpecularSprite(pBRTextureAtlasSprite2);
        }
        if (pBRAtlasTexture != null && pBRAtlasTexture.tryUpload(n, n2, n3)) {
            pBRTextureConsumer.acceptNormalTexture(pBRAtlasTexture);
        }
        if (pBRAtlasTexture2 != null && pBRAtlasTexture2.tryUpload(n, n2, n3)) {
            pBRTextureConsumer.acceptSpecularTexture(pBRAtlasTexture2);
        }
    }

    @Nullable
    protected PBRTextureAtlasSprite createPBRSprite(class_1058 class_10582, class_3300 class_33002, class_1059 class_10592, int n, int n2, int n3, PBRType pBRType) {
        class_1011 class_10112;
        class_7368 class_73682;
        class_2960 class_29602 = class_10582.method_45851().method_45816();
        class_2960 class_29603 = this.getPBRImageLocation(class_29602, pBRType);
        Optional optional = class_33002.method_14486(class_29603);
        if (!optional.isPresent()) {
            return null;
        }
        class_3298 class_32982 = (class_3298)optional.get();
        try {
            class_73682 = class_32982.method_14481();
        }
        catch (Exception exception) {
            Iris.logger.error("Unable to parse metadata from {}", class_29603, exception);
            return null;
        }
        try (InputStream inputStream = class_32982.method_14482();){
            class_10112 = class_1011.method_4309((InputStream)inputStream);
        }
        catch (IOException iOException) {
            Iris.logger.error("Using missing texture, unable to load {}", class_29603, iOException);
            return null;
        }
        int n4 = class_10112.method_4307();
        int n5 = class_10112.method_4323();
        class_1079 class_10792 = class_73682.method_43041((class_3270)class_1079.field_5337).orElse(class_1079.field_21768);
        class_7771 class_77712 = class_10792.method_24143(n4, n5);
        int n6 = class_77712.comp_1049();
        int n7 = class_77712.comp_1050();
        if (!class_3532.method_48117((int)n4, (int)n6) || !class_3532.method_48117((int)n5, (int)n7)) {
            Iris.logger.error("Image {} size {},{} is not multiple of frame size {},{}", class_29603, n4, n5, n6, n7);
            class_10112.close();
            return null;
        }
        int n8 = class_10582.method_45851().method_45807();
        int n9 = class_10582.method_45851().method_45815();
        if (n6 != n8 || n7 != n9) {
            try {
                int n10 = n4 / n6 * n8;
                int n11 = n5 / n7 * n9;
                class_1011 class_10113 = n10 % n4 == 0 && n11 % n5 == 0 ? ImageManipulationUtil.scaleNearestNeighbor(class_10112, n10, n11) : ImageManipulationUtil.scaleBilinear(class_10112, n10, n11);
                class_10112.close();
                class_10112 = class_10113;
                n6 = n8;
                n7 = n9;
                if (class_10792 != class_1079.field_21768) {
                    AnimationMetadataSectionAccessor animationMetadataSectionAccessor = (AnimationMetadataSectionAccessor)class_10792;
                    int n12 = animationMetadataSectionAccessor.getFrameWidth();
                    int n13 = animationMetadataSectionAccessor.getFrameHeight();
                    if (n12 != -1) {
                        animationMetadataSectionAccessor.setFrameWidth(n6);
                    }
                    if (n13 != -1) {
                        animationMetadataSectionAccessor.setFrameHeight(n7);
                    }
                }
            }
            catch (Exception exception) {
                Iris.logger.error("Something bad happened trying to load PBR texture " + class_29602.method_12832() + pBRType.getSuffix() + "!", exception);
                throw exception;
            }
        }
        class_2960 class_29604 = new class_2960(class_29602.method_12836(), class_29602.method_12832() + pBRType.getSuffix());
        PBRSpriteContents pBRSpriteContents = new PBRSpriteContents(class_29604, new class_7771(n6, n7), class_10112, class_73682, pBRType);
        pBRSpriteContents.method_45808(n3);
        return new PBRTextureAtlasSprite(class_29604, pBRSpriteContents, n, n2, class_10582.method_35806(), class_10582.method_35807(), class_10582);
    }

    protected class_2960 getPBRImageLocation(class_2960 class_29602, PBRType pBRType) {
        String string = pBRType.appendSuffix(class_29602.method_12832());
        if (string.startsWith("optifine/cit/")) {
            return new class_2960(class_29602.method_12836(), string + ".png");
        }
        return new class_2960(class_29602.method_12836(), "textures/" + string + ".png");
    }

    public static class PBRTextureAtlasSprite
    extends class_1058 {
        protected final class_1058 baseSprite;

        protected PBRTextureAtlasSprite(class_2960 class_29602, PBRSpriteContents pBRSpriteContents, int n, int n2, int n3, int n4, class_1058 class_10582) {
            super(class_29602, (class_7764)pBRSpriteContents, n, n2, n3, n4);
            this.baseSprite = class_10582;
        }

        public class_1058 getBaseSprite() {
            return this.baseSprite;
        }
    }

    protected static class PBRSpriteContents
    extends class_7764
    implements CustomMipmapGenerator.Provider {
        protected final PBRType pbrType;

        public PBRSpriteContents(class_2960 class_29602, class_7771 class_77712, class_1011 class_10112, class_7368 class_73682, PBRType pBRType) {
            super(class_29602, class_77712, class_10112, class_73682);
            this.pbrType = pBRType;
        }

        @Override
        public CustomMipmapGenerator getMipmapGenerator() {
            CustomMipmapGenerator customMipmapGenerator;
            TextureFormat textureFormat = TextureFormatLoader.getFormat();
            if (textureFormat != null && (customMipmapGenerator = textureFormat.getMipmapGenerator(this.pbrType)) != null) {
                return customMipmapGenerator;
            }
            return LINEAR_MIPMAP_GENERATOR;
        }
    }
}

