/*
 * Decompiled with CFR 0.152.
 */
package dev.plasticstraw.inf_music.screen;

import dev.plasticstraw.inf_music.config.InfiniteMusicConfig;
import dev.plasticstraw.inf_music.config.widget.BooleanButton;
import dev.plasticstraw.inf_music.config.widget.IntegerSlider;
import dev.plasticstraw.inf_music.config.widget.PresetButton;
import dev.plasticstraw.inf_music.screen.AbstractOptionsScreen;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7172;
import net.minecraft.class_7940;

public class MusicDelayOptions
extends AbstractOptionsScreen {
    private final InfiniteMusicConfig.MusicOptions musicOptions;
    private final int maxIntValue;
    private final int secondsStep;
    private final String valueTranslationKey;
    private PresetButton presetButton;
    private BooleanButton disableMusicButton;
    private IntegerSlider delaySlider;
    private IntegerSlider randomnessSlider;
    private class_7940 contextTextWidget;

    public MusicDelayOptions(class_437 parent, String titleTranslationKey, InfiniteMusicConfig.MusicOptions musicOptions) {
        super(parent, titleTranslationKey);
        this.musicOptions = musicOptions;
        if (musicOptions.usesMinutes()) {
            this.maxIntValue = 15;
            this.secondsStep = 60;
            this.valueTranslationKey = "minute";
        } else {
            this.maxIntValue = 120;
            this.secondsStep = 1;
            this.valueTranslationKey = "second";
        }
    }

    @Override
    protected void initWidgets() {
        this.presetButton = new PresetButton("inf_music.config.delayPreset", this.getPresetTranslationKey(this.musicOptions.delay, this.musicOptions.randomness), () -> {
            if (this.musicOptions.delay == 0 && this.musicOptions.randomness == 0) {
                this.delaySlider.getSimpleOption().method_41748((Object)(this.musicOptions.getDefaultDelay() / this.secondsStep));
                this.randomnessSlider.getSimpleOption().method_41748((Object)(this.musicOptions.getDefaultRandomness() / this.secondsStep));
            } else {
                this.delaySlider.getSimpleOption().method_41748((Object)0);
                this.randomnessSlider.getSimpleOption().method_41748((Object)0);
            }
            this.method_41843();
        });
        this.disableMusicButton = new BooleanButton("inf_music.config.disableMusic", this.musicOptions.enabled, value -> value != false ? class_2561.method_43471((String)"inf_music.config.disableMusic.enabled") : class_2561.method_43471((String)"inf_music.config.disableMusic.disabled"), value -> {
            this.musicOptions.enabled = value;
        });
        this.delaySlider = new IntegerSlider("inf_music.config.delay", 0, this.maxIntValue, this.musicOptions.delay / this.secondsStep, value -> this.getValueText(value * this.secondsStep), value -> {
            int seconds = value * this.secondsStep;
            this.presetButton.setValueTranslationKey(this.getPresetTranslationKey(seconds, this.musicOptions.randomness));
            this.musicOptions.delay = seconds;
            this.updateContextTextWidget();
        });
        this.randomnessSlider = new IntegerSlider("inf_music.config.randomness", 0, this.maxIntValue, this.musicOptions.randomness / this.secondsStep, value -> {
            if (value == 0) {
                return class_2561.method_43471((String)"inf_music.config.randomness.none");
            }
            return this.getValueText(value * this.secondsStep);
        }, value -> {
            int seconds = value * this.secondsStep;
            this.presetButton.setValueTranslationKey(this.getPresetTranslationKey(this.musicOptions.delay, seconds));
            this.musicOptions.randomness = seconds;
            this.updateContextTextWidget();
        });
        this.optionButtons.method_20408(new class_7172[]{this.presetButton.getSimpleOption(), this.disableMusicButton.getSimpleOption(), this.delaySlider.getSimpleOption(), this.randomnessSlider.getSimpleOption()});
        this.contextTextWidget = (class_7940)this.method_37063((class_364)new class_7940((class_2561)class_2561.method_43473(), this.field_22793));
        this.contextTextWidget.method_48984(this.optionButtons.method_25322() - 50);
        this.contextTextWidget.method_48981(true);
        this.contextTextWidget.method_46419(88);
        this.updateContextTextWidget();
    }

    private String getPresetTranslationKey(int delay, int randomness) {
        if (delay == 0 && randomness == 0) {
            return "inf_music.config.delayPreset.none";
        }
        if (delay == this.musicOptions.getDefaultDelay() && randomness == this.musicOptions.getDefaultRandomness()) {
            return "inf_music.config.delayPreset.default";
        }
        return "inf_music.config.delayPreset.custom";
    }

    private class_2561 getValueText(int value) {
        return class_2561.method_43469((String)("inf_music." + this.valueTranslationKey + ((value /= this.secondsStep) == 1 ? "" : "s")), (Object[])new Object[]{value});
    }

    private void updateContextTextWidget() {
        class_5250 message = this.musicOptions.randomness == 0 ? class_2561.method_43469((String)"inf_music.config.delayContext", (Object[])new Object[]{this.getValueText(this.musicOptions.delay)}) : class_2561.method_43469((String)"inf_music.config.delayContext.random", (Object[])new Object[]{this.getValueText(Math.max(this.musicOptions.delay - this.musicOptions.randomness, 0)), this.getValueText(this.musicOptions.delay + this.musicOptions.randomness)});
        this.contextTextWidget.method_25355((class_2561)message);
        this.contextTextWidget.method_46421((this.field_22789 - this.contextTextWidget.method_25368()) / 2);
    }
}

