/*
 * Decompiled with CFR 0.152.
 */
package link.infra.borderlessmining.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7172;

public abstract class ConfigScreen
extends class_437 {
    private final class_437 parent;
    private ConfigListWidget entries;

    protected ConfigScreen(class_2561 title, class_437 parent) {
        super(title);
        this.parent = parent;
    }

    protected final void method_25426() {
        this.entries = new ConfigListWidget(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 25);
        this.addElements();
        this.method_37063((class_364)this.entries);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            this.save();
            this.field_22787.method_1507(this.parent);
        }).method_46433(this.field_22789 / 2 - 100, this.field_22790 - 27).method_46437(200, 20).method_46431());
    }

    public final void method_25432() {
        this.save();
    }

    public abstract void save();

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_25394(drawContext, mouseX, mouseY, delta);
        class_2583 hoveredStyle = this.entries.getHoveredStyle(mouseX, mouseY);
        if (hoveredStyle != null) {
            drawContext.method_51441(this.field_22793, hoveredStyle, mouseX, mouseY);
        }
        drawContext.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
    }

    public abstract void addElements();

    public void addOption(class_7172<?> opt) {
        this.entries.addEntry(new ConfigListEntry(Collections.singletonList(opt.method_18520(this.field_22787.field_1690, this.field_22789 / 2 - 155, 0, 310))));
    }

    public void addOptionsRow(class_7172<?> opt, class_7172<?> opt2) {
        this.entries.addEntry(new ConfigListEntry(Arrays.asList(opt.method_18520(this.field_22787.field_1690, this.field_22789 / 2 - 155, 0, 150), opt2.method_18520(this.field_22787.field_1690, this.field_22789 / 2 - 155 + 160, 0, 150))));
    }

    public void addHeading(class_2561 text) {
        this.entries.addEntry(new ConfigListHeader(text, this.field_22793, this.field_22789, this));
    }

    public void addTextField(class_2561 description, Supplier<String> getter, Consumer<String> setter) {
        this.addTextField(description, getter, setter, Objects::nonNull);
    }

    public void addTextField(class_2561 description, Supplier<String> getter, Consumer<String> setter, Predicate<String> validator) {
        this.entries.addEntry(new ConfigListTextField(this.field_22793, this.field_22789 / 2 - 154, 0, 308, 18, description, getter, setter, validator));
    }

    public void addIntField(class_2561 description, Supplier<Integer> getter, Consumer<Integer> setter) {
        this.addTextField(description, () -> ((Integer)getter.get()).toString(), value -> setter.accept(Integer.parseInt(value)), value -> {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
    }

    public void addFloatField(class_2561 description, Supplier<Float> getter, Consumer<Float> setter) {
        this.addTextField(description, () -> ((Float)getter.get()).toString(), value -> setter.accept(Float.valueOf(Float.parseFloat(value))), value -> {
            try {
                Float.parseFloat(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
    }

    private static class ConfigListWidget
    extends class_4265<ConfigListEntry> {
        public ConfigListWidget(class_310 minecraftClient, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraftClient, width, height, top, bottom, itemHeight);
        }

        public int addEntry(ConfigListEntry entry) {
            return super.method_25321((class_350.class_351)entry);
        }

        public int method_25322() {
            return 400;
        }

        protected int method_25329() {
            return super.method_25329() + 32;
        }

        public class_2583 getHoveredStyle(int mouseX, int mouseY) {
            Optional hovered = this.method_19355(mouseX, mouseY);
            if (hovered.isPresent()) {
                return ((ConfigListEntry)((Object)hovered.get())).getHoveredStyle(mouseX, mouseY);
            }
            return null;
        }
    }

    public static class ConfigListEntry
    extends class_4265.class_4266<ConfigListEntry> {
        private final List<class_339> buttons;

        public ConfigListEntry(List<class_339> buttons) {
            this.buttons = buttons;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            for (class_339 widget : this.buttons) {
                widget.method_46419(y);
                widget.method_25394(context, mouseX, mouseY, tickDelta);
            }
        }

        public List<? extends class_6379> method_37025() {
            return this.buttons;
        }

        public List<? extends class_364> method_25396() {
            return this.buttons;
        }

        public class_2583 getHoveredStyle(int mouseX, int mouseY) {
            return null;
        }
    }

    public static class ConfigListHeader
    extends ConfigListEntry {
        private final class_2561 headerText;
        private final class_327 textRenderer;
        private final int width;
        private final int textWidth;
        private final class_437 screen;

        public ConfigListHeader(class_2561 headerText, class_327 textRenderer, int width, class_437 screen) {
            super(Collections.emptyList());
            this.headerText = headerText;
            this.textRenderer = textRenderer;
            this.width = width;
            this.textWidth = textRenderer.method_27525((class_5348)headerText);
            this.screen = screen;
        }

        @Override
        public void method_25343(class_332 drawContext, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            drawContext.method_27534(this.textRenderer, this.headerText, this.width / 2, y + 5, 0xFFFFFF);
        }

        private class_2583 getStyleAt(int mouseX) {
            int min = this.width / 2 - this.textWidth / 2;
            int max = this.width / 2 + this.textWidth / 2;
            if (mouseX >= min && mouseX <= max) {
                return this.textRenderer.method_27527().method_27489((class_5348)this.headerText, mouseX - min);
            }
            return null;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return this.screen.method_25430(this.getStyleAt((int)mouseX));
        }

        @Override
        public class_2583 getHoveredStyle(int mouseX, int mouseY) {
            class_2583 style = this.getStyleAt(mouseX);
            if (style != null && style.method_10969() != null) {
                return style;
            }
            return null;
        }

        @Override
        public List<? extends class_6379> method_37025() {
            return Collections.singletonList(new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 builder) {
                    builder.method_37034(class_6381.field_33788, headerText);
                }
            });
        }
    }

    public static class ConfigListTextField
    extends ConfigListEntry {
        private final class_342 textField = (class_342)this.method_25396().get(0);
        private final int textWidth;
        private final class_327 textRenderer;
        private final int x;

        public ConfigListTextField(class_327 textRenderer, int x, int y, int width, int height, class_2561 description, Supplier<String> getter, Consumer<String> setter, Predicate<String> validator) {
            super(Collections.singletonList(ConfigListTextField.makeField(textRenderer, x, y, width, height, description)));
            this.textWidth = textRenderer.method_27525((class_5348)description);
            this.textRenderer = textRenderer;
            this.x = x;
            this.textField.method_1852(getter.get());
            this.textField.method_1863(value -> {
                if (validator.test((String)value)) {
                    setter.accept((String)value);
                    this.textField.method_1868(0xE0E0E0);
                } else {
                    this.textField.method_1868(0xFF0000);
                }
            });
        }

        private static class_342 makeField(class_327 textRenderer, int x, int y, int width, int height, class_2561 description) {
            return new class_342(textRenderer, x + width / 2 + 7, y, width / 2 - 8, height, description){

                public void method_47399(class_6382 builder) {
                    builder.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
                }
            };
        }

        @Override
        public class_2583 getHoveredStyle(int mouseX, int mouseY) {
            class_2583 style;
            int max = this.x + this.textWidth;
            if (mouseX >= this.x && mouseX <= max && (style = this.textRenderer.method_27527().method_27489((class_5348)this.textField.method_25369(), mouseX - this.x)) != null && style.method_10969() != null) {
                return style;
            }
            return null;
        }

        @Override
        public void method_25343(class_332 drawContext, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            drawContext.method_27535(this.textRenderer, this.textField.method_25369(), this.x, y + 5, 0xFFFFFF);
            super.method_25343(drawContext, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
        }
    }
}

