/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.function.Function;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.element.IrisElementRow;
import net.coderbot.iris.gui.element.IrisObjectSelectionList;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;

public class ShaderPackSelectionList
extends IrisObjectSelectionList<BaseEntry> {
    private static final class_2561 PACK_LIST_LABEL = class_2561.method_43471((String)"pack.iris.list.label").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080});
    private final ShaderPackScreen screen;
    private final TopButtonRowEntry topButtonRow;
    private final WatchService watcher;
    private final WatchKey key;
    private boolean keyValid;
    private ShaderPackEntry applied = null;

    public ShaderPackSelectionList(ShaderPackScreen shaderPackScreen, class_310 class_3102, int n, int n2, int n3, int n4, int n5, int n6) {
        super(class_3102, n, n2, n3, n4, n5, n6, 20);
        WatchKey watchKey;
        WatchService watchService;
        this.screen = shaderPackScreen;
        this.topButtonRow = new TopButtonRowEntry(this, Iris.getIrisConfig().areShadersEnabled());
        try {
            watchService = FileSystems.getDefault().newWatchService();
            watchKey = Iris.getShaderpacksDirectory().register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            this.keyValid = true;
        }
        catch (IOException iOException) {
            Iris.logger.error("Couldn't register file watcher!", iOException);
            watchService = null;
            watchKey = null;
            this.keyValid = false;
        }
        this.key = watchKey;
        this.watcher = watchService;
        this.refresh();
    }

    public boolean method_25404(int n, int n2, int n3) {
        if (n == 265 && this.method_25336() == this.method_48200()) {
            return true;
        }
        return super.method_25404(n, n2, n3);
    }

    public void method_25394(class_332 class_3322, int n, int n2, float f) {
        if (this.keyValid) {
            for (WatchEvent<?> watchEvent : this.key.pollEvents()) {
                if (watchEvent.kind() == StandardWatchEventKinds.OVERFLOW) continue;
                this.refresh();
                break;
            }
            this.keyValid = this.key.reset();
        }
        super.method_25394(class_3322, n, n2, f);
    }

    public void close() throws IOException {
        if (this.key != null) {
            this.key.cancel();
        }
        if (this.watcher != null) {
            this.watcher.close();
        }
    }

    public int method_25322() {
        return Math.min(308, this.field_22742 - 50);
    }

    protected int method_25337(int n) {
        return super.method_25337(n) + 2;
    }

    public void refresh() {
        List<String> list;
        this.method_25339();
        try {
            list = Iris.getShaderpacksDirectoryManager().enumerate();
        }
        catch (Throwable throwable) {
            Iris.logger.error("Error reading files while constructing selection UI", throwable);
            this.addLabelEntries(new class_2561[]{class_2561.method_43473(), class_2561.method_43470((String)"There was an error reading your shaderpacks directory").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), class_2561.method_43473(), class_2561.method_43470((String)"Check your logs for more information."), class_2561.method_43470((String)"Please file an issue report including a log file."), class_2561.method_43470((String)"If you are able to identify the file causing this, please include it in your report as well."), class_2561.method_43470((String)"Note that this might be an issue with folder permissions; ensure those are correct first.")});
            return;
        }
        this.method_25321(this.topButtonRow);
        this.topButtonRow.allowEnableShadersButton = list.size() > 0;
        int n = 0;
        for (String string : list) {
            this.addPackEntry(++n, string);
        }
        this.addLabelEntries(PACK_LIST_LABEL);
    }

    public void addPackEntry(int n, String string) {
        ShaderPackEntry shaderPackEntry = new ShaderPackEntry(n, this, string);
        Iris.getIrisConfig().getShaderPackName().ifPresent(string2 -> {
            if (string.equals(string2)) {
                this.method_25313(shaderPackEntry);
                this.method_25395((class_364)shaderPackEntry);
                this.method_25324(shaderPackEntry);
                this.setApplied(shaderPackEntry);
            }
        });
        this.method_25321(shaderPackEntry);
    }

    protected void method_25320(class_332 class_3322, int n, int n2) {
        int n3 = 32;
        class_3322.method_51422(0.25f, 0.25f, 0.25f, 1.0f);
        class_3322.method_25290(class_437.field_44669, this.field_19088, 0, 0.0f, 0.0f, this.field_22742, this.field_19085, 32, 32);
        class_3322.method_25290(class_437.field_44669, this.field_19088, this.field_19086, 0.0f, (float)this.field_19086, this.field_22742, this.field_22743 - this.field_19086, 32, 32);
        class_3322.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        int n4 = 4;
        class_3322.method_51740(class_1921.method_51785(), this.field_19088, this.field_19085, this.field_19087, this.field_19085 + 4, -16777216, 0, 0);
        class_3322.method_51740(class_1921.method_51785(), this.field_19088, this.field_19086 - 4, this.field_19087, this.field_19086, 0, -16777216, 0);
        super.method_25320(class_3322, n, n2);
    }

    public void addLabelEntries(class_2561 ... class_2561Array) {
        for (class_2561 class_25612 : class_2561Array) {
            this.method_25321(new LabelEntry(class_25612));
        }
    }

    public void select(String string) {
        for (int i = 0; i < this.method_25340(); ++i) {
            BaseEntry baseEntry = (BaseEntry)this.method_25326(i);
            if (!(baseEntry instanceof ShaderPackEntry) || !((ShaderPackEntry)baseEntry).packName.equals(string)) continue;
            this.method_25313(baseEntry);
            return;
        }
    }

    public void setApplied(ShaderPackEntry shaderPackEntry) {
        this.applied = shaderPackEntry;
    }

    public ShaderPackEntry getApplied() {
        return this.applied;
    }

    public TopButtonRowEntry getTopButtonRow() {
        return this.topButtonRow;
    }

    public class ShaderPackEntry
    extends BaseEntry {
        private final String packName;
        private final ShaderPackSelectionList list;
        private final int index;
        private class_8030 bounds = class_8030.method_48248();
        private boolean focused;

        public class_8030 method_48202() {
            return this.bounds;
        }

        public ShaderPackEntry(int n, ShaderPackSelectionList shaderPackSelectionList2, String string) {
            this.packName = string;
            this.list = shaderPackSelectionList2;
            this.index = n;
        }

        public boolean isApplied() {
            return this.list.getApplied() == this;
        }

        public boolean isSelected() {
            return this.list.method_25334() == this;
        }

        public String getPackName() {
            return this.packName;
        }

        public void method_25343(class_332 class_3322, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            this.bounds = new class_8030(n3, n2, n4, n5);
            class_327 class_3272 = class_310.method_1551().field_1772;
            int n8 = 0xFFFFFF;
            Object object = this.packName;
            if (bl) {
                GuiUtil.bindIrisWidgetsTexture();
                GuiUtil.drawButton(class_3322, n3 - 2, n2 - 2, n4, n5 + 4, bl, false);
            }
            boolean bl2 = this.list.getTopButtonRow().shadersEnabled;
            if (class_3272.method_27525((class_5348)class_2561.method_43470((String)object).method_27692(class_124.field_1067)) > this.list.method_25322() - 3) {
                object = class_3272.method_27523((String)object, this.list.method_25322() - 8) + "...";
            }
            class_5250 class_52502 = class_2561.method_43470((String)object);
            if (this.method_25405(n6, n7)) {
                class_52502 = class_52502.method_27692(class_124.field_1067);
            }
            if (bl2 && this.isApplied()) {
                n8 = 16773731;
            }
            if (!bl2 && !this.method_25405(n6, n7)) {
                n8 = 0xA2A2A2;
            }
            class_3322.method_27534(class_3272, (class_2561)class_52502, n3 + n4 / 2 - 2, n2 + (n5 - 11) / 2, n8);
        }

        public boolean method_25402(double d, double d2, int n) {
            if (n != 0) {
                return false;
            }
            return this.doThing();
        }

        public boolean method_25404(int n, int n2, int n3) {
            if (n != 257) {
                return false;
            }
            return this.doThing();
        }

        private boolean doThing() {
            boolean bl = false;
            if (!this.list.getTopButtonRow().shadersEnabled) {
                this.list.getTopButtonRow().setShadersEnabled(true);
                bl = true;
            }
            if (!this.isSelected()) {
                this.list.select(this.index);
                bl = true;
            }
            ShaderPackSelectionList.this.screen.method_25395((class_364)ShaderPackSelectionList.this.screen.getBottomRowOption());
            return bl;
        }

        @Nullable
        public class_8016 method_48205(class_8023 class_80232) {
            return !this.method_25370() ? class_8016.method_48193((class_364)this) : null;
        }

        public boolean method_25370() {
            return this.list.method_25336() == this;
        }
    }

    public class TopButtonRowEntry
    extends BaseEntry {
        private static final class_2561 NONE_PRESENT_LABEL = class_2561.method_43471((String)"options.iris.shaders.nonePresent").method_27692(class_124.field_1080);
        private static final class_2561 SHADERS_DISABLED_LABEL = class_2561.method_43471((String)"options.iris.shaders.disabled");
        private static final class_2561 SHADERS_ENABLED_LABEL = class_2561.method_43471((String)"options.iris.shaders.enabled");
        private final ShaderPackSelectionList list;
        public boolean allowEnableShadersButton = true;
        public boolean shadersEnabled;

        public TopButtonRowEntry(ShaderPackSelectionList shaderPackSelectionList2, boolean bl) {
            this.list = shaderPackSelectionList2;
            this.shadersEnabled = bl;
        }

        public void setShadersEnabled(boolean bl) {
            this.shadersEnabled = bl;
            this.list.screen.refreshScreenSwitchButton();
        }

        public void method_25343(class_332 class_3322, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            GuiUtil.bindIrisWidgetsTexture();
            GuiUtil.drawButton(class_3322, n3 - 2, n2 - 2, n4, n5 + 2, bl, !this.allowEnableShadersButton);
            class_3322.method_27534(class_310.method_1551().field_1772, this.getEnableDisableLabel(), n3 + n4 / 2 - 2, n2 + (n5 - 11) / 2, 0xFFFFFF);
        }

        private class_2561 getEnableDisableLabel() {
            return this.allowEnableShadersButton ? (this.shadersEnabled ? SHADERS_ENABLED_LABEL : SHADERS_DISABLED_LABEL) : NONE_PRESENT_LABEL;
        }

        public boolean method_25402(double d, double d2, int n) {
            if (this.allowEnableShadersButton) {
                this.setShadersEnabled(!this.shadersEnabled);
                GuiUtil.playButtonClickSound();
                return true;
            }
            return false;
        }

        public boolean method_25404(int n, int n2, int n3) {
            if (n == 257 && this.allowEnableShadersButton) {
                this.setShadersEnabled(!this.shadersEnabled);
                GuiUtil.playButtonClickSound();
                return true;
            }
            return false;
        }

        @Nullable
        public class_8016 method_48205(class_8023 class_80232) {
            return !this.method_25370() ? class_8016.method_48193((class_364)this) : null;
        }

        public boolean method_25370() {
            return this.list.method_25336() == this;
        }

        public static class EnableShadersButtonElement
        extends IrisElementRow.TextButtonElement {
            private int centerX;

            public EnableShadersButtonElement(class_2561 class_25612, Function<IrisElementRow.TextButtonElement, Boolean> function) {
                super(class_25612, function);
            }

            @Override
            public void renderLabel(class_332 class_3322, int n, int n2, int n3, int n4, int n5, int n6, float f, boolean bl) {
                int n7 = this.centerX - (int)((double)this.font.method_27525((class_5348)this.text) * 0.5);
                int n8 = n2 + (int)((double)(n4 - 8) * 0.5);
                class_3322.method_27535(this.font, this.text, n7, n8, 0xFFFFFF);
            }
        }
    }

    public static class LabelEntry
    extends BaseEntry {
        private final class_2561 label;

        public LabelEntry(class_2561 class_25612) {
            this.label = class_25612;
        }

        public void method_25343(class_332 class_3322, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            class_3322.method_27534(class_310.method_1551().field_1772, this.label, n3 + n4 / 2 - 2, n2 + (n5 - 11) / 2, 0xC2C2C2);
        }
    }

    public static abstract class BaseEntry
    extends class_350.class_351<BaseEntry> {
        protected BaseEntry() {
        }
    }
}

