/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mainwindow;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_7367;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class WindowHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final File ICON_DIR = new File(FancyMenu.MOD_DIR, "/minecraftwindow/icons");
    private static String windowTitle = null;

    public static void handleForceFullscreen() {
        try {
            FancyMenu.initConfig();
            if (((Boolean)FancyMenu.config.getOrDefault("forcefullscreen", (Object)false)).booleanValue() && !class_310.method_1551().method_22683().method_4498()) {
                class_310.method_1551().method_22683().method_4500();
                LOGGER.info("[FANCYMENU] Forced window to fullscreen!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateWindowIcon() {
        FancyMenu.initConfig();
        if (((Boolean)FancyMenu.config.getOrDefault("customwindowicon", (Object)false)).booleanValue()) {
            try {
                File i16 = new File(ICON_DIR.getPath() + "/icon16x16.png");
                File i32 = new File(ICON_DIR.getPath() + "/icon32x32.png");
                if (!i16.exists() || !i32.exists()) {
                    LOGGER.error("[FANCYMENU] Unable to set custom icons: 'icon16x16.png' or 'icon32x32.png' missing!");
                    return;
                }
                BufferedImage i16buff = ImageIO.read(i16);
                if (i16buff.getHeight() != 16 || i16buff.getWidth() != 16) {
                    LOGGER.error("[FANCYMENU] Unable to set custom icons: 'icon16x16.png' not 16x16!");
                    return;
                }
                BufferedImage i32buff = ImageIO.read(i32);
                if (i32buff.getHeight() != 32 || i32buff.getWidth() != 32) {
                    LOGGER.error("[FANCYMENU] Unable to set custom icons: 'icon32x32.png' not 32x32!");
                    return;
                }
                WindowHandler.setIcon((class_7367<InputStream>)class_7367.create((Path)i16.toPath()), (class_7367<InputStream>)class_7367.create((Path)i32.toPath()));
                LOGGER.info("[FANCYMENU] Custom minecraft icon successfully loaded!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void setIcon(class_7367<InputStream> p_250818_, class_7367<InputStream> p_249199_) {
        RenderSystem.assertInInitPhase();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            GLFWImage.Buffer buffer = GLFWImage.malloc((int)2, (MemoryStack)memorystack);
            ByteBuffer bytebuffer = WindowHandler.readIconPixels(p_250818_, intbuffer, intbuffer1, intbuffer2);
            if (bytebuffer == null) {
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            buffer.position(0);
            buffer.width(intbuffer.get(0));
            buffer.height(intbuffer1.get(0));
            buffer.pixels(bytebuffer);
            ByteBuffer bytebuffer1 = WindowHandler.readIconPixels(p_249199_, intbuffer, intbuffer1, intbuffer2);
            if (bytebuffer1 == null) {
                STBImage.stbi_image_free((ByteBuffer)bytebuffer);
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            buffer.position(1);
            buffer.width(intbuffer.get(0));
            buffer.height(intbuffer1.get(0));
            buffer.pixels(bytebuffer1);
            buffer.position(0);
            GLFW.glfwSetWindowIcon((long)class_310.method_1551().method_22683().method_4490(), (GLFWImage.Buffer)buffer);
            STBImage.stbi_image_free((ByteBuffer)bytebuffer);
            STBImage.stbi_image_free((ByteBuffer)bytebuffer1);
        }
        catch (IOException ioexception) {
            LogManager.getLogger().error("Couldn't set icon", (Throwable)ioexception);
        }
    }

    /*
     * Loose catch block
     */
    @Nullable
    private static ByteBuffer readIconPixels(class_7367<InputStream> p_249586_, IntBuffer p_249069_, IntBuffer p_249100_, IntBuffer p_249695_) throws IOException {
        ByteBuffer byteBuffer;
        InputStream inputstream;
        ByteBuffer bytebuffer;
        block10: {
            block9: {
                RenderSystem.assertInInitPhase();
                bytebuffer = null;
                inputstream = (InputStream)p_249586_.get();
                bytebuffer = TextureUtil.readResource((InputStream)inputstream);
                bytebuffer.rewind();
                byteBuffer = STBImage.stbi_load_from_memory((ByteBuffer)bytebuffer, (IntBuffer)p_249069_, (IntBuffer)p_249100_, (IntBuffer)p_249695_, (int)0);
                if (inputstream == null) break block9;
                inputstream.close();
            }
            if (bytebuffer == null) break block10;
            MemoryUtil.memFree((Buffer)bytebuffer);
        }
        return byteBuffer;
        {
            catch (Throwable throwable) {
                try {
                    if (inputstream != null) {
                        try {
                            inputstream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    if (bytebuffer != null) {
                        MemoryUtil.memFree(bytebuffer);
                    }
                    throw throwable3;
                }
            }
        }
    }

    public static void updateWindowTitle() {
        WindowHandler.readCustomWindowTitleFromConfig();
        class_310.method_1551().method_24288();
    }

    public static void readCustomWindowTitleFromConfig() {
        FancyMenu.initConfig();
        windowTitle = (String)FancyMenu.config.getOrDefault("customwindowtitle", (Object)"");
        if (windowTitle != null && windowTitle.isEmpty()) {
            windowTitle = null;
        }
    }

    @Nullable
    public static String getCustomWindowTitle() {
        return windowTitle;
    }

    public static int getWindowGuiWidth() {
        class_437 s = class_310.method_1551().field_1755;
        if (s != null) {
            double mcScale = class_310.method_1551().method_22683().method_4476((int)class_310.method_1551().method_22683().method_4495(), ((Boolean)class_310.method_1551().field_1690.method_42437().method_41753()).booleanValue());
            float baseUIScale = 1.0f;
            float sc = (float)((double)baseUIScale * ((double)baseUIScale / mcScale));
            return (int)((float)s.field_22789 / sc);
        }
        return 0;
    }

    public static int getWindowGuiHeight() {
        class_437 s = class_310.method_1551().field_1755;
        if (s != null) {
            double mcScale = class_310.method_1551().method_22683().method_4476((int)class_310.method_1551().method_22683().method_4495(), ((Boolean)class_310.method_1551().field_1690.method_42437().method_41753()).booleanValue());
            float baseUIScale = 1.0f;
            float sc = (float)((double)baseUIScale * ((double)baseUIScale / mcScale));
            return (int)((float)s.field_22790 / sc);
        }
        return 0;
    }
}

