/*
 * Decompiled with CFR 0.152.
 */
package com.hamarb123.macos_input_fixes;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public class MixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        ArrayList<String> li = new ArrayList<String>();
        MappingResolver resolver = FabricLoader.getInstance().getMappingResolver();
        boolean hasOptionClass = MixinPlugin.isClassPresent(resolver.mapClassName("intermediary", "net.minecraft.class_316"));
        boolean hasCyclingButtonWidgetClass = MixinPlugin.isClassPresent(resolver.mapClassName("intermediary", "net.minecraft.class_5676"));
        boolean hasGameOptionsScreen_getHoveredButtonTooltip = MixinPlugin.isMethodPresent(resolver.mapClassName("intermediary", "net.minecraft.class_4667"), resolver.mapMethodName("intermediary", "net.minecraft.class_4667", "method_31048", "(Lnet/minecraft/class_353;II)Ljava/util/List;"), "(L" + resolver.mapClassName("intermediary", "net.minecraft.class_353").replace(".", "/") + ";II)Ljava/util/List;");
        boolean hasScreen_renderTooltip = MixinPlugin.isMethodPresent(resolver.mapClassName("intermediary", "net.minecraft.class_437"), resolver.mapMethodName("intermediary", "net.minecraft.class_437", "method_25417", "(Lnet/minecraft/class_4587;Ljava/util/List;II)V"), "(L" + resolver.mapClassName("intermediary", "net.minecraft.class_4587").replace(".", "/") + ";Ljava/util/List;II)V");
        if (hasOptionClass) {
            li.add("gui.MouseOptionsScreenMixin2");
            if (hasCyclingButtonWidgetClass) {
                li.add("gui.CyclingOptionMixin4");
            }
        } else {
            li.add("gui.MouseOptionsScreenMixin1");
            li.add("gui.OptionListWidgetMixin1");
            li.add("gui.SimpleOptionMixin1");
        }
        if (hasCyclingButtonWidgetClass) {
            li.add("gui.CyclingButtonWidgetBuilderMixin3");
        }
        if (hasGameOptionsScreen_getHoveredButtonTooltip) {
            li.add("gui.MouseOptionsScreenMixin5");
        }
        if (!hasGameOptionsScreen_getHoveredButtonTooltip && hasScreen_renderTooltip && hasOptionClass) {
            li.add("gui.MouseOptionsScreenMixin6");
        }
        if (hasGameOptionsScreen_getHoveredButtonTooltip || hasScreen_renderTooltip && hasOptionClass) {
            li.add("gui.ScreenAccessor7");
        }
        return li;
    }

    private static boolean isClassPresent(String className) {
        try {
            MixinService.getService().getBytecodeProvider().getClassNode(className);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean isMethodPresent(String className, String methodName, String descriptor) {
        try {
            ClassNode classNode = MixinService.getService().getBytecodeProvider().getClassNode(className);
            for (MethodNode methodNode : classNode.methods) {
                if (!methodNode.name.equals(methodName) || !methodNode.desc.equals(descriptor)) continue;
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

