/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dynamic_fps.impl.GraphicsState;
import dynamic_fps.impl.util.EnumCodec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_3419;

public final class Config {
    private int frameRateTarget;
    private Map<class_3419, Float> volumeMultipliers;
    private GraphicsState graphicsState;
    private boolean showToasts;
    private boolean runGarbageCollector;
    public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("frame_rate_target").forGetter(Config::frameRateTarget), (App)Codec.unboundedMap((Codec)new EnumCodec((Enum[])class_3419.values()), (Codec)Codec.FLOAT).fieldOf("volume_multipliers").forGetter(Config::volumeMultipliers), (App)new EnumCodec((Enum[])GraphicsState.values()).fieldOf("graphics_state").forGetter(Config::graphicsState), (App)Codec.BOOL.fieldOf("show_toasts").forGetter(Config::showToasts), (App)Codec.BOOL.fieldOf("run_garbage_collector").forGetter(Config::runGarbageCollector)).apply((Applicative)instance, Config::new));
    public static final Config ACTIVE = new Config(-1, new HashMap<class_3419, Float>(), GraphicsState.DEFAULT, true, false);

    public Config(int frameRateTarget, Map<class_3419, Float> volumeMultipliers, GraphicsState graphicsState, boolean showToasts, boolean runGarbageCollector) {
        this.frameRateTarget = frameRateTarget;
        this.volumeMultipliers = new HashMap<class_3419, Float>(volumeMultipliers);
        this.graphicsState = graphicsState;
        this.showToasts = showToasts;
        this.runGarbageCollector = runGarbageCollector;
    }

    public int frameRateTarget() {
        return this.frameRateTarget;
    }

    public void setFrameRateTarget(int value) {
        this.frameRateTarget = value;
    }

    public Map<class_3419, Float> volumeMultipliers() {
        return this.volumeMultipliers;
    }

    public float volumeMultiplier(class_3419 category) {
        return this.volumeMultipliers.getOrDefault(category, Float.valueOf(1.0f)).floatValue();
    }

    public void setVolumeMultiplier(class_3419 category, float value) {
        this.volumeMultipliers.put(category, Float.valueOf(value));
    }

    public GraphicsState graphicsState() {
        return this.graphicsState;
    }

    public void setGraphicsState(GraphicsState value) {
        this.graphicsState = value;
    }

    public boolean showToasts() {
        return this.showToasts;
    }

    public void setShowToasts(boolean value) {
        this.showToasts = value;
    }

    public boolean runGarbageCollector() {
        return this.runGarbageCollector;
    }

    public void setRunGarbageCollector(boolean value) {
        this.runGarbageCollector = value;
    }
}

