/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dynamic_fps.impl.GraphicsState;
import dynamic_fps.impl.PowerState;
import dynamic_fps.impl.config.Config;
import dynamic_fps.impl.util.EnumCodec;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3419;

public final class DynamicFPSConfig {
    private int idleTime;
    private Map<PowerState, Config> configs;
    private static final Path CONFIGS = FabricLoader.getInstance().getConfigDir();
    private static final Path CONFIG_FILE = CONFIGS.resolve("dynamic_fps.json");
    private static final Codec<Map<PowerState, Config>> STATES_CODEC = Codec.unboundedMap((Codec)new EnumCodec((Enum[])PowerState.values()), Config.CODEC);
    private static final Codec<DynamicFPSConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)1800).fieldOf("idle_time").forGetter(DynamicFPSConfig::idleTime), (App)STATES_CODEC.fieldOf("states").forGetter(DynamicFPSConfig::configs)).apply((Applicative)instance, DynamicFPSConfig::new));

    private DynamicFPSConfig(int abandonTime, Map<PowerState, Config> configs) {
        this.idleTime = abandonTime;
        this.configs = new EnumMap<PowerState, Config>(configs);
        for (PowerState state : PowerState.values()) {
            if (!state.configurable) continue;
            this.configs.computeIfAbsent(state, DynamicFPSConfig::getDefaultConfig);
        }
    }

    public Config get(PowerState state) {
        if (state == PowerState.FOCUSED) {
            return Config.ACTIVE;
        }
        return this.configs.get((Object)state);
    }

    public int idleTime() {
        return this.idleTime;
    }

    public void setIdleTime(int value) {
        this.idleTime = value;
    }

    private Map<PowerState, Config> configs() {
        return this.configs;
    }

    public static DynamicFPSConfig load() {
        String data;
        try {
            data = Files.readString(CONFIG_FILE);
        }
        catch (NoSuchFileException e) {
            DynamicFPSConfig config = new DynamicFPSConfig(0, new EnumMap<PowerState, Config>(PowerState.class));
            config.save();
            return config;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load Dynamic FPS config.", e);
        }
        JsonElement root = JsonParser.parseString((String)data);
        DynamicFPSConfig.upgradeConfig((JsonObject)root);
        DataResult parsed = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)root);
        return (DynamicFPSConfig)parsed.getOrThrow(false, RuntimeException::new);
    }

    public void save() {
        DataResult data = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this);
        JsonElement root = (JsonElement)data.getOrThrow(false, RuntimeException::new);
        try {
            Path temp = Files.createTempFile(CONFIGS, "dynamic_fps", ".json", new FileAttribute[0]);
            Files.writeString(temp, (CharSequence)root.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
            Files.deleteIfExists(CONFIG_FILE);
            Files.move(temp, CONFIG_FILE, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save or modify Dynamic FPS config!", e);
        }
    }

    public static Config getDefaultConfig(PowerState state) {
        switch (state) {
            case HOVERED: {
                return new Config(60, DynamicFPSConfig.withMasterVolume(1.0f), GraphicsState.DEFAULT, true, false);
            }
            case UNFOCUSED: {
                return new Config(1, DynamicFPSConfig.withMasterVolume(0.25f), GraphicsState.DEFAULT, false, false);
            }
            case ABANDONED: {
                return new Config(10, DynamicFPSConfig.withMasterVolume(1.0f), GraphicsState.DEFAULT, false, false);
            }
            case INVISIBLE: {
                return new Config(0, DynamicFPSConfig.withMasterVolume(0.0f), GraphicsState.DEFAULT, false, false);
            }
        }
        throw new RuntimeException("Getting default configuration for unhandled power state " + state.toString());
    }

    private static Map<class_3419, Float> withMasterVolume(float value) {
        HashMap<class_3419, Float> volumes = new HashMap<class_3419, Float>();
        volumes.put(class_3419.field_15250, Float.valueOf(value));
        return volumes;
    }

    private static void upgradeConfig(JsonObject root) {
        DynamicFPSConfig.upgradeIdleTime(root);
        DynamicFPSConfig.upgradeVolumeMultiplier(root);
    }

    private static void upgradeIdleTime(JsonObject root) {
        if (!root.has("idle_time")) {
            root.addProperty("idle_time", (Number)0);
        }
    }

    private static void upgradeVolumeMultiplier(JsonObject root) {
        if (!root.has("states")) {
            return;
        }
        JsonObject states = root.getAsJsonObject("states");
        if (!states.isJsonObject()) {
            return;
        }
        for (String key : states.keySet()) {
            JsonElement multiplier;
            JsonObject element = states.getAsJsonObject(key);
            if (!element.isJsonObject() || !element.has("volume_multiplier") || !(multiplier = element.get("volume_multiplier")).isJsonPrimitive() || !((JsonPrimitive)multiplier).isNumber()) continue;
            JsonObject multipliers = new JsonObject();
            multipliers.add("master", multiplier);
            element.add("volume_multipliers", (JsonElement)multipliers);
        }
    }
}

