/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core.render.immediate.consumer;

import java.nio.ByteBuffer;
import net.caffeinemc.mods.sodium.api.memory.MemoryIntrinsics;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.api.vertex.attributes.CommonVertexAttribute;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.ColorAttribute;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.LightAttribute;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.NormalAttribute;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.OverlayAttribute;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.PositionAttribute;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.TextureAttribute;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatDescription;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatRegistry;
import net.caffeinemc.mods.sodium.api.vertex.serializer.VertexSerializerRegistry;
import net.minecraft.class_287;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_4585;
import net.minecraft.class_4588;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_287.class})
public abstract class BufferBuilderMixin
extends class_4585
implements VertexBufferWriter {
    @Unique
    private static final int ATTRIBUTE_NOT_PRESENT = -1;
    @Unique
    private static final int ATTRIBUTE_POSITION_BIT = 1 << CommonVertexAttribute.POSITION.ordinal();
    @Unique
    private static final int ATTRIBUTE_COLOR_BIT = 1 << CommonVertexAttribute.COLOR.ordinal();
    @Unique
    private static final int ATTRIBUTE_TEXTURE_BIT = 1 << CommonVertexAttribute.TEXTURE.ordinal();
    @Unique
    private static final int ATTRIBUTE_OVERLAY_BIT = 1 << CommonVertexAttribute.OVERLAY.ordinal();
    @Unique
    private static final int ATTRIBUTE_LIGHT_BIT = 1 << CommonVertexAttribute.LIGHT.ordinal();
    @Unique
    private static final int ATTRIBUTE_NORMAL_BIT = 1 << CommonVertexAttribute.NORMAL.ordinal();
    @Shadow
    private ByteBuffer field_1555;
    @Shadow
    private int field_1554;
    @Shadow
    private int field_20884;
    @Shadow
    private class_293.class_5596 field_1567;
    @Unique
    private VertexFormatDescription formatDescription;
    @Unique
    private int vertexStride;
    @Unique
    private int attributeOffsetPosition;
    @Unique
    private int attributeOffsetColor;
    @Unique
    private int attributeOffsetTexture;
    @Unique
    private int attributeOffsetOverlay;
    @Unique
    private int attributeOffsetLight;
    @Unique
    private int attributeOffsetNormal;
    @Unique
    private int requiredAttributes;
    @Unique
    private int writtenAttributes;

    @Shadow
    protected abstract void method_1335(int var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(int initialCapacity, CallbackInfo ci) {
        this.resetAttributeBindings();
    }

    @Unique
    private void resetAttributeBindings() {
        this.requiredAttributes = 0;
        this.attributeOffsetPosition = -1;
        this.attributeOffsetColor = -1;
        this.attributeOffsetTexture = -1;
        this.attributeOffsetOverlay = -1;
        this.attributeOffsetLight = -1;
        this.attributeOffsetNormal = -1;
    }

    @Inject(method={"setFormat"}, at={@At(value="FIELD", target="Lnet/minecraft/client/render/BufferBuilder;format:Lnet/minecraft/client/render/VertexFormat;", opcode=181)})
    private void onFormatChanged(class_293 format, CallbackInfo ci) {
        this.formatDescription = VertexFormatRegistry.instance().get(format);
        this.vertexStride = this.formatDescription.stride();
        this.updateAttributeBindings(this.formatDescription);
    }

    @Unique
    private void updateAttributeBindings(VertexFormatDescription desc) {
        this.resetAttributeBindings();
        if (desc.containsElement(CommonVertexAttribute.POSITION)) {
            this.requiredAttributes |= ATTRIBUTE_POSITION_BIT;
            this.attributeOffsetPosition = desc.getElementOffset(CommonVertexAttribute.POSITION);
        }
        if (desc.containsElement(CommonVertexAttribute.COLOR)) {
            this.requiredAttributes |= ATTRIBUTE_COLOR_BIT;
            this.attributeOffsetColor = desc.getElementOffset(CommonVertexAttribute.COLOR);
        }
        if (desc.containsElement(CommonVertexAttribute.TEXTURE)) {
            this.requiredAttributes |= ATTRIBUTE_TEXTURE_BIT;
            this.attributeOffsetTexture = desc.getElementOffset(CommonVertexAttribute.TEXTURE);
        }
        if (desc.containsElement(CommonVertexAttribute.OVERLAY)) {
            this.requiredAttributes |= ATTRIBUTE_OVERLAY_BIT;
            this.attributeOffsetOverlay = desc.getElementOffset(CommonVertexAttribute.OVERLAY);
        }
        if (desc.containsElement(CommonVertexAttribute.LIGHT)) {
            this.requiredAttributes |= ATTRIBUTE_LIGHT_BIT;
            this.attributeOffsetLight = desc.getElementOffset(CommonVertexAttribute.LIGHT);
        }
        if (desc.containsElement(CommonVertexAttribute.NORMAL)) {
            this.requiredAttributes |= ATTRIBUTE_NORMAL_BIT;
            this.attributeOffsetNormal = desc.getElementOffset(CommonVertexAttribute.NORMAL);
        }
    }

    @Inject(method={"begin"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/BufferBuilder;setFormat(Lnet/minecraft/client/render/VertexFormat;)V")})
    private void onBegin(class_293.class_5596 drawMode, class_293 format, CallbackInfo ci) {
        this.writtenAttributes = 0;
    }

    @Inject(method={"resetBuilding"}, at={@At(value="RETURN")})
    private void onResetBuilding(CallbackInfo ci) {
        this.writtenAttributes = 0;
    }

    @Inject(method={"reset"}, at={@At(value="RETURN")})
    private void onReset(CallbackInfo ci) {
        this.writtenAttributes = 0;
    }

    @Unique
    private void putPositionAttribute(float x, float y, float z) {
        if (this.attributeOffsetPosition == -1) {
            return;
        }
        long offset = MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)(this.field_20884 + this.attributeOffsetPosition));
        PositionAttribute.put(offset, x, y, z);
        this.writtenAttributes |= ATTRIBUTE_POSITION_BIT;
    }

    @Unique
    private void putColorAttribute(int rgba) {
        if (this.attributeOffsetColor == -1) {
            return;
        }
        long offset = MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)(this.field_20884 + this.attributeOffsetColor));
        ColorAttribute.set(offset, rgba);
        this.writtenAttributes |= ATTRIBUTE_COLOR_BIT;
    }

    @Unique
    private void putTextureAttribute(float u, float v) {
        if (this.attributeOffsetTexture == -1) {
            return;
        }
        long offset = MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)(this.field_20884 + this.attributeOffsetTexture));
        TextureAttribute.put(offset, u, v);
        this.writtenAttributes |= ATTRIBUTE_TEXTURE_BIT;
    }

    @Unique
    private void putOverlayAttribute(int uv) {
        if (this.attributeOffsetOverlay == -1) {
            return;
        }
        long offset = MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)(this.field_20884 + this.attributeOffsetOverlay));
        OverlayAttribute.set(offset, uv);
        this.writtenAttributes |= ATTRIBUTE_OVERLAY_BIT;
    }

    @Unique
    private void putLightAttribute(int uv) {
        if (this.attributeOffsetLight == -1) {
            return;
        }
        long offset = MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)(this.field_20884 + this.attributeOffsetLight));
        LightAttribute.set(offset, uv);
        this.writtenAttributes |= ATTRIBUTE_LIGHT_BIT;
    }

    @Unique
    private void putNormalAttribute(int normal) {
        if (this.attributeOffsetNormal == -1) {
            return;
        }
        long offset = MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)(this.field_20884 + this.attributeOffsetNormal));
        NormalAttribute.set(offset, normal);
        this.writtenAttributes |= ATTRIBUTE_NORMAL_BIT;
    }

    public void method_23919(float x, float y, float z, float red, float green, float blue, float alpha, float u, float v, int overlay, int light, float normalX, float normalY, float normalZ) {
        if (this.field_20889) {
            throw new IllegalStateException();
        }
        long offset = MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)this.field_20884);
        if (this.attributeOffsetPosition != -1) {
            PositionAttribute.put(offset + (long)this.attributeOffsetPosition, x, y, z);
        }
        if (this.attributeOffsetColor != -1) {
            ColorAttribute.set(offset + (long)this.attributeOffsetColor, ColorABGR.pack(red, green, blue, alpha));
        }
        if (this.attributeOffsetTexture != -1) {
            TextureAttribute.put(offset + (long)this.attributeOffsetTexture, u, v);
        }
        if (this.attributeOffsetOverlay != -1) {
            OverlayAttribute.set(offset + (long)this.attributeOffsetOverlay, overlay);
        }
        if (this.attributeOffsetLight != -1) {
            LightAttribute.set(offset + (long)this.attributeOffsetLight, light);
        }
        if (this.attributeOffsetNormal != -1) {
            NormalAttribute.set(offset + (long)this.attributeOffsetNormal, NormI8.pack(normalX, normalY, normalZ));
        }
        this.writtenAttributes = ATTRIBUTE_POSITION_BIT | ATTRIBUTE_COLOR_BIT | ATTRIBUTE_TEXTURE_BIT | ATTRIBUTE_OVERLAY_BIT | ATTRIBUTE_LIGHT_BIT | ATTRIBUTE_NORMAL_BIT;
        this.method_1344();
    }

    public class_4588 method_22912(double x, double y, double z) {
        this.putPositionAttribute((float)x, (float)y, (float)z);
        return this;
    }

    public class_4588 method_1336(int red, int green, int blue, int alpha) {
        if (this.field_20889) {
            throw new IllegalStateException();
        }
        this.putColorAttribute(ColorABGR.pack(red, green, blue, alpha));
        return this;
    }

    public class_4588 method_39415(int argb) {
        if (this.field_20889) {
            throw new IllegalStateException();
        }
        this.putColorAttribute(ColorARGB.toABGR(argb));
        return this;
    }

    public class_4588 method_22913(float u, float v) {
        this.putTextureAttribute(u, v);
        return this;
    }

    public class_4588 method_22922(int uv) {
        this.putOverlayAttribute(uv);
        return this;
    }

    public class_4588 method_22916(int uv) {
        this.putLightAttribute(uv);
        return this;
    }

    public class_4588 method_22914(float x, float y, float z) {
        this.putNormalAttribute(NormI8.pack(x, y, z));
        return this;
    }

    public class_4588 method_22921(int u, int v) {
        return this.method_22916(BufferBuilderMixin.packU16x2(u, v));
    }

    public class_4588 method_22917(int u, int v) {
        return this.method_22922(BufferBuilderMixin.packU16x2(u, v));
    }

    @Unique
    private static int packU16x2(int u, int v) {
        return (u & 0xFFFF) << 0 | (v & 0xFFFF) << 16;
    }

    @Overwrite
    public class_296 method_22900() {
        throw BufferBuilderMixin.createBlockedUpcallException();
    }

    @Overwrite
    public void method_1325() {
        throw BufferBuilderMixin.createBlockedUpcallException();
    }

    @Overwrite
    public void method_22896(int index, byte value) {
        throw BufferBuilderMixin.createBlockedUpcallException();
    }

    @Overwrite
    public void method_22898(int index, short value) {
        throw BufferBuilderMixin.createBlockedUpcallException();
    }

    @Overwrite
    public void method_22897(int index, float value) {
        throw BufferBuilderMixin.createBlockedUpcallException();
    }

    @Overwrite
    public void method_1344() {
        if (this.field_20889) {
            this.writeFixedColor();
        }
        if (!this.isVertexFinished()) {
            throw new IllegalStateException("Not filled all elements of the vertex");
        }
        ++this.field_1554;
        this.field_20884 += this.vertexStride;
        this.writtenAttributes = 0;
        this.method_1335(this.vertexStride);
        if (this.shouldDuplicateVertices()) {
            this.duplicateVertex();
        }
    }

    @Unique
    private boolean isVertexFinished() {
        return (this.writtenAttributes & this.requiredAttributes) == this.requiredAttributes;
    }

    @Unique
    private void writeFixedColor() {
        this.putColorAttribute(ColorABGR.pack(this.field_20890, this.field_20891, this.field_20892, this.field_20893));
    }

    @Unique
    private boolean shouldDuplicateVertices() {
        return this.field_1567 == class_293.class_5596.field_27377 || this.field_1567 == class_293.class_5596.field_27378;
    }

    @Unique
    private void duplicateVertex() {
        MemoryIntrinsics.copyMemory(MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)(this.field_20884 - this.vertexStride)), MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)this.field_20884), this.vertexStride);
        this.field_20884 += this.vertexStride;
        ++this.field_1554;
        this.method_1335(this.vertexStride);
    }

    @Override
    public boolean canUseIntrinsics() {
        return true;
    }

    @Override
    public void push(MemoryStack stack, long src, int count, VertexFormatDescription format) {
        int length = count * this.vertexStride;
        this.method_1335(length + this.vertexStride);
        long dst = MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)this.field_20884);
        if (format == this.formatDescription) {
            MemoryIntrinsics.copyMemory(src, dst, length);
        } else {
            this.copySlow(src, dst, count, format);
        }
        this.field_1554 += count;
        this.field_20884 += length;
    }

    @Unique
    private void copySlow(long src, long dst, int count, VertexFormatDescription format) {
        VertexSerializerRegistry.instance().get(format, this.formatDescription).serialize(src, dst, count);
    }

    @Unique
    private static RuntimeException createBlockedUpcallException() {
        return new UnsupportedOperationException("The internal methods provided by BufferVertexConsumer (as used to upcall into BufferBuilder) are unsupported");
    }
}

