/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import java.util.Objects;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.Texture;
import journeymap.common.Journeymap;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MatrixDrawUtil {
    public static int zLevel = 0;

    public static void drawColoredImage(Texture texture, class_4587 poseStack, class_4588 vertexBuilder, int color, float alpha, double x, double y, double rotation) {
        MatrixDrawUtil.drawQuad(poseStack, vertexBuilder, color, alpha, x, y, texture.getWidth(), texture.getHeight(), false, rotation);
    }

    public static void drawQuad(class_4587 poseStack, class_4588 vertexBuilder, int color, float alpha, double x, double y, double width, double height, boolean flip, double rotation) {
        MatrixDrawUtil.drawQuad(poseStack, vertexBuilder, color, alpha, x, y, width, height, 0.0, 0.0, 1.0, 1.0, rotation, flip, true, 770, 771, false);
    }

    public static void drawLabel(String text, class_4587 poseStack, class_4597 buffers, double x, double y, DrawUtil.HAlign hAlign, DrawUtil.VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow) {
        double bgWidth = 0.0;
        double bgHeight = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            class_327 fontRenderer = class_310.method_1551().field_1772;
            bgWidth = fontRenderer.method_1727(text);
            bgHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        }
        MatrixDrawUtil.drawLabel(text, poseStack, buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, 0);
    }

    private static void drawLabel(String text, class_4587 poseStack, class_4597 buffers, double x, double y, DrawUtil.HAlign hAlign, DrawUtil.VAlign vAlign, Integer bgColor, float bgAlpha, double bgWidth, double bgHeight, int color, float alpha, double fontScale, boolean fontShadow, int rotation) {
        double d;
        int height;
        if (text == null || text.length() == 0) {
            return;
        }
        class_327 fontRenderer = class_310.method_1551().field_1772;
        boolean drawRect = bgColor != null && bgAlpha > 0.0f;
        double width = fontRenderer.method_1727(text);
        if (drawRect) {
            v0 = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        } else {
            Objects.requireNonNull(fontRenderer);
            v0 = height = 9;
        }
        if (!drawRect && fontRenderer.method_1726()) {
            --height;
        }
        poseStack.method_22903();
        if (fontScale != 1.0) {
            x /= fontScale;
            y /= fontScale;
            poseStack.method_22905((float)fontScale, (float)fontScale, 0.0f);
        }
        float textX = (float)x;
        float textY = (float)y;
        double rectX = x;
        double rectY = y;
        switch (hAlign) {
            case Left: {
                textX = (float)(x - width);
                rectX = textX;
                break;
            }
            case Center: {
                textX = (float)(x - width / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                rectX = (float)(x - Math.max(1.0, bgWidth) / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                break;
            }
            case Right: {
                textX = (float)x;
                rectX = (float)x;
            }
        }
        if (drawRect) {
            Objects.requireNonNull(fontRenderer);
            d = (double)(height - 9) / 2.0;
        } else {
            d = 0.0;
        }
        double vpad = d;
        switch (vAlign) {
            case Above: {
                rectY = y - (double)height;
                textY = (float)(rectY + vpad + (double)(!fontRenderer.method_1726() ? 1 : 0));
                break;
            }
            case Middle: {
                rectY = y - (double)(height / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                textY = (float)(rectY + vpad);
                break;
            }
            case Below: {
                rectY = y;
                textY = (float)(rectY + vpad);
            }
        }
        if (rotation != 0) {
            poseStack.method_22904(x, y, 0.0);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)(-rotation)));
            poseStack.method_22904(-x, -y, 0.0);
        }
        Matrix4f matrixPos = poseStack.method_23760().method_23761();
        if (drawRect) {
            int backgroundColor = class_310.method_1551().field_1690.method_19345(bgAlpha);
            int hpad = 2;
            MatrixDrawUtil.drawRectangle(matrixPos, rectX - 2.0 - 0.5, rectY, bgWidth + 4.0, bgHeight, backgroundColor);
        }
        if (alpha < 0.0f) {
            color = RGB.toArbg(color, alpha);
        }
        poseStack.method_22904((double)textX - Math.floor(textX), (double)textY - Math.floor(textY), 0.0);
        RenderWrapper.enableDepthTest();
        RenderWrapper.depthMask(true);
        fontRenderer.method_30882((class_2561)class_2561.method_43470((String)text), textX, textY, color, fontShadow, matrixPos, buffers, class_327.class_6415.field_33994, 0, 0xF000F0);
        RenderWrapper.disableDepthTest();
        RenderWrapper.depthMask(false);
        poseStack.method_22909();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawQuad(class_4587 poseStack, class_4588 vertexBuilder, int color, float alpha, double x, double y, double width, double height, double minU, double minV, double maxU, double maxV, double rotation, boolean flip, boolean blend, int glBlendSfactor, int glBlendDFactor, boolean clampTexture) {
        try {
            poseStack.method_22903();
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            if (rotation != 0.0) {
                double transX = x + width / 2.0;
                double transY = y + height / 2.0;
                poseStack.method_22904(transX, transY, 0.0);
                poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)(-rotation)));
                poseStack.method_22904(-transX, -transY, 0.0);
            }
            float[] rgba = RGB.floats(color, alpha);
            float direction = (float)(flip ? -maxU : maxU);
            class_4587.class_4665 entry = poseStack.method_23760();
            Matrix4f matrix4f = entry.method_23761();
            Matrix3f matrix3f = entry.method_23762();
            RenderWrapper.enableDepthTest();
            MatrixDrawUtil.addVertexUV(matrix4f, matrix3f, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (int)(height + y), (float)x, zLevel, (float)minU, (float)maxV);
            MatrixDrawUtil.addVertexUV(matrix4f, matrix3f, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (int)(height + y), (float)(x + width), zLevel, direction, (float)maxV);
            MatrixDrawUtil.addVertexUV(matrix4f, matrix3f, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (int)y, (float)(x + width), zLevel, direction, (float)minV);
            MatrixDrawUtil.addVertexUV(matrix4f, matrix3f, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (int)y, (float)x, zLevel, (float)minU, (float)minV);
            RenderWrapper.disableDepthTest();
        }
        catch (Exception e) {
            Journeymap.getLogger().error((Object)e);
        }
        finally {
            poseStack.method_22909();
        }
    }

    public static void addBufferedVertexWithUV(class_287 bufferIn, double x, double y, double z, double texU, double texV) {
        bufferIn.method_22912(x, y, z).method_22913((float)texU, (float)texV).method_1344();
    }

    public static void drawRectangle(Matrix4f matrixPos, double x, double y, double width, double height, int color) {
        MatrixDrawUtil.fill(matrixPos, (int)x, (int)y, (int)(x + width), (int)(height + y), color);
    }

    public static void fill(Matrix4f matrixPos, int x, int y, int bottomX, int bottomY, int color) {
        if (x < bottomX) {
            int i = x;
            x = bottomX;
            bottomX = i;
        }
        if (y < bottomY) {
            int j = y;
            y = bottomY;
            bottomY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        RenderWrapper.enableBlend();
        RenderWrapper.disableTexture();
        RenderWrapper.setShader(class_757::method_34540);
        RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferbuilder.method_22918(matrixPos, (float)x, (float)bottomY, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_22918(matrixPos, (float)bottomX, (float)bottomY, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_22918(matrixPos, (float)bottomX, (float)y, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_22918(matrixPos, (float)x, (float)y, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
        RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderWrapper.enableTexture();
        RenderWrapper.disableBlend();
    }

    public static void addVertexUVOverlay(Matrix4f matrixPos, Matrix3f matrixNormal, class_4588 bufferIn, float red, float green, float blue, float alpha, int y, float x, float z, float texU, float texV, int overlayUV) {
        bufferIn.method_22918(matrixPos, x, (float)y, z).method_22915(red, green, blue, alpha).method_22913(texU, texV).method_22922(overlayUV).method_22916(0xF000F0).method_23763(matrixNormal, 0.0f, 1.0f, 0.0f).method_1344();
    }

    public static void addVertexUV(Matrix4f matrixPos, Matrix3f matrixNormal, class_4588 bufferIn, float red, float green, float blue, float alpha, int y, float x, float z, float texU, float texV) {
        bufferIn.method_22918(matrixPos, x, (float)y, z).method_22915(red, green, blue, alpha).method_22913(texU, texV).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(matrixNormal, 0.0f, 1.0f, 0.0f).method_1344();
    }

    public static void addVertex(Matrix4f matrixPos, Matrix3f matrixNormal, class_4588 bufferIn, float red, float green, float blue, float alpha, double x, double y, float z) {
        bufferIn.method_22918(matrixPos, (float)x, (float)y, z).method_22915(red, green, blue, alpha).method_23763(matrixNormal, 0.0f, 1.0f, 0.0f).method_1344();
    }
}

