/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Optional;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.JmUI;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4280;
import net.minecraft.class_757;

public class ScrollPane
extends class_4280<ScrollPaneEntry> {
    public int paneWidth = 0;
    public int paneHeight = 0;
    public Point2D.Double origin = new Point2D.Double();
    protected Button selected = null;
    private Integer frameColor = new Color(-6250336).getRGB();
    private class_310 mc;
    private int _mouseX;
    private int _mouseY;
    private boolean showFrame = true;
    private int firstVisibleIndex;
    private int lastVisibleIndex;
    private boolean drawPartialScrollable = true;
    private boolean renderSolidBackground = false;
    private boolean renderDecorations = true;
    private boolean scrollVisible = true;
    protected boolean renderSelection;

    public ScrollPane(JmUI parent, class_310 mc, int width, int height, List<? extends Button> items, int itemHeight, int itemGap) {
        super(mc, width, height, 16, height, itemHeight + itemGap);
        for (Button button : items) {
            super.method_25321((class_350.class_351)new ScrollPaneEntry(this, button));
        }
        this.paneWidth = width;
        this.paneHeight = height;
        this.mc = mc;
    }

    public int getX() {
        return (int)this.origin.getX();
    }

    public int getY() {
        return (int)this.origin.getY();
    }

    public int getSlotHeight() {
        return this.field_22743;
    }

    public void setDrawPartialScrollable(boolean value) {
        this.drawPartialScrollable = value;
    }

    public void setDimensions(int width, int height, int marginTop, int marginBottom, int x, int y) {
        super.method_25323(width, height, y, y + height);
        this.paneWidth = width;
        this.paneHeight = height;
        this.origin.setLocation(x, y);
        this.method_25333(x);
    }

    protected int method_25340() {
        return super.method_25340();
    }

    protected ScrollPaneEntry getEntry(int index) {
        return (ScrollPaneEntry)super.method_25326(index);
    }

    public boolean method_25332(int i) {
        return super.method_25332(i);
    }

    public Button mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (ScrollPaneEntry entry : super.method_25396()) {
                Button item = entry.item;
                if (item == null || !this.inFullView(item)) continue;
                if (item.method_49606() && item.method_25402(mouseX, mouseY, mouseButton)) {
                    item.method_25306();
                    return item;
                }
                item.clickScrollable(this.mc, mouseX, mouseY);
            }
        }
        return null;
    }

    public Button getButton(int mouseX, int mouseY) {
        for (ScrollPaneEntry entry : super.method_25396()) {
            Button item = entry.item;
            if (item == null || !this.inFullView(item) || !item.method_49606() || !item.mouseOver(mouseX, mouseY)) continue;
            return item;
        }
        return null;
    }

    public void method_25394(class_332 graphics, int mX, int mY, float partialTicks) {
        this._mouseX = mX;
        this._mouseY = mY;
        this.firstVisibleIndex = -1;
        this.lastVisibleIndex = -1;
        super.method_31322(false);
        graphics.method_51448().method_22903();
        RenderWrapper.enableDepthTest();
        this.renderBackground(graphics);
        super.method_25394(graphics, mX, mY, partialTicks);
        graphics.method_51448().method_22909();
    }

    protected void renderBackground(class_332 graphics) {
        int width = this.getWidth();
        float alpha = 0.4f;
        DrawUtil.drawRectangle(graphics.method_51448(), this.getX(), this.getY(), width, this.paneHeight, Color.BLACK.getRGB(), this.renderSolidBackground ? 1.0f : alpha);
        boolean bl = this.scrollVisible = 0 < this.method_25331();
        if (this.scrollVisible) {
            DrawUtil.drawRectangle(graphics.method_51448(), this.getX() + width - 6, this.field_19085, 5.0, this.paneHeight, Color.BLACK.getRGB(), alpha);
        }
        if (this.showFrame) {
            alpha = 1.0f;
            DrawUtil.drawRectangle(graphics.method_51448(), this.getX() - 1, this.getY() - 1, width + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics.method_51448(), this.getX() - 1, this.getY() + this.paneHeight, width + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics.method_51448(), this.getX() - 1, this.getY() - 1, 1.0, this.paneHeight + 1, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics.method_51448(), width + (this.scrollVisible ? 1 : 0) + this.getX(), this.getY() - 1, 1.0, this.paneHeight + 2, this.frameColor, alpha);
        }
    }

    public void renderItem(class_332 graphics, int index, int y, int x, int l, int var6, int var7, float f) {
        if (this.firstVisibleIndex == -1) {
            this.firstVisibleIndex = index;
        }
        this.lastVisibleIndex = Math.max(this.lastVisibleIndex, index);
        int margin = 4;
        int itemX = this.getX() + 2;
        Button item = ((ScrollPaneEntry)super.method_25326((int)index)).item;
        item.setScrollablePosition(itemX, y);
        item.setScrollableWidth(this.paneWidth - 4);
        if (this.inFullView(item)) {
            item.drawScrollable(graphics, this.mc, this._mouseX, this._mouseY);
            item.renderSpecialDecoration(graphics, this._mouseX, this._mouseY, this.getX(), this.getY(), this.getWidth(), this.field_22743);
        } else {
            int paneBottomY = this.getY() + this.paneHeight;
            int itemBottomY = y + item.getButtonHeight();
            Integer drawY = null;
            int yDiff = 0;
            if (y < this.getY() && itemBottomY > this.getY()) {
                drawY = this.getY();
                yDiff = drawY - y;
            } else if (y < paneBottomY && itemBottomY > paneBottomY) {
                drawY = y;
                yDiff = itemBottomY - paneBottomY;
            }
            if (drawY != null && this.drawPartialScrollable) {
                item.drawPartialScrollable(graphics, this.mc, itemX, drawY, item.getScrollableWidth(), item.getButtonHeight() - yDiff);
            }
        }
    }

    protected void method_44398(class_332 guiGraphics, int i, int j, int k, int l, int m) {
        if (this.renderSelection) {
            super.method_44398(guiGraphics, i, j, k, l, m);
        }
    }

    protected void method_25320(class_332 graphics, int x, int y) {
        if (this.renderDecorations) {
            class_289 tesselator = class_289.method_1348();
            class_287 bufferbuilder = tesselator.method_1349();
            RenderWrapper.depthFunc(515);
            RenderWrapper.disableDepthTest();
            RenderWrapper.enableBlend();
            RenderWrapper.blendFuncSeparate(770, 771, 0, 1);
            RenderWrapper.disableTexture();
            RenderWrapper.setShader(class_757::method_34540);
            bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            bufferbuilder.method_22912((double)this.field_19088, (double)(this.field_19085 + 5), 0.0).method_1336(0, 0, 0, 0).method_1344();
            bufferbuilder.method_22912((double)this.field_19087, (double)(this.field_19085 + 5), 0.0).method_1336(0, 0, 0, 0).method_1344();
            bufferbuilder.method_22912((double)this.field_19087, (double)this.field_19085, 0.0).method_1336(0, 0, 0, 255).method_1344();
            bufferbuilder.method_22912((double)this.field_19088, (double)this.field_19085, 0.0).method_1336(0, 0, 0, 255).method_1344();
            bufferbuilder.method_22912((double)this.field_19088, (double)this.field_19086, 0.0).method_1336(0, 0, 0, 255).method_1344();
            bufferbuilder.method_22912((double)this.field_19087, (double)this.field_19086, 0.0).method_1336(0, 0, 0, 255).method_1344();
            bufferbuilder.method_22912((double)this.field_19087, (double)(this.field_19086 - 5), 0.0).method_1336(0, 0, 0, 0).method_1344();
            bufferbuilder.method_22912((double)this.field_19088, (double)(this.field_19086 - 5), 0.0).method_1336(0, 0, 0, 0).method_1344();
            tesselator.method_1350();
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.method_25396().isEmpty()) {
            return false;
        }
        if (button == 0 && this.field_22750) {
            if (mouseY < (double)this.field_19085) {
                this.method_25307(0.0);
            } else {
                double d0 = Math.max(1, this.method_25331());
                int i = this.field_19086 - this.field_19085;
                int j = class_3532.method_15340((int)((int)((float)(i * i) / (float)this.method_25317())), (int)32, (int)(i - 8));
                double d1 = Math.max(1.0, d0 / (double)(i - j));
                this.method_25307(this.method_25341() + mouseDY * d1);
            }
            return true;
        }
        return false;
    }

    public boolean isScrollVisible() {
        return this.scrollVisible;
    }

    public boolean inFullView(Button item) {
        return item.method_46427() >= this.getY() && item.method_46427() + item.getButtonHeight() <= this.getY() + this.paneHeight;
    }

    protected int method_25329() {
        return this.paneWidth + this.getX();
    }

    protected void method_25318(double xPos, double yPos, int button) {
        double rightX = this.getX() + this.getWidth() - 5;
        this.field_22750 = button == 0 && xPos >= rightX && xPos < rightX + 10.0;
    }

    protected int method_25317() {
        return super.method_25317();
    }

    public int getWidth() {
        boolean scrollVisible = 0 < this.method_25331();
        return this.paneWidth + (scrollVisible ? 5 : 0);
    }

    public int getFitWidth(class_327 fr) {
        int fit = 0;
        for (ScrollPaneEntry entry : this.method_25396()) {
            fit = Math.max(fit, entry.item.getFitWidth(fr));
        }
        return fit;
    }

    public int method_25331() {
        return super.method_25331();
    }

    public boolean method_25405(double posX, double posY) {
        int topY = this.getY();
        int bottomY = this.getY() + this.paneHeight;
        int leftX = this.getX();
        int rightX = this.getX() + this.getWidth();
        return posY >= (double)topY && posY <= (double)bottomY && posX >= (double)leftX && posX <= (double)rightX;
    }

    public Optional<class_364> method_19355(double mouseX, double mouseY) {
        return Optional.empty();
    }

    public void method_16014(double mouseX, double mouseY) {
        for (ScrollPaneEntry entry : super.method_25396()) {
            Button item = entry.item;
            if (item == null || !this.inFullView(item)) continue;
            item.method_16014(mouseX, mouseY);
        }
        super.method_16014(mouseX, mouseY);
    }

    public void setRenderSolidBackground(boolean value) {
        this.renderSolidBackground = value;
    }

    public void setRenderDecorations(boolean value) {
        this.renderDecorations = value;
    }

    public void setRenderSelection(boolean renderSelection) {
        this.renderSelection = renderSelection;
    }

    class ScrollPaneEntry
    extends class_4280.class_4281<ScrollPaneEntry> {
        private ScrollPane parent;
        private Button item;

        public ScrollPaneEntry(ScrollPane parent, Button item) {
            this.parent = parent;
            this.item = item;
        }

        public void method_25343(class_332 graphics, int index, int y, int x, int l, int var6, int var7, int p_230432_8_, boolean p_230432_9_, float f) {
            this.parent.renderItem(graphics, index, y, x, l, var6, var7, f);
        }

        public class_2561 method_37006() {
            return null;
        }
    }
}

