/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.resourcepackchecker.mixin;

import de.maxhenkel.resourcepackchecker.IFilePackResource;
import de.maxhenkel.resourcepackchecker.ResourcePackChecker;
import de.maxhenkel.resourcepackchecker.ShaUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.minecraft.class_1066;
import net.minecraft.class_310;
import net.minecraft.class_3258;
import net.minecraft.class_3262;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1066.class})
public class DownloadedPackSourceMixin {
    private static final Pattern SERVER_PACK_PATTERN = Pattern.compile("^server_.{40}.*\\.zip$");
    @Shadow
    private class_3288 field_5295;

    @Inject(at={@At(value="HEAD")}, method={"setServerPack"}, cancellable=true)
    private void setServerPack(File file, class_5352 packSource, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        String serverPackSha1 = ShaUtils.getSha1(file);
        if (ResourcePackChecker.CLIENT_CONFIG.saveServerPacks.get().booleanValue()) {
            CompletableFuture future;
            class_3288 newPack;
            class_3283 resourcePackRepository = class_310.method_1551().method_1520();
            Path resourcePackDirectory = class_310.method_1551().method_1479();
            this.field_5295 = null;
            String packName = "";
            try (class_3258 packResources = new class_3258(file.getName(), new class_3258.class_8616(file), false, "");){
                class_3272 metadataSection = (class_3272)packResources.method_14407((class_3270)class_3272.field_14202);
                if (metadataSection != null) {
                    packName = metadataSection.comp_1580().getString().replaceAll("\u00a7[0-9a-zA-Z]", "").replace("\n", " ").replaceAll("[^a-zA-Z0-9-_. ]", "");
                } else {
                    ResourcePackChecker.LOGGER.error("Could not find metadata section in server pack");
                }
            }
            catch (IOException e) {
                ResourcePackChecker.LOGGER.error("Failed to read server pack metadata", (Throwable)e);
            }
            Path resourcePack = resourcePackDirectory.resolve("server_%s%s.zip".formatted(serverPackSha1, "_%s".formatted(packName)));
            if (Files.notExists(resourcePack, new LinkOption[0])) {
                try {
                    Files.copy(file.toPath(), resourcePack, new CopyOption[0]);
                }
                catch (IOException e) {
                    ResourcePackChecker.LOGGER.error("Failed to copy server pack", (Throwable)e);
                    return;
                }
                resourcePackRepository.method_14445();
            }
            if ((newPack = this.findPack(serverPackSha1, resourcePack)) == null) {
                ResourcePackChecker.LOGGER.error("Could not find resource pack with sha1 {}", (Object)serverPackSha1);
                return;
            }
            ArrayList<class_3288> selectedPacks = new ArrayList<class_3288>(resourcePackRepository.method_14444());
            ArrayList<class_3288> toRemove = new ArrayList<class_3288>();
            int replaceIndex = -1;
            for (class_3288 pack : selectedPacks) {
                File packFile = this.getPackFile(pack);
                if (packFile == null) continue;
                String packSha1 = this.getPackSha(pack);
                if (!SERVER_PACK_PATTERN.matcher(packFile.getName()).matches()) continue;
                if (serverPackSha1.equals(packSha1) && packFile.getName().equals(resourcePack.getFileName().toString())) {
                    if (replaceIndex >= 0) {
                        toRemove.add((class_3288)selectedPacks.get(replaceIndex));
                    }
                    replaceIndex = selectedPacks.indexOf(pack);
                    continue;
                }
                if (replaceIndex < 0) {
                    replaceIndex = selectedPacks.indexOf(pack);
                    continue;
                }
                toRemove.add(pack);
            }
            if (replaceIndex < 0) {
                selectedPacks.add(newPack);
                future = class_310.method_1551().method_1513();
            } else if (((class_3288)selectedPacks.get(replaceIndex)).method_14463().equals(newPack.method_14463())) {
                future = new CompletableFuture();
                future.complete(null);
            } else {
                selectedPacks.set(replaceIndex, newPack);
                future = class_310.method_1551().method_1513();
            }
            if (selectedPacks.removeAll(toRemove)) {
                future = class_310.method_1551().method_1513();
            }
            resourcePackRepository.method_14447(selectedPacks.stream().map(class_3288::method_14463).toList());
            cir.setReturnValue((Object)future);
            return;
        }
        Collection selectedPacks = class_310.method_1551().method_1520().method_14444();
        for (class_3288 pack : selectedPacks) {
            String packSha1 = this.getPackSha(pack);
            if (!serverPackSha1.equals(packSha1)) continue;
            this.field_5295 = null;
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            future.complete(null);
            cir.setReturnValue(future);
            break;
        }
    }

    @Unique
    @Nullable
    private class_3288 findPack(String sha1, Path path) {
        for (class_3288 pack : class_310.method_1551().method_1520().method_14441()) {
            String packSha1;
            File packFile = this.getPackFile(pack);
            if (packFile == null || !packFile.getName().equals(path.getFileName().toString()) || !sha1.equals(packSha1 = this.getPackSha(pack))) continue;
            return pack;
        }
        return null;
    }

    @Unique
    @Nullable
    private String getPackSha(class_3288 pack) {
        File packFile = this.getPackFile(pack);
        if (packFile != null) {
            return ShaUtils.getSha1(packFile);
        }
        return null;
    }

    @Unique
    @Nullable
    private File getPackFile(class_3288 pack) {
        class_3262 resources = pack.method_14458();
        if (resources instanceof IFilePackResource) {
            IFilePackResource resource = (IFilePackResource)resources;
            return resource.getFile();
        }
        return null;
    }
}

