/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.tr7zw.itemswapper.ItemSwapperSharedMod;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemEntry;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemGroup;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemGroupModifier;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemList;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemListModifier;
import dev.tr7zw.itemswapper.manager.itemgroups.Shortcut;
import dev.tr7zw.itemswapper.manager.shortcuts.LinkShortcut;
import dev.tr7zw.itemswapper.util.ComponentProvider;
import dev.tr7zw.itemswapper.util.ItemUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class SwapperResourceLoader
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private List<ItemGroup.Builder> itemGroups = new ArrayList<ItemGroup.Builder>();
    private List<ItemList.Builder> itemLists = new ArrayList<ItemList.Builder>();
    private List<ItemGroupModifier> itemGroupModifiers = new ArrayList<ItemGroupModifier>();
    private List<ItemListModifier> itemListModifiers = new ArrayList<ItemListModifier>();

    public SwapperResourceLoader() {
        super(GSON, "itemgroups");
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profilerFiller) {
        this.itemGroups.clear();
        this.itemGroupModifiers.clear();
        this.itemListModifiers.clear();
        this.itemLists.clear();
        ItemSwapperSharedMod.LOGGER.info("Processing item groups: " + map.keySet());
        ItemSwapperSharedMod.instance.getItemGroupManager().reset();
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            this.processEntry(entry);
        }
        this.applyModifications();
        this.registerItemGroups();
        this.itemGroups.clear();
        this.itemGroupModifiers.clear();
        this.itemListModifiers.clear();
        this.itemLists.clear();
    }

    private void processEntry(Map.Entry<class_2960, JsonElement> entry) {
        try {
            if (!entry.getKey().method_12836().equals("itemswapper")) {
                return;
            }
            if (entry.getKey().method_12832().startsWith("wheel_combined/")) {
                this.processCombined(entry.getKey(), entry.getValue());
                return;
            }
            if (entry.getKey().method_12832().startsWith("v2/")) {
                this.processV2(entry.getKey(), entry.getValue());
                return;
            }
            class_1792[] items = this.getItemArray(entry.getKey(), entry.getValue(), entry.getKey().method_12832().startsWith("wheel"));
            if (items != null) {
                ItemGroup.Builder group = ItemGroup.builder().withId(entry.getKey()).withItems(ItemUtil.toDefault(items));
                if (entry.getKey().method_12832().startsWith("wheel_primary/")) {
                    this.itemGroups.add(group.withPriority(100));
                }
                if (entry.getKey().method_12832().startsWith("wheel_secondary/")) {
                    this.itemGroups.add(group.withPriority(200));
                }
                if (entry.getKey().method_12832().startsWith("list/")) {
                    this.itemLists.add(ItemList.builder().withId(entry.getKey()).withItems(items));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void registerItemGroups() {
        int i;
        for (i = 0; i < this.itemGroups.size(); ++i) {
            ItemSwapperSharedMod.instance.getItemGroupManager().registerItemGroup(this.itemGroups.get(i).build());
        }
        for (i = 0; i < this.itemLists.size(); ++i) {
            ItemSwapperSharedMod.instance.getItemGroupManager().registerListCollection(this.itemLists.get(i).build());
        }
    }

    private void applyModifications() {
        ArrayList<ItemEntry> entries;
        Object modifier;
        int i;
        block0: for (i = 0; i < this.itemGroupModifiers.size(); ++i) {
            modifier = this.itemGroupModifiers.get(i);
            for (ItemGroup.Builder group : this.itemGroups) {
                if (!((ItemGroupModifier)modifier).getTarget().equals((Object)group.getId())) continue;
                entries = new ArrayList<ItemEntry>(Arrays.asList(group.getItems()));
                if (((ItemGroupModifier)modifier).getRemoveItems() != null) {
                    for (ItemEntry itemEntry : ((ItemGroupModifier)modifier).getRemoveItems()) {
                        entries.removeIf(entry -> entry.getItem().equals(remove.getItem()));
                    }
                }
                if (((ItemGroupModifier)modifier).getAddItems() != null) {
                    entries.addAll(Arrays.asList(((ItemGroupModifier)modifier).getAddItems()));
                }
                group.withItems(entries.toArray(new ItemEntry[0]));
                continue block0;
            }
        }
        block3: for (i = 0; i < this.itemListModifiers.size(); ++i) {
            modifier = this.itemListModifiers.get(i);
            for (ItemList.Builder list : this.itemLists) {
                if (!((ItemListModifier)modifier).getTarget().equals((Object)list.getId())) continue;
                entries = new ArrayList<class_1792>(Arrays.asList(list.getItems()));
                if (((ItemListModifier)modifier).getRemoveItems() != null) {
                    for (ItemEntry itemEntry : ((ItemListModifier)modifier).getRemoveItems()) {
                        entries.removeIf(arg_0 -> SwapperResourceLoader.lambda$applyModifications$1((class_1792)itemEntry, arg_0));
                    }
                }
                if (((ItemListModifier)modifier).getAddItems() != null) {
                    entries.addAll(Arrays.asList(((ItemListModifier)modifier).getAddItems()));
                }
                list.withItems(entries.toArray(new class_1792[0]));
                continue block3;
            }
        }
    }

    private void processV2(class_2960 jsonLocation, JsonElement json) {
        if (!json.isJsonObject()) {
            ItemSwapperSharedMod.LOGGER.warn("Invalid data in " + jsonLocation);
            return;
        }
        JsonObject obj = json.getAsJsonObject();
        String type = obj.get("type").getAsString();
        if (type.equals("palette")) {
            this.processPalette(jsonLocation, obj);
            return;
        }
        if (type.equals("paletteModification")) {
            this.processPaletteModification(jsonLocation, obj);
            return;
        }
        if (type.equals("listModification")) {
            this.processListModification(jsonLocation, obj);
            return;
        }
        if (type.equals("list")) {
            this.processList(jsonLocation, obj);
            return;
        }
    }

    private void processList(class_2960 jsonLocation, JsonObject json) {
        class_1792[] ignoreItems;
        ItemList.Builder group = ItemList.builder().withId(jsonLocation);
        if (json.has("disableAutoLink") && json.get("disableAutoLink").isJsonPrimitive()) {
            group.withDisableAutoLink(json.get("disableAutoLink").getAsBoolean());
        }
        if (json.has("displayName") && json.get("displayName").isJsonPrimitive()) {
            group.withDisplayName((class_2561)ComponentProvider.translatable(json.get("displayName").getAsString()));
        }
        if (json.has("link") && json.get("link").isJsonPrimitive()) {
            try {
                group.withLink(new class_2960(json.getAsJsonPrimitive("link").getAsString()));
            }
            catch (Exception ex) {
                ItemSwapperSharedMod.LOGGER.warn("Invalid link in " + jsonLocation);
            }
        }
        group.withItems(this.getItemArray(jsonLocation, json.get("items"), false));
        class_1792[] openOnly = this.getItemArray(jsonLocation, json.get("openOnlyItems"), false);
        if (openOnly != null && openOnly.length > 0) {
            group.withOpenOnlyItems(new HashSet<class_1792>(Arrays.asList(openOnly)));
        }
        if ((ignoreItems = this.getItemArray(jsonLocation, json.get("ignoreItems"), false)) != null && ignoreItems.length > 0) {
            group.withIgnoreItems(new HashSet<class_1792>(Arrays.asList(ignoreItems)));
        }
        if (json.has("icon") && json.get("icon").isJsonPrimitive()) {
            group.withIcon((class_1792)class_7923.field_41178.method_10223(new class_2960(json.get("icon").getAsString())));
        }
        this.itemLists.add(group);
    }

    private void processPalette(class_2960 jsonLocation, JsonObject json) {
        class_1792[] ignoreItems;
        ItemGroup.Builder group = ItemGroup.builder().withId(jsonLocation);
        if (json.has("priority") && json.get("priority").isJsonPrimitive()) {
            group.withPriority(json.getAsJsonPrimitive("priority").getAsInt());
        } else {
            group.withPriority(100);
        }
        if (json.has("fallbackLink") && json.get("fallbackLink").isJsonPrimitive()) {
            try {
                group.withFallbackLink(new class_2960(json.getAsJsonPrimitive("fallbackLink").getAsString()));
            }
            catch (Exception ex) {
                ItemSwapperSharedMod.LOGGER.warn("Invalid fallbackLink in " + jsonLocation);
            }
        }
        if (json.has("forceLink") && json.get("forceLink").isJsonPrimitive()) {
            try {
                group.withForcedLink(new class_2960(json.getAsJsonPrimitive("forceLink").getAsString()));
            }
            catch (Exception ex) {
                ItemSwapperSharedMod.LOGGER.warn("Invalid forceLink in " + jsonLocation);
            }
        }
        if (json.has("disableAutoLink") && json.get("disableAutoLink").isJsonPrimitive()) {
            group.withDisableAutoLink(json.get("disableAutoLink").getAsBoolean());
        }
        if (json.has("displayName") && json.get("displayName").isJsonPrimitive()) {
            group.withDisplayName((class_2561)ComponentProvider.translatable(json.get("displayName").getAsString()));
        }
        group.withItems(this.processItems(jsonLocation, json.get("items")));
        class_1792[] openOnly = this.getItemArray(jsonLocation, json.get("openOnlyItems"), false);
        if (openOnly != null && openOnly.length > 0) {
            group.withOpenOnlyItems(new HashSet<class_1792>(Arrays.asList(openOnly)));
        }
        if ((ignoreItems = this.getItemArray(jsonLocation, json.get("ignoreItems"), false)) != null && ignoreItems.length > 0) {
            group.withIgnoreItems(new HashSet<class_1792>(Arrays.asList(ignoreItems)));
        }
        group.withShortcuts(this.processShortcuts(jsonLocation, json.get("shortcuts")));
        if (json.has("icon") && json.get("icon").isJsonPrimitive()) {
            group.withIcon((class_1792)class_7923.field_41178.method_10223(new class_2960(json.get("icon").getAsString())));
        }
        this.itemGroups.add(group);
    }

    private void processListModification(class_2960 jsonLocation, JsonObject json) {
        ItemListModifier.Builder changes = ItemListModifier.builder();
        if (json.has("target") && json.get("target").isJsonPrimitive()) {
            try {
                changes.withTarget(new class_2960(json.getAsJsonPrimitive("target").getAsString()));
            }
            catch (Exception ex) {
                ItemSwapperSharedMod.LOGGER.warn("Invalid target in " + jsonLocation);
                return;
            }
        }
        changes.withAddItems(this.getItemArray(jsonLocation, json.get("addItems"), false));
        changes.withRemoveItems(this.getItemArray(jsonLocation, json.get("removeItems"), false));
        this.itemListModifiers.add(changes.build());
    }

    private void processPaletteModification(class_2960 jsonLocation, JsonObject json) {
        ItemGroupModifier.Builder changes = ItemGroupModifier.builder();
        if (json.has("target") && json.get("target").isJsonPrimitive()) {
            try {
                changes.withTarget(new class_2960(json.getAsJsonPrimitive("target").getAsString()));
            }
            catch (Exception ex) {
                ItemSwapperSharedMod.LOGGER.warn("Invalid target in " + jsonLocation);
                return;
            }
        }
        changes.withAddItems(this.processItems(jsonLocation, json.get("addItems")));
        changes.withRemoveItems(this.processItems(jsonLocation, json.get("removeItems")));
        this.itemGroupModifiers.add(changes.build());
    }

    private List<Shortcut> processShortcuts(class_2960 jsonLocation, JsonElement object) {
        if (object == null || !object.isJsonArray()) {
            return Collections.emptyList();
        }
        ArrayList<Shortcut> shortcuts = new ArrayList<Shortcut>();
        object.getAsJsonArray().forEach(el -> {
            if (!el.isJsonObject()) {
                return;
            }
            JsonObject entry = el.getAsJsonObject();
            if (entry.has("type") && entry.get("type").isJsonPrimitive() && "link".equals(entry.get("type").getAsString())) {
                String displayname = entry.has("displayName") && entry.get("displayName").isJsonPrimitive() ? entry.get("displayName").getAsString() : null;
                class_1792 icon = null;
                if (entry.has("icon") && entry.get("icon").isJsonPrimitive()) {
                    icon = (class_1792)class_7923.field_41178.method_10223(new class_2960(entry.get("icon").getAsString()));
                }
                try {
                    shortcuts.add(new LinkShortcut(new class_2960(entry.getAsJsonPrimitive("target").getAsString()), (class_2561)(displayname != null ? ComponentProvider.translatable(displayname) : null), icon));
                }
                catch (Exception ex) {
                    ItemSwapperSharedMod.LOGGER.warn("Invalid link target shortcut in " + jsonLocation);
                }
            }
        });
        return shortcuts;
    }

    private ItemEntry[] processItems(class_2960 jsonLocation, JsonElement object) {
        if (object == null || !object.isJsonArray()) {
            return null;
        }
        ArrayList itemList = new ArrayList();
        object.getAsJsonArray().forEach(el -> {
            class_2960 resourceLocation;
            class_1792 item;
            ItemEntry entry;
            if (el.isJsonPrimitive() && !itemList.contains(entry = new ItemEntry(item = (class_1792)class_7923.field_41178.method_10223(resourceLocation = new class_2960(el.getAsString())), null))) {
                itemList.add(entry);
            }
            if (el.isJsonObject()) {
                ItemEntry entry2;
                JsonObject obj = el.getAsJsonObject();
                class_2960 resourceLocation2 = new class_2960(obj.get("id").getAsString());
                class_1792 item2 = (class_1792)class_7923.field_41178.method_10223(resourceLocation2);
                class_2960 link = null;
                if (obj.has("link") && obj.get("link").isJsonPrimitive()) {
                    try {
                        link = new class_2960(obj.get("link").getAsString());
                    }
                    catch (Exception ex) {
                        ItemSwapperSharedMod.LOGGER.warn("Invalid item link in " + jsonLocation);
                    }
                }
                String displayName = null;
                if (obj.has("name") && obj.get("name").isJsonPrimitive()) {
                    displayName = obj.getAsJsonPrimitive("name").getAsString();
                }
                boolean actAsLink = false;
                if (obj.has("actAsLink") && obj.get("actAsLink").isJsonPrimitive()) {
                    actAsLink = obj.getAsJsonPrimitive("actAsLink").getAsBoolean();
                }
                if (!itemList.contains(entry2 = new ItemEntry(item2, link, (class_2561)(displayName != null ? ComponentProvider.translatable(displayName) : null), actAsLink))) {
                    itemList.add(entry2);
                }
            }
        });
        if (!itemList.isEmpty()) {
            return itemList.toArray(new ItemEntry[0]);
        }
        return null;
    }

    private void processCombined(class_2960 jsonLocation, JsonElement json) {
        int i;
        if (json == null || !json.isJsonArray()) {
            return;
        }
        JsonArray ar = json.getAsJsonArray();
        ArrayList<class_1792[]> lists = new ArrayList<class_1792[]>();
        for (i = 0; i < ar.size(); ++i) {
            class_1792[] list = this.getItemArray(jsonLocation, ar.get(i), true);
            if (list == null || list.length <= 0) continue;
            lists.add(list);
        }
        if (lists.isEmpty()) {
            return;
        }
        for (i = 0; i < lists.size(); ++i) {
            class_2960 ownId = new class_2960(jsonLocation.method_12836(), jsonLocation.method_12832() + i);
            int next = i + 1 == lists.size() ? 0 : i + 1;
            class_2960 nextId = new class_2960(jsonLocation.method_12836(), jsonLocation.method_12832() + next);
            this.itemGroups.add(ItemGroup.builder().withId(ownId).withForcedLink(nextId).withItems(ItemUtil.toDefault((class_1792[])lists.get(i))).withShortcuts(Arrays.asList(new LinkShortcut(nextId))));
        }
    }

    private class_1792[] getItemArray(class_2960 jsonLocation, JsonElement json, boolean pallet) {
        if (json == null || !json.isJsonArray()) {
            return null;
        }
        ArrayList itemList = new ArrayList();
        json.getAsJsonArray().forEach(el -> {
            if (el.isJsonPrimitive()) {
                class_2960 resourceLocation = new class_2960(el.getAsString());
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(resourceLocation);
                if (item.equals(class_1802.field_8162)) {
                    ItemSwapperSharedMod.LOGGER.warn("Unknown item: " + el.getAsString() + " in " + jsonLocation);
                    if (pallet) {
                        itemList.add(class_1802.field_8162);
                    }
                    return;
                }
                if (!itemList.contains(item)) {
                    itemList.add(item);
                }
            }
        });
        if (!itemList.isEmpty()) {
            return itemList.toArray(new class_1792[0]);
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$applyModifications$1(class_1792 remove, class_1792 entry) {
        return entry.equals(remove);
    }
}

