/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorRegistry;
import com.misterpemodder.shulkerboxtooltip.impl.PluginManager;
import com.misterpemodder.shulkerboxtooltip.impl.color.ColorRegistryImpl;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.config.ShulkerBoxTooltipConfigSerializer;
import com.misterpemodder.shulkerboxtooltip.impl.config.annotation.AutoTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.config.annotation.Validator;
import com.misterpemodder.shulkerboxtooltip.impl.util.Key;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigManager;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.gui.ConfigScreenProvider;
import me.shedaniel.autoconfig.gui.DefaultGuiProviders;
import me.shedaniel.autoconfig.gui.DefaultGuiTransformers;
import me.shedaniel.autoconfig.gui.registry.ComposedGuiRegistryAccess;
import me.shedaniel.autoconfig.gui.registry.DefaultGuiRegistryAccess;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.autoconfig.gui.registry.api.GuiRegistryAccess;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.KeyCodeEntry;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.clothconfig2.impl.builders.KeyCodeBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_2477;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3675;
import net.minecraft.class_437;

public final class ConfigurationHandler {
    public static Configuration copyOf(Configuration source) {
        Configuration c = new Configuration();
        c.preview = Configuration.PreviewCategory.copyFrom(source.preview);
        c.tooltip = Configuration.TooltipCategory.copyFrom(source.tooltip);
        c.server = Configuration.ServerCategory.copyFrom(source.server);
        if (ShulkerBoxTooltip.isClient()) {
            c.colors = Configuration.ColorsCategory.copyFrom(source.colors);
            c.controls = Configuration.ControlsCategory.copyFrom(source.controls);
        }
        return c;
    }

    public static Configuration register() {
        Configuration configuration = (Configuration)AutoConfig.register(Configuration.class, ShulkerBoxTooltipConfigSerializer::new).getConfig();
        AutoConfig.getConfigHolder(Configuration.class).registerSaveListener((holder, config) -> {
            ConfigurationHandler.onSave();
            return class_1269.field_5811;
        });
        if (ShulkerBoxTooltip.isClient()) {
            ClientOnly.registerGui();
        }
        return configuration;
    }

    private static Optional<class_2561[]> splitTooltipKey(String key) {
        String[] lines = class_2477.method_10517().method_48307(key).split("\n");
        class_2561[] tooltip = new class_2561[lines.length];
        int l = lines.length;
        for (int i = 0; i < l; ++i) {
            tooltip[i] = class_2561.method_43470((String)lines[i]);
        }
        return Optional.of(tooltip);
    }

    public static void validate(Configuration config) throws ConfigData.ValidationException {
        ConfigurationHandler.runValidators(Configuration.PreviewCategory.class, config.preview, "preview");
        ConfigurationHandler.runValidators(Configuration.TooltipCategory.class, config.tooltip, "tooltip");
        ConfigurationHandler.runValidators(Configuration.ServerCategory.class, config.server, "server");
        if (ShulkerBoxTooltip.isClient()) {
            ClientOnly.validate(config);
        }
    }

    private static <T> void runValidators(Class<T> categoryClass, T category, String categoryName) throws ConfigData.ValidationException {
        try {
            for (Field field : categoryClass.getDeclaredFields()) {
                Validator validator = field.getAnnotation(Validator.class);
                if (validator == null) continue;
                field.setAccessible(true);
                Optional<class_2561> errorMsg = ConfigurationHandler.getValidatorFunction(validator).apply(field.get(category));
                if (!errorMsg.isPresent()) continue;
                throw new ConfigData.ValidationException("ShulkerBoxTooltip config field " + categoryName + "." + field.getName() + " is invalid: " + class_2477.method_10517().method_48307(errorMsg.get().getString()));
            }
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new ConfigData.ValidationException((Throwable)e);
        }
    }

    private static Function<Object, Optional<class_2561>> getValidatorFunction(Validator validator) {
        try {
            Constructor<? extends Function<Object, Optional<class_2561>>> constructor = validator.value().getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Couldn't create config validator", e);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void reinitClientSideSyncedValues(Configuration config) {
        config.server.clientIntegration = false;
        config.server.enderChestSyncType = Configuration.EnderChestSyncType.NONE;
    }

    public static void onSave() {
        if (ShulkerBoxTooltip.savedConfig == null) {
            return;
        }
        Configuration.ServerCategory serverCategory = ShulkerBoxTooltip.config == null ? new Configuration.ServerCategory() : ShulkerBoxTooltip.config.server;
        ShulkerBoxTooltip.config = ConfigurationHandler.copyOf(ShulkerBoxTooltip.savedConfig);
        ShulkerBoxTooltip.config.server = serverCategory;
    }

    public static void readFromPacketBuf(Configuration config, class_2540 buf) {
        class_2487 compound = buf.method_10798();
        if (compound != null && compound.method_10573("server", 10)) {
            class_2487 serverTag = compound.method_10562("server");
            if (serverTag.method_10573("clientIntegration", 1)) {
                config.server.clientIntegration = serverTag.method_10577("clientIntegration");
            }
            if (serverTag.method_10573("enderChestSyncType", 8)) {
                config.server.enderChestSyncType = ConfigurationHandler.getEnumFromName(Configuration.EnderChestSyncType.class, Configuration.EnderChestSyncType.NONE, serverTag.method_10558("enderChestSyncType"));
            }
        }
    }

    public static void writeToPacketBuf(Configuration config, class_2540 buf) {
        class_2487 compound = new class_2487();
        class_2487 serverTag = new class_2487();
        serverTag.method_10556("clientIntegration", config.server.clientIntegration);
        serverTag.method_10582("enderChestSyncType", config.server.enderChestSyncType.name());
        compound.method_10566("server", (class_2520)serverTag);
        buf.method_10794((class_2520)compound);
    }

    private static <E extends Enum<E>> E getEnumFromName(Class<E> clazz, E defaultValue, String name) {
        if (clazz != null && name != null) {
            try {
                E e = Enum.valueOf(clazz, name);
                return e == null ? defaultValue : e;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Environment(value=EnvType.CLIENT)
    public static final class ClientOnly {
        private static final GuiRegistry defaultGuiRegistry = DefaultGuiTransformers.apply((GuiRegistry)DefaultGuiProviders.apply((GuiRegistry)new GuiRegistry()));

        public static void validate(Configuration config) throws ConfigData.ValidationException {
            ConfigurationHandler.runValidators(Configuration.ColorsCategory.class, config.colors, "colors");
            if (config.controls.previewKey == null) {
                config.controls.previewKey = Key.defaultPreviewKey();
            }
            if (config.controls.fullPreviewKey == null) {
                config.controls.fullPreviewKey = Key.defaultFullPreviewKey();
            }
            if (config.controls.lockTooltipKey == null) {
                config.controls.lockTooltipKey = Key.defaultLockTooltipKey();
            }
            ConfigurationHandler.runValidators(Configuration.ControlsCategory.class, config.controls, "controls");
        }

        private static void registerGui() {
            GuiRegistry registry = AutoConfig.getGuiRegistry(Configuration.class);
            registry.registerAnnotationTransformer((guis, i13n, field, config, defaults, guiRegistry) -> guis.stream().peek(gui -> {
                if (gui instanceof TooltipListEntry) {
                    TooltipListEntry entry = (TooltipListEntry)gui;
                    entry.setTooltipSupplier(() -> ConfigurationHandler.splitTooltipKey(i13n + ".tooltip"));
                }
            }).collect(Collectors.toList()), new Class[]{AutoTooltip.class});
            registry.registerAnnotationTransformer((guis, i13n, field, config, defaults, guiRegistry) -> guis.stream().peek(gui -> {
                Function<Object, Optional<class_2561>> validator = ConfigurationHandler.getValidatorFunction(field.getAnnotation(Validator.class));
                gui.setErrorSupplier(() -> (Optional)validator.apply(gui.getValue()));
            }).collect(Collectors.toList()), new Class[]{Validator.class});
            registry.registerTypeProvider(ClientOnly::buildKeybindingEntry, new Class[]{Key.class});
            registry.registerTypeProvider(ClientOnly::buildColorsCategory, new Class[]{ColorRegistry.class});
        }

        private static List<AbstractConfigListEntry> buildKeybindingEntry(String i18n, Field field, Object config, Object defaults, GuiRegistryAccess guiRegistry) {
            if (field.isAnnotationPresent(ConfigEntry.Gui.Excluded.class)) {
                return Collections.emptyList();
            }
            KeyCodeBuilder builder = ConfigEntryBuilder.create().startKeyCodeField((class_2561)class_2561.method_43471((String)i18n), ((Key)Utils.getUnsafely((Field)field, (Object)config, (Object)new Key(class_3675.field_16237))).get()).setDefaultValue(() -> ((Key)Utils.getUnsafely((Field)field, (Object)defaults)).get());
            KeyCodeEntry entry = ClientOnly.setKeySaveConsumer(builder, newValue -> ((Key)Utils.getUnsafely((Field)field, (Object)config, (Object)new Key(class_3675.field_16237))).set((class_3675.class_306)newValue)).build();
            entry.setAllowMouse(false);
            return Collections.singletonList(entry);
        }

        private static List<AbstractConfigListEntry> buildColorsCategory(String i18n, Field field, Object config, Object defaults, GuiRegistryAccess guiRegistry) {
            ArrayList<AbstractConfigListEntry> guis = new ArrayList<AbstractConfigListEntry>();
            ColorRegistry.Category defaultCategory = ColorRegistryImpl.INSTANCE.defaultCategory();
            defaultCategory.keys().entrySet().stream().map(entry -> ClientOnly.colorKeyEntry(defaultCategory, entry)).forEachOrdered(guis::add);
            for (Map.Entry<class_2960, ColorRegistry.Category> categoryEntry : ColorRegistryImpl.INSTANCE.categories().entrySet()) {
                class_2960 id = categoryEntry.getKey();
                ColorRegistry.Category category = categoryEntry.getValue();
                if (category == defaultCategory) continue;
                guis.add((AbstractConfigListEntry)ConfigEntryBuilder.create().startSubCategory((class_2561)class_2561.method_43471((String)("shulkerboxtooltip.colors." + id.method_12836() + "." + id.method_12832())), category.keys().entrySet().stream().map(entry -> ClientOnly.colorKeyEntry(category, entry)).toList()).build());
            }
            return guis;
        }

        private static AbstractConfigListEntry colorKeyEntry(ColorRegistry.Category category, Map.Entry<String, ColorKey> entry) {
            ColorKey colorKey = entry.getValue();
            return ConfigEntryBuilder.create().startColorField((class_2561)class_2561.method_43471((String)category.keyUnlocalizedName(colorKey)), colorKey.rgb()).setDefaultValue(colorKey.defaultRgb()).setSaveConsumer(colorKey::setRgb).build();
        }

        private static KeyCodeBuilder setKeySaveConsumer(KeyCodeBuilder builder, Consumer<class_3675.class_306> consumer) {
            try {
                Method method = builder.getClass().getMethod("setSaveConsumer", Consumer.class);
                method.setAccessible(true);
                method.invoke((Object)builder, consumer);
                return builder;
            }
            catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException method) {
                try {
                    Method method2 = builder.getClass().getMethod("setKeySaveConsumer", Consumer.class);
                    method2.setAccessible(true);
                    method2.invoke((Object)builder, consumer);
                    return builder;
                }
                catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    ShulkerBoxTooltip.LOGGER.warn("Could not save keybinding entries from config GUI");
                    return builder;
                }
            }
        }

        public static class_437 makeConfigScreen(class_437 parent) {
            PluginManager.loadColors();
            ComposedGuiRegistryAccess registryAccess = new ComposedGuiRegistryAccess(new GuiRegistryAccess[]{defaultGuiRegistry, AutoConfig.getGuiRegistry(Configuration.class), new DefaultGuiRegistryAccess()});
            return new ConfigScreenProvider((ConfigManager)AutoConfig.getConfigHolder(Configuration.class), (GuiRegistryAccess)registryAccess, parent).get();
        }
    }
}

