/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import traben.entity_model_features.EMFVersionDifferenceManager;
import traben.entity_model_features.utils.EMFUtils;

public class EMFConfig {
    private static EMFConfig EMF_CONFIG_SINGLETON;
    public boolean logModelCreationData = false;
    public RenderModeChoice renderModeChoice = RenderModeChoice.NORMAL;
    public VanillaModelRenderMode vanillaModelHologramRenderMode = VanillaModelRenderMode.Off;
    public boolean attemptRevertingEntityModelsAlteredByAnotherMod = true;
    public UnknownModelPrintMode logUnknownOrModdedEntityModels = UnknownModelPrintMode.NONE;
    public PhysicsModCompatChoice attemptPhysicsModPatch_2 = PhysicsModCompatChoice.CUSTOM;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EMFConfig emfConfig = (EMFConfig)o;
        return this.logModelCreationData == emfConfig.logModelCreationData && this.attemptRevertingEntityModelsAlteredByAnotherMod == emfConfig.attemptRevertingEntityModelsAlteredByAnotherMod && this.renderModeChoice == emfConfig.renderModeChoice && this.vanillaModelHologramRenderMode == emfConfig.vanillaModelHologramRenderMode && this.logUnknownOrModdedEntityModels == emfConfig.logUnknownOrModdedEntityModels && this.attemptPhysicsModPatch_2 == emfConfig.attemptPhysicsModPatch_2;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.logModelCreationData, this.renderModeChoice, this.vanillaModelHologramRenderMode, this.attemptRevertingEntityModelsAlteredByAnotherMod, this.logUnknownOrModdedEntityModels, this.attemptPhysicsModPatch_2});
    }

    public static EMFConfig getConfig() {
        if (EMF_CONFIG_SINGLETON == null) {
            EMFConfig.loadConfig();
        }
        return EMF_CONFIG_SINGLETON;
    }

    public static void setConfig(EMFConfig newConfig) {
        if (newConfig != null) {
            EMF_CONFIG_SINGLETON = newConfig;
        }
    }

    public static void EMF_saveConfig() {
        File config = new File(EMFVersionDifferenceManager.getConfigDirectory().toFile(), "entity_model_features.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!config.getParentFile().exists()) {
            config.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(config);
            fileWriter.write(gson.toJson((Object)EMF_CONFIG_SINGLETON));
            fileWriter.close();
        }
        catch (IOException e) {
            EMFUtils.EMFModMessage("Config could not be saved", false);
        }
    }

    public static void loadConfig() {
        try {
            File config = new File(EMFVersionDifferenceManager.getConfigDirectory().toFile(), "entity_model_features.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (config.exists()) {
                try {
                    FileReader fileReader = new FileReader(config);
                    EMF_CONFIG_SINGLETON = (EMFConfig)gson.fromJson((Reader)fileReader, EMFConfig.class);
                    fileReader.close();
                    EMFConfig.EMF_saveConfig();
                }
                catch (IOException e) {
                    EMFUtils.EMFModMessage("Config could not be loaded, using defaults", false);
                }
            } else {
                EMF_CONFIG_SINGLETON = new EMFConfig();
                EMFConfig.EMF_saveConfig();
            }
            if (EMF_CONFIG_SINGLETON == null) {
                EMF_CONFIG_SINGLETON = new EMFConfig();
                EMFConfig.EMF_saveConfig();
            }
        }
        catch (Exception e) {
            EMF_CONFIG_SINGLETON = new EMFConfig();
        }
    }

    public static EMFConfig copyFrom(EMFConfig source) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return (EMFConfig)gson.fromJson(gson.toJson((Object)source), EMFConfig.class);
    }

    public static enum RenderModeChoice {
        NORMAL((class_2561)class_2561.method_43471((String)"entity_model_features.config.render.normal")),
        GREEN((class_2561)class_2561.method_43471((String)"entity_model_features.config.render.green")),
        LINES((class_2561)class_2561.method_43471((String)"entity_model_features.config.render.lines")),
        NONE((class_2561)class_2561.method_43471((String)"entity_model_features.config.render.none"));

        private final class_2561 text;

        private RenderModeChoice(class_2561 text) {
            this.text = text;
        }

        public class_2561 asText() {
            return this.text;
        }

        public RenderModeChoice next() {
            return switch (this) {
                case NORMAL -> GREEN;
                case GREEN -> LINES;
                case LINES -> NONE;
                default -> NORMAL;
            };
        }
    }

    public static enum VanillaModelRenderMode {
        Off(class_5244.field_24333),
        Position_normal((class_2561)class_2561.method_43471((String)"entity_model_features.config.vanilla_render.normal")),
        Positon_offset((class_2561)class_2561.method_43471((String)"entity_model_features.config.vanilla_render.offset"));

        private final class_2561 text;

        private VanillaModelRenderMode(class_2561 text) {
            this.text = text;
        }

        public class_2561 asText() {
            return this.text;
        }

        public VanillaModelRenderMode next() {
            return switch (this) {
                case Off -> Position_normal;
                case Position_normal -> Positon_offset;
                default -> Off;
            };
        }
    }

    public static enum UnknownModelPrintMode {
        NONE(class_5244.field_24333),
        LOG_ONLY((class_2561)class_2561.method_43471((String)"entity_model_features.config.unknown_model_print_mode.log")),
        LOG_AND_JEM((class_2561)class_2561.method_43471((String)"entity_model_features.config.unknown_model_print_mode.log_jem"));

        private final class_2561 text;

        private UnknownModelPrintMode(class_2561 text) {
            this.text = text;
        }

        public class_2561 asText() {
            return this.text;
        }

        public UnknownModelPrintMode next() {
            return switch (this) {
                case NONE -> LOG_ONLY;
                case LOG_ONLY -> LOG_AND_JEM;
                default -> NONE;
            };
        }
    }

    public static enum PhysicsModCompatChoice {
        OFF(class_5244.field_24333),
        VANILLA((class_2561)class_2561.method_43471((String)"entity_model_features.config.physics.1")),
        CUSTOM((class_2561)class_2561.method_43471((String)"entity_model_features.config.physics.2"));

        private final class_2561 text;

        private PhysicsModCompatChoice(class_2561 text) {
            this.text = text;
        }

        public class_2561 asText() {
            return this.text;
        }

        public PhysicsModCompatChoice next() {
            return switch (this) {
                case OFF -> CUSTOM;
                case CUSTOM -> VANILLA;
                default -> OFF;
            };
        }
    }
}

