/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_fabric.schematic;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.schematic.ParsedSchematicObject;
import com.natamus.collective_common_fabric.schematic.Schematic;
import com.natamus.collective_common_fabric.schematic.SchematicBlockObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;

public class ParseSchematicFile {
    public static ParsedSchematicObject getParsedSchematicObject(InputStream schematicInputStream, class_1937 level, class_2338 centerPos, int extraYOffset, boolean skipAir) {
        return ParseSchematicFile.getParsedSchematicObject(schematicInputStream, level, centerPos, extraYOffset, skipAir, true);
    }

    public static ParsedSchematicObject getParsedSchematicObject(InputStream schematicInputStream, class_1937 level, class_2338 centerPos, int extraYOffset, boolean skipAir, boolean automaticCenter) {
        Schematic schematic = new Schematic(schematicInputStream);
        int maxBuildHeight = level.method_31600();
        short length = schematic.getLength();
        short width = schematic.getWidth();
        short height = schematic.getHeight();
        int xoffset = schematic.getOffsetX();
        int yoffset = centerPos.method_10264() + extraYOffset;
        int zoffset = schematic.getOffsetZ();
        if (automaticCenter) {
            xoffset = -(width / 2);
            if (yoffset + height > maxBuildHeight) {
                yoffset = maxBuildHeight - height;
            }
            zoffset = -(length / 2);
        } else {
            yoffset += schematic.getOffsetY();
        }
        ArrayList<Pair<class_2338, class_2680>> blocks = new ArrayList<Pair<class_2338, class_2680>>();
        for (SchematicBlockObject blockObject : schematic.getBlocks()) {
            if (blockObject == null) continue;
            class_2680 blockState = blockObject.getState();
            if (skipAir && blockState.method_26204().equals(class_2246.field_10124)) continue;
            blocks.add(new Pair((Object)blockObject.getPosition().method_10069(centerPos.method_10263() + xoffset, yoffset, centerPos.method_10260() + zoffset).method_10062(), (Object)blockState));
        }
        ArrayList<Pair<class_2338, class_1297>> entities = new ArrayList<Pair<class_2338, class_1297>>();
        for (Pair<class_2338, class_2487> rawEntityPair : schematic.getEntityRelativePosPairs()) {
            Optional optionalNewEntity = class_1299.method_5892((class_2487)((class_2487)rawEntityPair.getSecond()), (class_1937)level);
            if (!optionalNewEntity.isPresent()) continue;
            class_2338 actualEntityPosition = ((class_2338)rawEntityPair.getFirst()).method_10069(centerPos.method_10263() + xoffset, yoffset, centerPos.method_10260() + zoffset).method_10062();
            class_1297 newEntity = (class_1297)optionalNewEntity.get();
            newEntity.method_5814((double)actualEntityPosition.method_10263() + 0.5, (double)actualEntityPosition.method_10264(), (double)actualEntityPosition.method_10260() + 0.5);
            entities.add((Pair<class_2338, class_1297>)new Pair((Object)actualEntityPosition, (Object)newEntity));
        }
        ArrayList<class_2338> blockEntityPositions = new ArrayList<class_2338>();
        for (class_2487 blockEntityCompoundTag : schematic.getBlockEntities()) {
            blockEntityPositions.add(schematic.getBlockPosFromCompoundTag(blockEntityCompoundTag).method_10069(centerPos.method_10263() + xoffset, yoffset, centerPos.method_10260() + zoffset));
        }
        return new ParsedSchematicObject(schematic, blocks, entities, blockEntityPositions, "Parsed successfully.", true);
    }
}

