/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.tabs;

import io.github.thecsdev.betterstats.api.client.gui.util.StatsTabUtils;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.config.TConfigPanelBuilder;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class BSCreditsTab
extends StatsTab {
    public static final class_2561 TEXT_TITLE = TextUtils.translatable((String)"credits_and_attribution.button.credits", (Object[])new Object[0]);
    public static final class_2561 TEXT_OPEN_LINK = TextUtils.translatable((String)"mco.notification.visitUrl.buttonText.default", (Object[])new Object[0]);

    @Override
    public final class_2561 getName() {
        return TEXT_TITLE;
    }

    @Override
    public final boolean isAvailable() {
        return false;
    }

    @Override
    public final void initStats(StatsTab.StatsInitContext initContext) {
        TPanelElement panel = initContext.getStatsPanel();
        TLabelElement lbl_title = StatsTabUtils.initGroupLabel(panel, TEXT_TITLE);
        lbl_title.setTextColor(0xFFFFFF);
        lbl_title.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
        StatsTabUtils.initGroupLabel(panel, (class_2561)TextUtils.translatable((String)"betterstats.translators.title", (Object[])new Object[0]));
        String[] translators = BSCreditsTab.getTranslatorEntries();
        if (translators.length == 0) {
            translators = new String[]{"-"};
        }
        for (String translator : translators) {
            Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect((TPanelElement)panel);
            TLabelElement lbl_t = new TLabelElement(n1.x, n1.y, n1.width, n1.height, (class_2561)TextUtils.literal((String)translator));
            panel.addChild((TElement)lbl_t, false);
            String visit_url = BSCreditsTab.translatorEntryToUrl(translator);
            TButtonWidget btn_visit = new TButtonWidget(n1.x + n1.width - 100, n1.y, 100, n1.height);
            btn_visit.setText(TEXT_OPEN_LINK);
            btn_visit.setEnabled(visit_url != null);
            btn_visit.setOnClick(btn -> GuiUtils.showUrlPrompt((String)visit_url, (boolean)false));
            panel.addChild((TElement)btn_visit, false);
        }
    }

    @Override
    public final void initFilters(StatsTab.FiltersInitContext initContext) {
        StatsTabUtils.initDefaultFilters(initContext);
    }

    public static final String[] getTranslatorEntries() {
        String translators = TextUtils.translatable((String)"betterstats.translators", (Object[])new Object[0]).getString();
        if (StringUtils.isBlank((CharSequence)translators)) {
            return new String[0];
        }
        ArrayList names = new ArrayList(Arrays.asList(translators.split(",")));
        names.removeIf(name -> StringUtils.isBlank((CharSequence)name));
        names = names.stream().map(name -> name.trim()).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        return names.toArray(new String[0]);
    }

    @Nullable
    public static final String translatorEntryToUrl(String translator) {
        if (StringUtils.isBlank((CharSequence)translator) || Objects.equals(translator, "-")) {
            return null;
        }
        if (translator.startsWith("http://") || translator.startsWith("https://")) {
            return translator;
        }
        if (translator.contains(Character.toString(':'))) {
            return "https://github.com/" + new class_2960(translator).method_12836();
        }
        return "https://github.com/" + translator;
    }
}

