/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.placeholder.v2.placeholders.advanced;

import de.keksuccino.fancymenu.menu.placeholder.v2.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.menu.placeholder.v2.Placeholder;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.objecthunter.exp4j.Expression;
import de.keksuccino.konkrete.objecthunter.exp4j.ExpressionBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CalculatorPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public CalculatorPlaceholder() {
        super("calc");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String ex;
        String decimalString = dps.values.get("decimal");
        boolean decimal = true;
        if (decimalString != null && decimalString.equalsIgnoreCase("false")) {
            decimal = false;
        }
        if ((ex = dps.values.get("expression")) != null) {
            try {
                Expression expression = new ExpressionBuilder(ex).build();
                if (expression.validate().isValid()) {
                    if (decimal) {
                        return "" + expression.evaluate();
                    }
                    return "" + Math.round(expression.evaluate());
                }
            }
            catch (Exception exception) {
                LOGGER.error("[FANCYMENU] Failed to parse expression in Calculator placeholder: Placeholder: " + dps + " | Original String: " + dps.originalString, (Throwable)exception);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("expression");
        l.add("decimal");
        return l;
    }

    @Override
    public String getDisplayName() {
        return Locals.localize((String)"fancymenu.helper.placeholder.calc", (String[])new String[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.placeholder.calc.desc", (String[])new String[0]), (String)"%n%"));
    }

    @Override
    public String getCategory() {
        return Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.advanced", (String[])new String[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("decimal", "true");
        m.put("expression", "2 + 1 - 10");
        return DeserializedPlaceholderString.build(this.getIdentifier(), m);
    }
}

