/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.v3.rendering.ui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.mixin.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.mixin.client.IMixinButton;
import de.keksuccino.fancymenu.v3.ConsumingSupplier;
import de.keksuccino.fancymenu.v3.rendering.DrawableColor;
import de.keksuccino.fancymenu.v3.rendering.ui.UIBase;
import de.keksuccino.fancymenu.v3.rendering.ui.widget.UniqueWidget;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_8666;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedButton
extends class_4185
implements UniqueWidget {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_8666 SPRITES = new class_8666(new class_2960("widget/button"), new class_2960("widget/button_disabled"), new class_2960("widget/button_highlighted"));
    protected final class_310 mc = class_310.method_1551();
    protected boolean enableLabel = true;
    @NotNull
    protected ButtonBackground background = VanillaButtonBackground.create().setParent(this);
    protected DrawableColor labelBaseColorNormal = DrawableColor.of(new Color(0xFFFFFF));
    protected DrawableColor labelBaseColorInactive = DrawableColor.of(new Color(0xA0A0A0));
    protected boolean labelShadow = true;
    @NotNull
    protected ConsumingSupplier<ExtendedButton, class_2561> labelSupplier = consumes -> class_2561.method_43473();
    protected boolean forceDefaultTooltipStyle = false;
    @Nullable
    protected ConsumingSupplier<ExtendedButton, Boolean> activeSupplier;
    protected boolean focusable = true;
    @Nullable
    protected String identifier;
    protected int lastHoverState = -1;

    public ExtendedButton(int x, int y, int width, int height, @NotNull String label, @NotNull class_4185.class_4241 onPress) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)""), onPress, field_40754);
        this.setLabel((class_2561)class_2561.method_43470((String)label));
    }

    public ExtendedButton(int x, int y, int width, int height, @NotNull String label, @NotNull class_4185.class_4241 onPress, class_4185.class_7841 narration) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)""), onPress, narration);
        this.setLabel((class_2561)class_2561.method_43470((String)label));
    }

    public ExtendedButton(int x, int y, int width, int height, @NotNull class_2561 label, @NotNull class_4185.class_4241 onPress) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)""), onPress, field_40754);
        this.setLabel(label);
    }

    public ExtendedButton(int x, int y, int width, int height, @NotNull class_2561 label, @NotNull class_4185.class_4241 onPress, class_4185.class_7841 narration) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)""), onPress, narration);
        this.setLabel(label);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.updateIsActive();
        this.updateLabel();
        this.handleHover();
        super.method_25394(graphics, mouseX, mouseY, partial);
    }

    public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.background.method_25394(graphics, mouseX, mouseY, partial);
        this.renderLabelText(graphics);
    }

    protected void renderLabelText(class_332 graphics) {
        if (this.enableLabel) {
            int k = this.field_22763 ? this.labelBaseColorNormal.getColorIntWithAlpha(this.field_22765) : this.labelBaseColorInactive.getColorIntWithAlpha(this.field_22765);
            this.renderScrollingLabel(graphics, this.mc.field_1772, 2, k);
        }
    }

    protected void renderScrollingLabel(@NotNull class_332 graphics, @NotNull class_327 font, int spaceLeftRight, int textColor) {
        int xMin = this.method_46426() + spaceLeftRight;
        int xMax = this.method_46426() + this.method_25368() - spaceLeftRight;
        this.renderScrollingLabelInternal(graphics, font, this.method_25369(), xMin, this.method_46427(), xMax, this.method_46427() + this.method_25364(), textColor);
    }

    protected void renderScrollingLabelInternal(@NotNull class_332 graphics, class_327 font, @NotNull class_2561 text, int xMin, int yMin, int xMax, int yMax, int textColor) {
        int textWidth = font.method_27525((class_5348)text);
        int textPosY = (yMin + yMax - 9) / 2 + 1;
        int maxTextWidth = xMax - xMin;
        if (textWidth > maxTextWidth) {
            int diffTextWidth = textWidth - maxTextWidth;
            double scrollTime = (double)class_156.method_658() / 1000.0;
            double $$13 = Math.max((double)diffTextWidth * 0.5, 3.0);
            double $$14 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * scrollTime / $$13)) / 2.0 + 0.5;
            double textPosX = class_3532.method_16436((double)$$14, (double)0.0, (double)diffTextWidth);
            graphics.method_44379(xMin, yMin, xMax, yMax);
            graphics.method_51439(font, text, xMin - (int)textPosX, textPosY, textColor, this.labelShadow);
            graphics.method_44380();
        } else {
            graphics.method_51439(font, text, (int)((float)(xMin + xMax) / 2.0f - (float)font.method_27525((class_5348)text) / 2.0f), textPosY, textColor, this.labelShadow);
        }
    }

    protected void handleHover() {
        if (this.lastHoverState != -1 && this.lastHoverState != this.getHoverState()) {
            if (this.field_22762) {
                this.background.onHover();
            } else {
                this.background.onEndHover();
            }
        }
        this.lastHoverState = this.getHoverState();
    }

    protected void updateLabel() {
        class_2561 c = this.labelSupplier.get(this);
        if (c == null) {
            c = class_2561.method_43470((String)"");
        }
        ((IMixinAbstractWidget)((Object)this)).setMessageFieldFancyMenu(c);
    }

    protected void updateIsActive() {
        Boolean b;
        if (this.activeSupplier != null && (b = this.activeSupplier.get(this)) != null) {
            this.field_22763 = b;
        }
    }

    public void method_53533(int height) {
        this.field_22759 = height;
    }

    protected int getHoverState() {
        if (this.field_22762) {
            return 1;
        }
        return 0;
    }

    protected int getTextureY() {
        int i = 1;
        if (!this.field_22763) {
            i = 0;
        } else if (this.method_25367()) {
            i = 2;
        }
        return 46 + i * 20;
    }

    public boolean isFocusable() {
        return this.focusable;
    }

    public ExtendedButton setFocusable(boolean focusable) {
        this.focusable = focusable;
        return this;
    }

    public boolean isForceDefaultTooltipStyle() {
        return this.forceDefaultTooltipStyle;
    }

    public ExtendedButton setForceDefaultTooltipStyle(boolean forceDefaultTooltipStyle) {
        this.forceDefaultTooltipStyle = forceDefaultTooltipStyle;
        return this;
    }

    @Deprecated
    public void method_25355(@NotNull class_2561 msg) {
        this.setLabel(msg);
    }

    @Deprecated
    @NotNull
    public class_2561 method_25369() {
        return super.method_25369();
    }

    public ExtendedButton setLabel(@NotNull class_2561 label) {
        this.labelSupplier = btn -> label;
        ((IMixinAbstractWidget)((Object)this)).setMessageFieldFancyMenu(label);
        return this;
    }

    public ExtendedButton setLabel(@NotNull String label) {
        this.labelSupplier = btn -> class_2561.method_43470((String)label);
        return this;
    }

    public ExtendedButton setLabelSupplier(@NotNull ConsumingSupplier<ExtendedButton, class_2561> labelSupplier) {
        this.labelSupplier = labelSupplier;
        return this;
    }

    @NotNull
    public ConsumingSupplier<ExtendedButton, class_2561> getLabelSupplier() {
        return this.labelSupplier;
    }

    @NotNull
    public class_2561 getLabel() {
        class_2561 c = this.getLabelSupplier().get(this);
        if (c == null) {
            c = class_2561.method_43473();
        }
        return c;
    }

    public boolean isLabelEnabled() {
        return this.enableLabel;
    }

    public ExtendedButton setLabelEnabled(boolean enabled) {
        this.enableLabel = enabled;
        return this;
    }

    public DrawableColor getLabelBaseColorNormal() {
        return this.labelBaseColorNormal;
    }

    public void setLabelBaseColorNormal(DrawableColor labelBaseColorNormal) {
        this.labelBaseColorNormal = labelBaseColorNormal;
    }

    public DrawableColor getLabelBaseColorInactive() {
        return this.labelBaseColorInactive;
    }

    public void setLabelBaseColorInactive(DrawableColor labelBaseColorInactive) {
        this.labelBaseColorInactive = labelBaseColorInactive;
    }

    public boolean isLabelShadowEnabled() {
        return this.labelShadow;
    }

    public ExtendedButton setLabelShadowEnabled(boolean enabled) {
        this.labelShadow = enabled;
        return this;
    }

    public ExtendedButton setIsActiveSupplier(@Nullable ConsumingSupplier<ExtendedButton, Boolean> isActiveSupplier) {
        this.activeSupplier = isActiveSupplier;
        return this;
    }

    @Nullable
    public ConsumingSupplier<ExtendedButton, Boolean> getIsActiveSupplier() {
        return this.activeSupplier;
    }

    @NotNull
    public ButtonBackground getBackground() {
        return this.background;
    }

    public ExtendedButton setBackground(@NotNull ButtonBackground background) {
        this.background = background;
        this.background.setParent(this);
        return this;
    }

    public class_4185.class_4241 getPressAction() {
        return this.field_22767;
    }

    public ExtendedButton setPressAction(@NotNull class_4185.class_4241 pressAction) {
        ((IMixinButton)((Object)this)).setPressActionFancyMenu(pressAction);
        return this;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean method_25370() {
        if (!this.focusable) {
            return false;
        }
        return super.method_25370();
    }

    public void method_25365(boolean $$0) {
        if (!this.focusable) {
            super.method_25365(false);
            return;
        }
        super.method_25365($$0);
    }

    public ExtendedButton setWidgetIdentifierFancyMenu(@Nullable String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    @Nullable
    public String getWidgetIdentifierFancyMenu() {
        return this.identifier;
    }

    public static class VanillaButtonBackground
    extends ButtonBackground {
        public static VanillaButtonBackground create() {
            return new VanillaButtonBackground();
        }

        @Override
        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            class_310 minecraft = class_310.method_1551();
            graphics.method_51422(1.0f, 1.0f, 1.0f, this.parent.field_22765);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            graphics.method_52706(SPRITES.method_52729(this.parent.field_22763, this.parent.method_25367()), this.parent.method_46426(), this.parent.method_46427(), this.parent.method_25368(), this.parent.method_25364());
            graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }

        @Override
        public void onHover() {
        }

        @Override
        public void onEndHover() {
        }
    }

    public static abstract class ButtonBackground
    implements class_4068 {
        protected ExtendedButton parent;

        public abstract void method_25394(@NotNull class_332 var1, int var2, int var3, float var4);

        public abstract void onHover();

        public abstract void onEndHover();

        public ButtonBackground setParent(ExtendedButton parent) {
            this.parent = parent;
            return this;
        }
    }

    public static class MultiTypeButtonBackground
    extends ButtonBackground {
        @NotNull
        protected ButtonBackground backgroundNormal;
        @Nullable
        protected ButtonBackground backgroundHover;
        @Nullable
        protected ButtonBackground backgroundInactive;

        public static MultiTypeButtonBackground build(@Nullable Object backgroundNormal, @Nullable Object backgroundHover, @Nullable Object backgroundInactive) {
            IAnimationRenderer a;
            class_2960 r;
            MultiTypeButtonBackground b = new MultiTypeButtonBackground(null, null, null);
            if (backgroundNormal == null) {
                b.setBackgroundNormal(VanillaButtonBackground.create());
            } else if (backgroundNormal instanceof class_2960) {
                r = (class_2960)backgroundNormal;
                b.setBackgroundNormal(ImageButtonBackground.create(r, r));
            } else if (backgroundNormal instanceof IAnimationRenderer) {
                a = (IAnimationRenderer)backgroundNormal;
                b.setBackgroundNormal(AnimationButtonBackground.create(a, a));
            } else {
                b.setBackgroundNormal(VanillaButtonBackground.create());
            }
            if (backgroundHover == null) {
                b.setBackgroundHover(VanillaButtonBackground.create());
            } else if (backgroundHover instanceof class_2960) {
                r = (class_2960)backgroundHover;
                b.setBackgroundHover(ImageButtonBackground.create(r, r));
            } else if (backgroundHover instanceof IAnimationRenderer) {
                a = (IAnimationRenderer)backgroundHover;
                b.setBackgroundHover(AnimationButtonBackground.create(a, a));
            } else {
                b.setBackgroundHover(VanillaButtonBackground.create());
            }
            if (backgroundInactive == null) {
                b.setBackgroundInactive(VanillaButtonBackground.create());
            } else if (backgroundInactive instanceof class_2960) {
                r = (class_2960)backgroundInactive;
                b.setBackgroundInactive(ImageButtonBackground.create(r, r));
            } else if (backgroundInactive instanceof IAnimationRenderer) {
                a = (IAnimationRenderer)backgroundInactive;
                b.setBackgroundInactive(AnimationButtonBackground.create(a, a));
            } else {
                b.setBackgroundInactive(VanillaButtonBackground.create());
            }
            return b;
        }

        public static MultiTypeButtonBackground create(@NotNull ButtonBackground backgroundNormal) {
            return new MultiTypeButtonBackground(backgroundNormal, null, null);
        }

        public static MultiTypeButtonBackground create(@NotNull ButtonBackground backgroundNormal, @Nullable ButtonBackground backgroundHover) {
            return new MultiTypeButtonBackground(backgroundNormal, backgroundHover, null);
        }

        public static MultiTypeButtonBackground create(@NotNull ButtonBackground backgroundNormal, @Nullable ButtonBackground backgroundHover, @Nullable ButtonBackground backgroundInactive) {
            return new MultiTypeButtonBackground(backgroundNormal, backgroundHover, backgroundInactive);
        }

        public MultiTypeButtonBackground(@NotNull ButtonBackground backgroundNormal, @Nullable ButtonBackground backgroundHover, @Nullable ButtonBackground backgroundInactive) {
            this.backgroundNormal = backgroundNormal;
            this.backgroundHover = backgroundHover;
            this.backgroundInactive = backgroundInactive;
        }

        @Override
        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            this.getBackground().setParent(this.parent).method_25394(graphics, mouseX, mouseY, partial);
        }

        @Override
        public void onHover() {
            this.backgroundNormal.onHover();
            if (this.backgroundHover != null) {
                this.backgroundHover.onHover();
            }
        }

        @Override
        public void onEndHover() {
            this.backgroundNormal.onEndHover();
            if (this.backgroundHover != null) {
                this.backgroundHover.onEndHover();
            }
        }

        @NotNull
        protected ButtonBackground getBackground() {
            if (!this.parent.field_22763 && this.backgroundInactive != null) {
                return this.backgroundInactive;
            }
            if (this.parent.field_22762 && this.parent.method_37303() && this.backgroundHover != null) {
                return this.backgroundHover;
            }
            return this.backgroundNormal;
        }

        @Nullable
        public ButtonBackground getBackgroundInactive() {
            return this.backgroundInactive;
        }

        public MultiTypeButtonBackground setBackgroundInactive(@Nullable ButtonBackground backgroundInactive) {
            this.backgroundInactive = backgroundInactive;
            return this;
        }

        @NotNull
        public ButtonBackground getBackgroundNormal() {
            return this.backgroundNormal;
        }

        public MultiTypeButtonBackground setBackgroundNormal(@NotNull ButtonBackground backgroundNormal) {
            this.backgroundNormal = backgroundNormal;
            return this;
        }

        @Nullable
        public ButtonBackground getBackgroundHover() {
            return this.backgroundHover;
        }

        public MultiTypeButtonBackground setBackgroundHover(@Nullable ButtonBackground backgroundHover) {
            this.backgroundHover = backgroundHover;
            return this;
        }
    }

    public static class AnimationButtonBackground
    extends ButtonBackground {
        @NotNull
        protected IAnimationRenderer backgroundAnimationNormal;
        @Nullable
        protected IAnimationRenderer backgroundAnimationHover;
        @Nullable
        protected IAnimationRenderer backgroundAnimationInactive;
        protected boolean loop = true;
        protected boolean restartOnHover = true;

        public static AnimationButtonBackground create(@NotNull IAnimationRenderer backgroundAnimationNormal) {
            return new AnimationButtonBackground(backgroundAnimationNormal, null, null);
        }

        public static AnimationButtonBackground create(@NotNull IAnimationRenderer backgroundAnimationNormal, @Nullable IAnimationRenderer backgroundAnimationHover) {
            return new AnimationButtonBackground(backgroundAnimationNormal, backgroundAnimationHover, null);
        }

        public static AnimationButtonBackground create(@NotNull IAnimationRenderer backgroundAnimationNormal, @Nullable IAnimationRenderer backgroundAnimationHover, @Nullable IAnimationRenderer backgroundAnimationInactive) {
            return new AnimationButtonBackground(backgroundAnimationNormal, backgroundAnimationHover, backgroundAnimationInactive);
        }

        public AnimationButtonBackground(@NotNull IAnimationRenderer backgroundAnimationNormal, @Nullable IAnimationRenderer backgroundAnimationHover, @Nullable IAnimationRenderer backgroundAnimationInactive) {
            this.backgroundAnimationNormal = backgroundAnimationNormal;
            this.backgroundAnimationHover = backgroundAnimationHover;
            this.backgroundAnimationInactive = backgroundAnimationInactive;
        }

        @Override
        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.parent.field_22765);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            this.renderBackgroundAnimation(graphics);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onHover() {
            AdvancedAnimation aa;
            IAnimationRenderer iAnimationRenderer;
            if (this.restartOnHover) {
                this.backgroundAnimationNormal.resetAnimation();
                iAnimationRenderer = this.backgroundAnimationNormal;
                if (iAnimationRenderer instanceof AdvancedAnimation) {
                    aa = (AdvancedAnimation)iAnimationRenderer;
                    aa.stopAudio();
                    aa.resetAudio();
                }
                if (this.backgroundAnimationHover != null) {
                    this.backgroundAnimationHover.resetAnimation();
                    iAnimationRenderer = this.backgroundAnimationHover;
                    if (iAnimationRenderer instanceof AdvancedAnimation) {
                        aa = (AdvancedAnimation)iAnimationRenderer;
                        aa.stopAudio();
                        aa.resetAudio();
                    }
                }
            }
            if ((iAnimationRenderer = this.backgroundAnimationNormal) instanceof AdvancedAnimation) {
                aa = (AdvancedAnimation)iAnimationRenderer;
                aa.stopAudio();
                aa.resetAudio();
            }
        }

        @Override
        public void onEndHover() {
            IAnimationRenderer iAnimationRenderer = this.backgroundAnimationHover;
            if (iAnimationRenderer instanceof AdvancedAnimation) {
                AdvancedAnimation aa = (AdvancedAnimation)iAnimationRenderer;
                aa.stopAudio();
                aa.resetAudio();
            }
        }

        protected void renderBackgroundAnimation(class_332 graphics) {
            IAnimationRenderer a = this.getBackgroundAnimation();
            int cachedW = a.getWidth();
            int cachedH = a.getHeight();
            int cachedX = a.getPosX();
            int cachedY = a.getPosY();
            boolean cachedLoop = a.isGettingLooped();
            a.setWidth(this.parent.method_25368());
            a.setHeight(this.parent.method_25364());
            a.setPosX(this.parent.method_46426());
            a.setPosY(this.parent.method_46427());
            a.setLooped(this.loop);
            a.setOpacity(this.parent.field_22765);
            a.render(graphics);
            a.setWidth(cachedW);
            a.setHeight(cachedH);
            a.setPosX(cachedX);
            a.setPosY(cachedY);
            a.setLooped(cachedLoop);
            a.setOpacity(1.0f);
        }

        @NotNull
        protected IAnimationRenderer getBackgroundAnimation() {
            if (!this.parent.field_22763 && this.backgroundAnimationInactive != null) {
                return this.backgroundAnimationInactive;
            }
            if (this.parent.field_22762 && this.parent.method_37303() && this.backgroundAnimationHover != null) {
                return this.backgroundAnimationHover;
            }
            return this.backgroundAnimationNormal;
        }

        @Nullable
        public IAnimationRenderer getBackgroundAnimationInactive() {
            return this.backgroundAnimationInactive;
        }

        public AnimationButtonBackground setBackgroundAnimationInactive(@Nullable IAnimationRenderer backgroundAnimationInactive) {
            this.backgroundAnimationInactive = backgroundAnimationInactive;
            return this;
        }

        @NotNull
        public IAnimationRenderer getBackgroundAnimationNormal() {
            return this.backgroundAnimationNormal;
        }

        public AnimationButtonBackground setBackgroundAnimationNormal(@NotNull IAnimationRenderer backgroundAnimationNormal) {
            this.backgroundAnimationNormal = backgroundAnimationNormal;
            return this;
        }

        @Nullable
        public IAnimationRenderer getBackgroundAnimationHover() {
            return this.backgroundAnimationHover;
        }

        public AnimationButtonBackground setBackgroundAnimationHover(@Nullable IAnimationRenderer backgroundAnimationHover) {
            this.backgroundAnimationHover = backgroundAnimationHover;
            return this;
        }

        public boolean isLooped() {
            return this.loop;
        }

        public AnimationButtonBackground setLooped(boolean loop) {
            this.loop = loop;
            return this;
        }

        public boolean isRestartOnHover() {
            return this.restartOnHover;
        }

        public AnimationButtonBackground setRestartOnHover(boolean restartOnHover) {
            this.restartOnHover = restartOnHover;
            return this;
        }
    }

    public static class ImageButtonBackground
    extends ButtonBackground {
        @NotNull
        protected class_2960 backgroundTextureNormal;
        @Nullable
        protected class_2960 backgroundTextureHover;
        @Nullable
        protected class_2960 backgroundTextureInactive;

        public static ImageButtonBackground create(@NotNull class_2960 backgroundTextureNormal) {
            return new ImageButtonBackground(backgroundTextureNormal, null, null);
        }

        public static ImageButtonBackground create(@NotNull class_2960 backgroundTextureNormal, @Nullable class_2960 backgroundTextureHover) {
            return new ImageButtonBackground(backgroundTextureNormal, backgroundTextureHover, null);
        }

        public static ImageButtonBackground create(@NotNull class_2960 backgroundTextureNormal, @Nullable class_2960 backgroundTextureHover, @Nullable class_2960 backgroundTextureInactive) {
            return new ImageButtonBackground(backgroundTextureNormal, backgroundTextureHover, backgroundTextureInactive);
        }

        public ImageButtonBackground(@NotNull class_2960 backgroundTextureNormal, @Nullable class_2960 backgroundTextureHover, @Nullable class_2960 backgroundTextureInactive) {
            this.backgroundTextureNormal = backgroundTextureNormal;
            this.backgroundTextureHover = backgroundTextureHover;
            this.backgroundTextureInactive = backgroundTextureInactive;
        }

        @Override
        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.parent.field_22765);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            graphics.method_25290(this.getBackgroundTexture(), this.parent.method_46426(), this.parent.method_46427(), 0.0f, 0.0f, this.parent.method_25368(), this.parent.method_25364(), this.parent.method_25368(), this.parent.method_25364());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onHover() {
        }

        @Override
        public void onEndHover() {
        }

        @NotNull
        protected class_2960 getBackgroundTexture() {
            if (!this.parent.field_22763 && this.backgroundTextureInactive != null) {
                return this.backgroundTextureInactive;
            }
            if (this.parent.field_22762 && this.parent.method_37303() && this.backgroundTextureHover != null) {
                return this.backgroundTextureHover;
            }
            return this.backgroundTextureNormal;
        }

        @Nullable
        public class_2960 getBackgroundTextureInactive() {
            return this.backgroundTextureInactive;
        }

        public ImageButtonBackground setBackgroundTextureInactive(@Nullable class_2960 backgroundTextureInactive) {
            this.backgroundTextureInactive = backgroundTextureInactive;
            return this;
        }

        @NotNull
        public class_2960 getBackgroundTextureNormal() {
            return this.backgroundTextureNormal;
        }

        public ImageButtonBackground setBackgroundTextureNormal(@NotNull class_2960 backgroundTextureNormal) {
            this.backgroundTextureNormal = backgroundTextureNormal;
            return this;
        }

        @Nullable
        public class_2960 getBackgroundTextureHover() {
            return this.backgroundTextureHover;
        }

        public ImageButtonBackground setBackgroundTextureHover(@Nullable class_2960 backgroundTextureHover) {
            this.backgroundTextureHover = backgroundTextureHover;
            return this;
        }
    }

    public static class ColorButtonBackground
    extends ButtonBackground {
        @NotNull
        protected DrawableColor backgroundColorNormal;
        @Nullable
        protected DrawableColor backgroundColorHover;
        @Nullable
        protected DrawableColor backgroundColorInactive;
        @Nullable
        protected DrawableColor backgroundColorBorderNormal;
        @Nullable
        protected DrawableColor backgroundColorBorderHover;
        @Nullable
        protected DrawableColor backgroundColorBorderInactive;
        protected int borderThickness;

        public static ColorButtonBackground create(@NotNull DrawableColor backgroundColorNormal) {
            return new ColorButtonBackground(backgroundColorNormal, null, null, null, null, null, 1);
        }

        public static ColorButtonBackground create(@NotNull DrawableColor backgroundColorNormal, @Nullable DrawableColor backgroundColorHover, @Nullable DrawableColor backgroundColorBorderNormal, @Nullable DrawableColor backgroundColorBorderHover) {
            return new ColorButtonBackground(backgroundColorNormal, backgroundColorHover, null, backgroundColorBorderNormal, backgroundColorBorderHover, null, 1);
        }

        public static ColorButtonBackground create(@NotNull DrawableColor backgroundColorNormal, @Nullable DrawableColor backgroundColorHover, @Nullable DrawableColor backgroundColorBorderNormal, @Nullable DrawableColor backgroundColorBorderHover, int borderThickness) {
            return new ColorButtonBackground(backgroundColorNormal, backgroundColorHover, null, backgroundColorBorderNormal, backgroundColorBorderHover, null, borderThickness);
        }

        public static ColorButtonBackground create(@NotNull DrawableColor backgroundColorNormal, @Nullable DrawableColor backgroundColorHover, @Nullable DrawableColor backgroundColorInactive, @Nullable DrawableColor backgroundColorBorderNormal, @Nullable DrawableColor backgroundColorBorderHover, @Nullable DrawableColor backgroundColorBorderInactive) {
            return new ColorButtonBackground(backgroundColorNormal, backgroundColorHover, backgroundColorInactive, backgroundColorBorderNormal, backgroundColorBorderHover, backgroundColorBorderInactive, 1);
        }

        public static ColorButtonBackground create(@NotNull DrawableColor backgroundColorNormal, @Nullable DrawableColor backgroundColorHover, @Nullable DrawableColor backgroundColorInactive, @Nullable DrawableColor backgroundColorBorderNormal, @Nullable DrawableColor backgroundColorBorderHover, @Nullable DrawableColor backgroundColorBorderInactive, int borderThickness) {
            return new ColorButtonBackground(backgroundColorNormal, backgroundColorHover, backgroundColorInactive, backgroundColorBorderNormal, backgroundColorBorderHover, backgroundColorBorderInactive, borderThickness);
        }

        public ColorButtonBackground(@NotNull DrawableColor backgroundColorNormal, @Nullable DrawableColor backgroundColorHover, @Nullable DrawableColor backgroundColorInactive, @Nullable DrawableColor backgroundColorBorderNormal, @Nullable DrawableColor backgroundColorBorderHover, @Nullable DrawableColor backgroundColorBorderInactive, int borderThickness) {
            this.backgroundColorNormal = backgroundColorNormal;
            this.backgroundColorHover = backgroundColorHover;
            this.backgroundColorInactive = backgroundColorInactive;
            this.backgroundColorBorderNormal = backgroundColorBorderNormal;
            this.backgroundColorBorderHover = backgroundColorBorderHover;
            this.backgroundColorBorderInactive = backgroundColorBorderInactive;
            this.borderThickness = borderThickness;
        }

        @Override
        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.parent.field_22765);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            this.renderColorBackground(graphics);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onHover() {
        }

        @Override
        public void onEndHover() {
        }

        protected void renderColorBackground(class_332 graphics) {
            int w = this.parent.method_25368() - this.borderThickness * 2;
            int h = this.parent.method_25364() - this.borderThickness * 2;
            graphics.method_25294(this.parent.method_46426() + this.borderThickness, this.parent.method_46427() + this.borderThickness, this.parent.method_46426() + this.borderThickness + w, this.parent.method_46427() + this.borderThickness + h, this.getBackgroundColor().getColorIntWithAlpha(this.parent.field_22765));
            UIBase.renderBorder(graphics.method_51448(), this.parent.method_46426(), this.parent.method_46427(), this.parent.method_46426() + this.parent.method_25368(), this.parent.method_46427() + this.parent.method_25364(), this.borderThickness, this.getBorderColor().getColor(), true, true, true, true);
        }

        @NotNull
        protected DrawableColor getBorderColor() {
            if (!this.parent.field_22763 && this.backgroundColorBorderInactive != null) {
                return this.backgroundColorBorderInactive;
            }
            if (this.parent.field_22762 && this.parent.method_37303()) {
                if (this.backgroundColorBorderHover != null) {
                    return this.backgroundColorBorderHover;
                }
                if (this.backgroundColorBorderNormal != null) {
                    return this.backgroundColorBorderNormal;
                }
                return this.getBackgroundColor();
            }
            if (this.backgroundColorBorderNormal != null) {
                return this.backgroundColorBorderNormal;
            }
            return this.getBackgroundColor();
        }

        @NotNull
        protected DrawableColor getBackgroundColor() {
            if (!this.parent.field_22763 && this.backgroundColorInactive != null) {
                return this.backgroundColorInactive;
            }
            if (this.parent.field_22762 && this.parent.method_37303() && this.backgroundColorHover != null) {
                return this.backgroundColorHover;
            }
            return this.backgroundColorNormal;
        }

        @NotNull
        public DrawableColor getBackgroundColorNormal() {
            return this.backgroundColorNormal;
        }

        public ColorButtonBackground setBackgroundColorNormal(@NotNull DrawableColor backgroundColorNormal) {
            Objects.requireNonNull(backgroundColorNormal);
            this.backgroundColorNormal = backgroundColorNormal;
            return this;
        }

        @Nullable
        public DrawableColor getBackgroundColorInactive() {
            return this.backgroundColorInactive;
        }

        public ColorButtonBackground setBackgroundColorInactive(@Nullable DrawableColor backgroundColorInactive) {
            this.backgroundColorInactive = backgroundColorInactive;
            return this;
        }

        @Nullable
        public DrawableColor getBackgroundColorBorderInactive() {
            return this.backgroundColorBorderInactive;
        }

        public ColorButtonBackground setBackgroundColorBorderInactive(@Nullable DrawableColor backgroundColorBorderInactive) {
            this.backgroundColorBorderInactive = backgroundColorBorderInactive;
            return this;
        }

        @Nullable
        public DrawableColor getBackgroundColorHover() {
            return this.backgroundColorHover;
        }

        public ColorButtonBackground setBackgroundColorHover(@Nullable DrawableColor backgroundColorHover) {
            this.backgroundColorHover = backgroundColorHover;
            return this;
        }

        @Nullable
        public DrawableColor getBackgroundColorBorderNormal() {
            return this.backgroundColorBorderNormal;
        }

        public ColorButtonBackground setBackgroundColorBorderNormal(@Nullable DrawableColor backgroundColorBorderNormal) {
            this.backgroundColorBorderNormal = backgroundColorBorderNormal;
            return this;
        }

        @Nullable
        public DrawableColor getBackgroundColorBorderHover() {
            return this.backgroundColorBorderHover;
        }

        public ColorButtonBackground setBackgroundColorBorderHover(@Nullable DrawableColor backgroundColorBorderHover) {
            this.backgroundColorBorderHover = backgroundColorBorderHover;
            return this;
        }

        public int getBorderThickness() {
            return this.borderThickness;
        }

        public ColorButtonBackground setBorderThickness(int borderThickness) {
            this.borderThickness = borderThickness;
            return this;
        }
    }
}

