/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.manager;

import dev.tr7zw.itemswapper.api.AvailableSlot;
import dev.tr7zw.itemswapper.api.client.ContainerProvider;
import dev.tr7zw.itemswapper.api.client.ItemProvider;
import dev.tr7zw.itemswapper.api.client.NameProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_310;

public class ClientProviderManager {
    private final class_310 minecraft = class_310.method_1551();
    private Set<ItemProvider> earlyItemProvider = new HashSet<ItemProvider>();
    private Set<ItemProvider> lateItemProvider = new HashSet<ItemProvider>();
    private Map<class_1792, ContainerProvider> containerProvider = new HashMap<class_1792, ContainerProvider>();
    private Map<class_1792, NameProvider> nameProvider = new HashMap<class_1792, NameProvider>();

    public void registerEarlyItemProvider(ItemProvider provider) {
        this.earlyItemProvider.add(provider);
    }

    public void registerLateItemProvider(ItemProvider provider) {
        this.lateItemProvider.add(provider);
    }

    public void registerContainerProvider(ContainerProvider provider) {
        for (class_1792 item : provider.getItemHandlers()) {
            this.containerProvider.put(item, provider);
        }
    }

    public void registerNameProvider(NameProvider provider) {
        for (class_1792 item : provider.getItemHandlers()) {
            this.nameProvider.put(item, provider);
        }
    }

    public Set<ItemProvider> getEarlyItemProvider() {
        return this.earlyItemProvider;
    }

    public Set<ItemProvider> getLateItemProvider() {
        return this.lateItemProvider;
    }

    public ContainerProvider getContainerProvider(class_1792 item) {
        return this.containerProvider.get(item);
    }

    public NameProvider getNameProvider(class_1792 item) {
        return this.nameProvider.get(item);
    }

    public List<AvailableSlot> findSlotsMatchingItem(class_1792 item, boolean limit, boolean ignoreHotbar) {
        int i;
        class_2371 items = this.minecraft.field_1724.method_31548().field_7547;
        ArrayList<AvailableSlot> ids = new ArrayList<AvailableSlot>();
        this.handleProvider(this.getEarlyItemProvider(), item, limit, ids);
        if (limit && !ids.isEmpty()) {
            return ids;
        }
        int n = i = ignoreHotbar ? 9 : 0;
        while (i < items.size()) {
            class_1799 itemStack = (class_1799)items.get(i);
            if (!itemStack.method_7960() || item == class_1802.field_8162) {
                if (itemStack.method_7909() == item) {
                    this.addUnstackableItems(ids, new AvailableSlot(-1, i, (class_1799)items.get(i)));
                    if (limit) {
                        return ids;
                    }
                } else {
                    ContainerProvider provider = this.getContainerProvider(itemStack.method_7909());
                    if (provider != null) {
                        this.handleSlotlist(ids, limit, provider.processItemStack(itemStack, item, limit, i));
                        if (limit && !ids.isEmpty()) {
                            return ids;
                        }
                    }
                }
            }
            ++i;
        }
        this.handleProvider(this.getLateItemProvider(), item, limit, ids);
        return ids;
    }

    private void handleProvider(Set<ItemProvider> providers, class_1792 item, boolean limit, List<AvailableSlot> ids) {
        for (ItemProvider provider : providers) {
            List<AvailableSlot> found = provider.findSlotsMatchingItem(item, limit);
            this.handleSlotlist(ids, limit, found);
        }
    }

    private void handleSlotlist(List<AvailableSlot> ids, boolean limit, List<AvailableSlot> found) {
        for (AvailableSlot slot : found) {
            this.addUnstackableItems(ids, slot);
            if (!limit) continue;
            return;
        }
    }

    private void addUnstackableItems(List<AvailableSlot> ids, AvailableSlot slot) {
        for (AvailableSlot s : ids) {
            if (!class_1799.method_31577((class_1799)s.item(), (class_1799)slot.item())) continue;
            s.amount().accumulateAndGet(slot.item().method_7947(), (i1, i2) -> i1 + i2);
            return;
        }
        ids.add(slot);
    }
}

