/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.itemswapper.ItemSwapperSharedMod;
import dev.tr7zw.itemswapper.api.client.ContainerProvider;
import dev.tr7zw.itemswapper.api.client.ItemSwapperClientAPI;
import dev.tr7zw.itemswapper.config.ConfigManager;
import dev.tr7zw.itemswapper.manager.ClientProviderManager;
import dev.tr7zw.itemswapper.manager.ItemGroupManager;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemGroup;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemList;
import dev.tr7zw.itemswapper.manager.itemgroups.Shortcut;
import dev.tr7zw.itemswapper.manager.shortcuts.BackShortcut;
import dev.tr7zw.itemswapper.manager.shortcuts.ClearCurrentSlotShortcut;
import dev.tr7zw.itemswapper.manager.shortcuts.LastItemShortcut;
import dev.tr7zw.itemswapper.manager.shortcuts.LinkShortcut;
import dev.tr7zw.itemswapper.manager.shortcuts.OpenInventoryShortcut;
import dev.tr7zw.itemswapper.manager.shortcuts.RestockShortcut;
import dev.tr7zw.itemswapper.overlay.ItemSwapperUIAbstractInput;
import dev.tr7zw.itemswapper.overlay.logic.ContainerWidget;
import dev.tr7zw.itemswapper.overlay.logic.GuiSelectionHandler;
import dev.tr7zw.itemswapper.overlay.logic.GuiWidget;
import dev.tr7zw.itemswapper.overlay.logic.InventoryWidget;
import dev.tr7zw.itemswapper.overlay.logic.ListContentWidget;
import dev.tr7zw.itemswapper.overlay.logic.PaletteWidget;
import dev.tr7zw.itemswapper.overlay.logic.ShortcutListWidget;
import dev.tr7zw.itemswapper.support.ViveCraftSupport;
import dev.tr7zw.itemswapper.util.ComponentProvider;
import dev.tr7zw.itemswapper.util.WidgetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_757;

public class SwitchItemOverlay
extends ItemSwapperUIAbstractInput {
    public final class_310 minecraft = class_310.method_1551();
    public final ClientProviderManager providerManager = ItemSwapperSharedMod.instance.getClientProviderManager();
    public final ItemSwapperClientAPI clientAPI = ItemSwapperClientAPI.getInstance();
    private final GuiSelectionHandler selectionHandler = new GuiSelectionHandler();
    public int globalXOffset = 0;
    public int globalYOffset = 0;
    public boolean forceAvailable = false;
    public boolean hideCursor = false;
    public boolean hideShortcuts = false;
    private List<Shortcut> shortcutList = Collections.emptyList();
    private List<ItemGroupManager.Page> lastPages = new ArrayList<ItemGroupManager.Page>();
    public boolean hideClearSlotShortcut = false;
    private final ConfigManager configManager = ConfigManager.getInstance();

    private SwitchItemOverlay() {
        super((class_2561)ComponentProvider.empty());
        if (this.minecraft.field_1724.method_7337() && this.configManager.getConfig().creativeCheatMode) {
            this.forceAvailable = true;
        }
    }

    private void initShortcuts() {
        this.shortcutList = new ArrayList<Shortcut>();
        if (this.hideShortcuts) {
            return;
        }
        if (!this.hideClearSlotShortcut) {
            this.shortcutList.add(new ClearCurrentSlotShortcut());
        }
        this.shortcutList.add(new LastItemShortcut(ItemSwapperSharedMod.instance.getLastItem(), ItemSwapperSharedMod.instance.getLastPage()));
        if (ItemSwapperSharedMod.instance.isEnableRefill()) {
            this.shortcutList.add(new RestockShortcut());
        }
        this.shortcutList.add(new OpenInventoryShortcut(this));
        this.shortcutList.add(new BackShortcut(this));
        this.shortcutList.add(new LinkShortcut(new class_2960("itemswapper", "v2/main"), (class_2561)ComponentProvider.translatable("text.itemswapper.overview"), null));
    }

    public static SwitchItemOverlay createPageOverlay(ItemGroupManager.Page page) {
        SwitchItemOverlay overlay = new SwitchItemOverlay();
        overlay.openPage(page);
        return overlay;
    }

    public static SwitchItemOverlay createPaletteOverlay(ItemGroup itemGroup) {
        SwitchItemOverlay overlay = new SwitchItemOverlay();
        overlay.openItemGroup(itemGroup);
        return overlay;
    }

    public static SwitchItemOverlay createInventoryOverlay() {
        SwitchItemOverlay overlay = new SwitchItemOverlay();
        overlay.openInventory();
        return overlay;
    }

    public void openItemGroup(ItemGroup itemGroup) {
        this.selectionHandler.reset();
        this.lastPages.add(new ItemGroupManager.ItemGroupPage(itemGroup));
        this.initShortcuts();
        PaletteWidget mainWidget = new PaletteWidget(itemGroup, 0, 0);
        this.selectionHandler.addWidget(mainWidget);
        this.selectionHandler.addWidget(new ShortcutListWidget(itemGroup.getId(), this.shortcutList, mainWidget.getWidgetArea().getMouseBoundsX() + 22, 1));
        this.selectionHandler.addWidget(new ShortcutListWidget(itemGroup.getId(), itemGroup.getShortcuts(), -mainWidget.getWidgetArea().getMouseBoundsX() - 22, 1));
    }

    public void openItemList(ItemList items) {
        this.selectionHandler.reset();
        this.lastPages.add(new ItemGroupManager.ListPage(items));
        this.initShortcuts();
        ListContentWidget mainWidget = new ListContentWidget(items, 0, 0);
        this.selectionHandler.addWidget(mainWidget);
        this.selectionHandler.addWidget(new ShortcutListWidget(items.getId(), this.shortcutList, mainWidget.getWidgetArea().getMouseBoundsX() + 22, 1));
    }

    public boolean openPage(ItemGroupManager.Page page) {
        if (page instanceof ItemGroupManager.NoPage || !this.lastPages.isEmpty() && page.equals(this.lastPages.get(this.lastPages.size() - 1))) {
            return false;
        }
        if (page instanceof ItemGroupManager.ItemGroupPage) {
            ItemGroupManager.ItemGroupPage group = (ItemGroupManager.ItemGroupPage)page;
            this.openItemGroup(group.group());
        } else if (page instanceof ItemGroupManager.ListPage) {
            ItemGroupManager.ListPage list = (ItemGroupManager.ListPage)page;
            this.openItemList(list.items());
        } else if (page instanceof ItemGroupManager.InventoryPage) {
            this.openInventory();
        } else if (page instanceof ItemGroupManager.ContainerPage) {
            ItemGroupManager.ContainerPage container = (ItemGroupManager.ContainerPage)page;
            this.openContainer(container.containerSlotId());
        }
        return true;
    }

    public boolean selectIcon(String selector, int xOffset, int yOffset) {
        return this.selectionHandler.select(selector, xOffset, yOffset);
    }

    public List<ItemGroupManager.Page> getPageHistory() {
        return this.lastPages;
    }

    public void openInventory() {
        this.selectionHandler.reset();
        this.lastPages.add(new ItemGroupManager.InventoryPage());
        this.initShortcuts();
        InventoryWidget mainWidget = new InventoryWidget(0, 0);
        this.selectionHandler.addWidget(mainWidget);
        this.selectionHandler.addWidget(new ShortcutListWidget(null, this.shortcutList, mainWidget.getWidgetArea().getMouseBoundsX() + 22, 0));
    }

    public void openContainer(int slotId) {
        class_1799 item = (class_1799)this.minecraft.field_1724.method_31548().field_7547.get(slotId);
        ContainerProvider provider = this.providerManager.getContainerProvider(item.method_7909());
        if (provider == null) {
            this.lastPages.clear();
            this.openInventory();
            return;
        }
        this.selectionHandler.reset();
        this.lastPages.add(new ItemGroupManager.ContainerPage(slotId));
        this.initShortcuts();
        ContainerWidget mainWidget = new ContainerWidget(0, 0, slotId);
        this.selectionHandler.addWidget(mainWidget);
        this.selectionHandler.addWidget(new ShortcutListWidget(null, this.shortcutList, mainWidget.getWidgetArea().getMouseBoundsX() + 22, 0));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float f) {
        int originX = this.minecraft.method_22683().method_4486() / 2 + this.globalXOffset;
        int originY = this.minecraft.method_22683().method_4502() / 2 + this.globalYOffset;
        this.selectionHandler.updateMousePosition(mouseX - originX, mouseY - originY);
        for (GuiWidget widget : this.selectionHandler.getWidgets()) {
            widget.render(this, graphics, originX, originY, this.forceAvailable);
        }
        if (this.selectionHandler.getSelectedSlot() != null) {
            this.selectionHandler.getSelectedWidget().renderSelectedSlotName(this.selectionHandler.getSelectedSlot(), this.selectionHandler.getWidgets().get(0).titleYOffset(), this.selectionHandler.getWidgets().get(0).getWidgetArea().getBackgroundTextureSizeX() - 40, this.forceAvailable);
            if (this.configManager.getConfig().showTooltips) {
                this.selectionHandler.getSelectedWidget().renderSelectedTooltip(this, graphics, this.selectionHandler.getSelectedSlot(), this.selectionHandler.getCursorX() + (double)originX, this.selectionHandler.getCursorY() + (double)originY);
            }
        }
        if (this.configManager.getConfig().showCursor && !this.hideCursor && !ViveCraftSupport.getInstance().isActive()) {
            RenderSystem.setShader(class_757::method_34542);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 1000.0f);
            graphics.method_25290(WidgetUtil.CURSOR_LOCATION, originX + (int)this.selectionHandler.getCursorX() - 12, originY + (int)this.selectionHandler.getCursorY() - 12, 0.0f, 0.0f, 24, 24, 24, 24);
            graphics.method_51448().method_22909();
        }
    }

    public boolean forceItemsAvailable() {
        return this.forceAvailable;
    }

    @Override
    public void handleInput(double x, double y) {
        this.selectionHandler.updateSelection(x, y);
    }

    @Override
    public void onSecondaryClick() {
        if (this.selectionHandler.getSelectedSlot() != null) {
            this.selectionHandler.getSelectedWidget().onSecondaryClick(this, this.selectionHandler.getSelectedSlot(), (int)this.selectionHandler.getOffsetX(), (int)this.selectionHandler.getOffsetY());
        }
    }

    @Override
    public boolean onPrimaryClick() {
        if (this.selectionHandler.getSelectedSlot() != null) {
            return this.selectionHandler.getSelectedWidget().onPrimaryClick(this, this.selectionHandler.getSelectedSlot(), (int)this.selectionHandler.getOffsetX(), (int)this.selectionHandler.getOffsetY());
        }
        return true;
    }
}

