/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.config;

import com.koteinik.chunksfadein.Logger;
import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.config.ConfigEntry;
import com.koteinik.chunksfadein.config.ConfigEntryDoubleLimitable;
import com.koteinik.chunksfadein.core.Curves;
import com.koteinik.chunksfadein.core.FadeTypes;
import com.moandjiezana.toml.Toml;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static final Long CONFIG_VERSION = 1L;
    public static final double MAX_FADE_TIME = 10.0;
    public static final double MAX_ANIMATION_TIME = 10.0;
    public static final double MAX_ANIMATION_OFFSET = 319.0;
    public static final String CONFIG_VERSION_KEY = "config-version";
    public static final String MOD_ENABLED_KEY = "mod-enabled";
    public static final String SHOW_MOD_BUTTON_IN_SETTINGS_KEY = "show-mod-button-in-settings";
    public static final String UPDATE_NOTIFIER_ENABLED_KEY = "update-notifier-enabled";
    public static final String FADE_ENABLED_KEY = "fade-enabled";
    public static final String FADE_TIME_KEY = "fade-time";
    public static final String FADE_TYPE_KEY = "fade-type";
    public static final String ANIMATION_ENABLED_KEY = "animation-enabled";
    public static final String ANIMATE_NEAR_PLAYER_KEY = "animate-near-player";
    public static final String ANIMATION_TIME_KEY = "animation-time";
    public static final String ANIMATION_CURVE_KEY = "animation-curve";
    public static final String ANIMATION_OFFSET_KEY = "animation-offset";
    private static final Map<String, ConfigEntry<?>> entries = new HashMap();
    private static File configFile;
    public static boolean isModEnabled;
    public static boolean isFadeEnabled;
    public static boolean isAnimationEnabled;
    public static boolean isUpdateNotifierEnabled;
    public static boolean showModButtonInSettings;
    public static boolean animateNearPlayer;
    public static float animationInitialOffset;
    public static float animationChangePerNano;
    public static float fadeChangePerNano;
    public static FadeTypes fadeType;
    public static Curves animationCurve;

    public static float fadeChangeFromSeconds(double seconds) {
        float secondsInMs = (float)(seconds * 1.0E9);
        return 1.0f / secondsInMs;
    }

    public static float secondsFromFadeChange() {
        return 1.0f / fadeChangePerNano / 1.0E9f;
    }

    public static float animationChangeFromSeconds(double seconds) {
        float secondsInMs = (float)(seconds * 1.0E9);
        return 1.0f / secondsInMs;
    }

    public static double secondsFromAnimationChange() {
        return (double)(1.0f / animationChangePerNano) / 1.0E9;
    }

    public static void load() {
        configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "chunksfadein.properties");
        Toml toml = new Toml();
        try {
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            toml.read(configFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ConfigEntry<?> entry : entries.values()) {
            entry.load(toml);
        }
        Long configVersion = toml.getLong(CONFIG_VERSION_KEY);
        if (configVersion != null && configVersion != CONFIG_VERSION) {
            Config.setDouble(FADE_TIME_KEY, (Double)Config.get((String)FADE_TIME_KEY).value * 4.0);
            Config.setDouble(ANIMATION_TIME_KEY, (Double)Config.get((String)ANIMATION_TIME_KEY).value * 4.0);
        }
    }

    public static void save() {
        Object string = "";
        string = (String)string + "config-version = " + CONFIG_VERSION + "\n";
        for (ConfigEntry<?> entry : entries.values()) {
            string = (String)string + entry.toString();
        }
        try {
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(configFile));
            writer.write((String)string);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.error("Failed to save config! If this is an error, please create an issue on github!");
        }
    }

    public static void setInteger(String key, Integer value) {
        Config.get(key).set(value);
    }

    public static void setBoolean(String key, Boolean value) {
        Config.get(key).set(value);
    }

    public static void setDouble(String key, Double value) {
        Config.get(key).set(value);
    }

    public static boolean getBoolean(String key) {
        return (Boolean)entries.get(key).get();
    }

    public static int getInteger(String key) {
        return (Integer)entries.get(key).get();
    }

    public static double getDouble(String key) {
        return (Double)entries.get(key).get();
    }

    public static void flipBoolean(String key) {
        Config.setBoolean(key, !Config.getBoolean(key));
    }

    public static void reset(String key) {
        Config.get(key).reset();
    }

    private static ConfigEntry<?> get(String key) {
        return entries.get(key);
    }

    private static <T> ConfigEntry<T> addEntry(ConfigEntry<T> entry) {
        entries.put(entry.configKey, entry);
        return entry;
    }

    static {
        Config.addEntry(new ConfigEntry<Integer>(Curves.EASE_OUT.ordinal(), ANIMATION_CURVE_KEY, ConfigEntry.Type.INTEGER)).addListener(o -> {
            animationCurve = Curves.values()[MathUtils.clamp(o, 0, Curves.values().length - 1)];
        });
        Config.addEntry(new ConfigEntry<Integer>(FadeTypes.FULL.ordinal(), FADE_TYPE_KEY, ConfigEntry.Type.INTEGER)).addListener(o -> {
            fadeType = FadeTypes.values()[MathUtils.clamp(o, 0, Curves.values().length - 1)];
        });
        Config.addEntry(new ConfigEntryDoubleLimitable(0.01, 10.0, 2.56, FADE_TIME_KEY)).addListener(o -> {
            fadeChangePerNano = Config.fadeChangeFromSeconds(o);
        });
        Config.addEntry(new ConfigEntryDoubleLimitable(0.01, 10.0, 2.56, ANIMATION_TIME_KEY)).addListener(o -> {
            animationChangePerNano = Config.animationChangeFromSeconds(o);
        });
        Config.addEntry(new ConfigEntryDoubleLimitable(1.0, 319.0, 64.0, ANIMATION_OFFSET_KEY)).addListener(o -> {
            animationInitialOffset = o.floatValue();
        });
        Config.addEntry(new ConfigEntry<Boolean>(true, MOD_ENABLED_KEY, ConfigEntry.Type.BOOLEAN)).addListener(o -> {
            isModEnabled = o;
        });
        Config.addEntry(new ConfigEntry<Boolean>(true, FADE_ENABLED_KEY, ConfigEntry.Type.BOOLEAN)).addListener(o -> {
            isFadeEnabled = o;
        });
        Config.addEntry(new ConfigEntry<Boolean>(false, ANIMATION_ENABLED_KEY, ConfigEntry.Type.BOOLEAN)).addListener(o -> {
            isAnimationEnabled = o;
        });
        Config.addEntry(new ConfigEntry<Boolean>(true, UPDATE_NOTIFIER_ENABLED_KEY, ConfigEntry.Type.BOOLEAN)).addListener(o -> {
            isUpdateNotifierEnabled = o;
        });
        Config.addEntry(new ConfigEntry<Boolean>(true, SHOW_MOD_BUTTON_IN_SETTINGS_KEY, ConfigEntry.Type.BOOLEAN)).addListener(o -> {
            showModButtonInSettings = o;
        });
        Config.addEntry(new ConfigEntry<Boolean>(true, ANIMATE_NEAR_PLAYER_KEY, ConfigEntry.Type.BOOLEAN)).addListener(o -> {
            animateNearPlayer = o;
        });
    }
}

