/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.option;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.coderbot.iris.shaderpack.option.OptionSet;
import net.coderbot.iris.shaderpack.option.values.OptionValues;

public final class Profile {
    public final String name;
    public final int precedence;
    public final Map<String, String> optionValues;
    public final List<String> disabledPrograms;

    private Profile(String string, Map<String, String> map, List<String> list) {
        this.name = string;
        this.optionValues = map;
        this.precedence = map.size();
        this.disabledPrograms = list;
    }

    public boolean matches(OptionSet optionSet, OptionValues optionValues) {
        for (Map.Entry<String, String> entry : this.optionValues.entrySet()) {
            String string;
            boolean bl;
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            if (optionSet.getBooleanOptions().containsKey((Object)string2) && !Boolean.toString(bl = optionValues.getBooleanValueOrDefault(string2)).equals(string3)) {
                return false;
            }
            if (!optionSet.getStringOptions().containsKey((Object)string2) || string3.equals(string = optionValues.getStringValueOrDefault(string2))) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private final String name;
        private final Map<String, String> optionValues = new HashMap<String, String>();
        private final List<String> disabledPrograms = new ArrayList<String>();

        public Builder(String string) {
            this.name = string;
        }

        public Builder option(String string, String string2) {
            this.optionValues.put(string, string2);
            return this;
        }

        public Builder disableProgram(String string) {
            this.disabledPrograms.add(string);
            return this;
        }

        public Builder addAll(Profile profile) {
            this.optionValues.putAll(profile.optionValues);
            this.disabledPrograms.addAll(profile.disabledPrograms);
            return this;
        }

        public Profile build() {
            return new Profile(this.name, (Map<String, String>)ImmutableMap.copyOf(this.optionValues), (List<String>)ImmutableList.copyOf(this.disabledPrograms));
        }
    }
}

