/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_fabric.functions;

import com.natamus.collective_common_fabric.services.Services;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.ArrayUtils;

public class DataFunctions {
    public static String readStringFromURL(String requestURL) {
        String data = "";
        try (Scanner scanner = new Scanner(new URL(requestURL).openStream(), StandardCharsets.UTF_8);){
            scanner.useDelimiter("\\A");
            data = scanner.hasNext() ? scanner.next() : "";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public static String getCurrentMinecraftVersion() {
        return "1.20.2";
    }

    public static String getGameDirectory() {
        return Services.MODLOADER.getGameDirectory();
    }

    public static Path getGameDirectoryPath() {
        return Path.of(DataFunctions.getGameDirectory(), new String[0]);
    }

    public static String getModDirectory() {
        return DataFunctions.getGameDirectory() + File.separator + "mods";
    }

    public static Path getModDirectoryPath() {
        return Path.of(DataFunctions.getModDirectory(), new String[0]);
    }

    public static String getConfigDirectory() {
        return DataFunctions.getGameDirectory() + File.separator + "config";
    }

    public static Path getConfigDirectoryPath() {
        return Path.of(DataFunctions.getConfigDirectory(), new String[0]);
    }

    public static List<String> getInstalledModJars() {
        ArrayList<String> installedmods = new ArrayList<String>();
        File mainFolder = new File(DataFunctions.getModDirectory());
        Object[] listOfMainFiles = mainFolder.listFiles();
        File subFolder = new File(DataFunctions.getModDirectory() + File.separator + DataFunctions.getCurrentMinecraftVersion());
        Object[] listOfSubFiles = subFolder.listFiles();
        for (File file : (File[])ArrayUtils.addAll((Object[])listOfMainFiles, (Object[])listOfSubFiles)) {
            if (!file.isFile()) continue;
            String filename = file.getName().replaceAll(" +\\([0-9]+\\)", "");
            installedmods.add(filename);
        }
        return installedmods;
    }

    public static byte setBit(byte b, int i, boolean bo) {
        b = bo ? (byte)(b | i) : (byte)(b & ~i);
        return b;
    }

    public static InputStream getDataInputStream(MinecraftServer minecraftServer, String modid, String folder, String fileNameWithoutExtension, String fileExtension) {
        return DataFunctions.getDataInputStream(minecraftServer, modid, folder, fileNameWithoutExtension + fileExtension);
    }

    public static InputStream getDataInputStream(MinecraftServer minecraftServer, String modid, String folder, String fileName) {
        if (!((String)(folder = ((String)folder).replace("\\", "/").strip())).endsWith("/")) {
            folder = (String)folder + "/";
        }
        try {
            Optional resourceOptional = minecraftServer.method_34864().method_14486(new class_2960(modid + ":" + (String)folder + fileName));
            if (resourceOptional.isPresent()) {
                class_3298 resource = (class_3298)resourceOptional.get();
                return resource.method_14482();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

