/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.mixinplugin;

import dev.isxander.debugify.Debugify;
import dev.isxander.debugify.fixes.BugFixData;
import dev.isxander.debugify.mixinplugin.MixinPlugin;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinErrorHandler;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public class DebugifyErrorHandler
implements IMixinErrorHandler {
    private static final Set<BugFixData> ERRORED_FIXES = new HashSet<BugFixData>();

    public IMixinErrorHandler.ErrorAction onPrepareError(IMixinConfig config, Throwable th, IMixinInfo mixin, IMixinErrorHandler.ErrorAction action) {
        return this.handleError(action, mixin);
    }

    public IMixinErrorHandler.ErrorAction onApplyError(String targetClassName, Throwable th, IMixinInfo mixin, IMixinErrorHandler.ErrorAction action) {
        return this.handleError(action, mixin);
    }

    private IMixinErrorHandler.ErrorAction handleError(IMixinErrorHandler.ErrorAction usualAction, IMixinInfo mixin) {
        ClassNode classNode;
        try {
            classNode = MixinService.getService().getBytecodeProvider().getClassNode(mixin.getClassName(), false);
        }
        catch (IOException | ClassNotFoundException e) {
            return usualAction;
        }
        Optional<BugFixData> bugFix = MixinPlugin.getBugFixForMixin(classNode);
        if (bugFix.isEmpty()) {
            return usualAction;
        }
        BugFixData fix = bugFix.get();
        ERRORED_FIXES.add(fix);
        Debugify.LOGGER.error("Failed to fully apply bug fix {}, mixin class {} will not be applied! This may cause runtime errors if a partial injection occurs.", (Object)fix.bugId(), (Object)mixin.getName());
        return IMixinErrorHandler.ErrorAction.WARN;
    }

    public static boolean hasErrored(BugFixData fix) {
        return ERRORED_FIXES.contains(fix);
    }
}

