/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.mode;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.schmarrn.lighty.api.LightyColors;
import dev.schmarrn.lighty.api.LightyHelper;
import dev.schmarrn.lighty.api.LightyMode;
import dev.schmarrn.lighty.api.ModeManager;
import dev.schmarrn.lighty.config.Config;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_765;

public class NumberMode
extends LightyMode {
    private static final float PXL = 0.0625f;
    private static final float dx = 0.25f;
    private static final float dz = 0.25f;

    @Override
    public void beforeCompute(class_287 builder) {
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
    }

    private static void renderDigit(class_287 builder, int digit, float x, float y, float z, int color, int lightmap) {
        float startU = (float)(3 & digit) / 4.0f;
        float startV = (float)(digit >> 2 & 3) / 4.0f;
        builder.method_22912((double)x, (double)y, (double)z).method_39415(color).method_22913(startU, startV).method_22916(lightmap).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        builder.method_22912((double)x, (double)y, (double)(z + 0.25f)).method_39415(color).method_22913(startU, startV + 0.25f).method_22916(lightmap).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        builder.method_22912((double)(x + 0.25f), (double)y, (double)(z + 0.25f)).method_39415(color).method_22913(startU + 0.25f, startV + 0.25f).method_22916(lightmap).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        builder.method_22912((double)(x + 0.25f), (double)y, (double)z).method_39415(color).method_22913(startU + 0.25f, startV).method_22916(lightmap).method_22914(0.0f, 1.0f, 0.0f).method_1344();
    }

    private static void renderNumber(class_287 builder, int number, float x, float y, float z, int color, int lightmap) {
        int oneDigit = number % 10;
        int tenDigit = number / 10;
        if (tenDigit > 0) {
            NumberMode.renderDigit(builder, tenDigit, x, y, z, color, lightmap);
            NumberMode.renderDigit(builder, oneDigit, x + 0.25f - 0.0625f, y, z, color, lightmap);
        } else {
            NumberMode.renderDigit(builder, oneDigit, x + 0.09375f, y, z, color, lightmap);
        }
    }

    @Override
    public void compute(class_638 world, class_2338 pos, class_287 builder) {
        class_2338 posUp = pos.method_10084();
        class_2680 up = world.method_8320(posUp);
        class_2680 block = world.method_8320(pos);
        if (LightyHelper.isBlocked(block, up, world, pos, posUp)) {
            return;
        }
        int blockLightLevel = world.method_8314(class_1944.field_9282, posUp);
        int skyLightLevel = world.method_8314(class_1944.field_9284, posUp);
        if (LightyHelper.isSafe(blockLightLevel) && !Config.getShowSafe()) {
            return;
        }
        int color = LightyColors.getARGB(blockLightLevel, skyLightLevel);
        float offset = LightyHelper.getOffset(up, posUp, world);
        if (offset == -1.0f) {
            return;
        }
        float x1 = (float)pos.method_10263() + 0.328125f;
        float y = (float)pos.method_10264() + 1.0f + 0.005f + offset;
        float z1 = (float)pos.method_10260() + 0.25f;
        int overlayBrightness = Config.getOverlayBrightness();
        int lightmap = class_765.method_23687((int)overlayBrightness, (int)overlayBrightness);
        NumberMode.renderNumber(builder, blockLightLevel, x1, y, z1, color, lightmap);
        NumberMode.renderNumber(builder, skyLightLevel, x1, y, z1 + 0.3f, color, lightmap);
    }

    @Override
    public void beforeRendering() {
        class_1921.method_23581().method_23516();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderTexture((int)0, (class_2960)new class_2960("lighty", "textures/block/numbers.png"));
    }

    public static void init() {
        ModeManager.registerMode(new class_2960("lighty", "number_mode"), new NumberMode());
    }
}

