/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps;

import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.config.EntitySelector;
import eu.ha3.presencefootsteps.config.JsonFile;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import java.nio.file.Path;
import net.minecraft.class_129;
import net.minecraft.class_3532;

public class PFConfig
extends JsonFile {
    private int volume = 70;
    private int clientPlayerVolume = 100;
    private int otherPlayerVolume = 100;
    private int hostileEntitiesVolume = 100;
    private int passiveEntitiesVolume = 100;
    private int runningVolumeIncrease = 0;
    private int wetSoundsVolume = 50;
    private int maxSteppingEntities = 50;
    private String stance = "UNKNOWN";
    private boolean multiplayer = true;
    private boolean global = true;
    private EntitySelector targetEntities = EntitySelector.ALL;
    private final transient PresenceFootsteps pf;

    public PFConfig(Path file, PresenceFootsteps pf) {
        super(file);
        this.pf = pf;
    }

    public boolean toggleMultiplayer() {
        this.multiplayer = !this.multiplayer;
        this.save();
        return this.multiplayer;
    }

    public EntitySelector cycleTargetSelector() {
        this.targetEntities = EntitySelector.VALUES[(this.targetEntities.ordinal() + 1) % EntitySelector.VALUES.length];
        this.save();
        return this.targetEntities;
    }

    public Locomotion setLocomotion(Locomotion loco) {
        if (loco != this.getLocomotion()) {
            this.stance = loco.name();
            this.save();
            this.pf.getEngine().reload();
        }
        return loco;
    }

    public Locomotion getLocomotion() {
        return Locomotion.byName(this.stance);
    }

    public EntitySelector getEntitySelector() {
        return this.targetEntities;
    }

    public boolean getEnabledGlobal() {
        return this.global && this.getEnabled();
    }

    public boolean getEnabledMP() {
        return this.multiplayer && this.getEnabled();
    }

    public int getMaxSteppingEntities() {
        return Math.max(1, this.maxSteppingEntities);
    }

    public boolean getEnabled() {
        return this.getGlobalVolume() > 0;
    }

    public int getGlobalVolume() {
        return class_3532.method_15340((int)this.volume, (int)0, (int)100);
    }

    public int getHostileEntitiesVolume() {
        return class_3532.method_15340((int)this.hostileEntitiesVolume, (int)0, (int)100);
    }

    public int getPassiveEntitiesVolume() {
        return class_3532.method_15340((int)this.passiveEntitiesVolume, (int)0, (int)100);
    }

    public int getClientPlayerVolume() {
        return class_3532.method_15340((int)this.clientPlayerVolume, (int)0, (int)100);
    }

    public int getOtherPlayerVolume() {
        return class_3532.method_15340((int)this.otherPlayerVolume, (int)0, (int)100);
    }

    public int getRunningVolumeIncrease() {
        return class_3532.method_15340((int)this.runningVolumeIncrease, (int)-100, (int)100);
    }

    public int getWetSoundsVolume() {
        return class_3532.method_15340((int)this.wetSoundsVolume, (int)0, (int)100);
    }

    public float setGlobalVolume(float volume) {
        if ((float)this.volume != (volume = (float)PFConfig.volumeScaleToInt(volume))) {
            boolean wasEnabled = this.getEnabled();
            this.volume = (int)volume;
            this.save();
            if (this.getEnabled() != wasEnabled) {
                this.pf.getEngine().reload();
            }
        }
        return this.getGlobalVolume();
    }

    public float setHostileEntitiesVolume(float volume) {
        this.hostileEntitiesVolume = PFConfig.volumeScaleToInt(volume);
        this.save();
        return this.getHostileEntitiesVolume();
    }

    public float setPassiveEntitiesVolume(float volume) {
        this.hostileEntitiesVolume = PFConfig.volumeScaleToInt(volume);
        this.save();
        return this.getPassiveEntitiesVolume();
    }

    public float setClientPlayerVolume(float volume) {
        this.clientPlayerVolume = PFConfig.volumeScaleToInt(volume);
        this.save();
        return this.getClientPlayerVolume();
    }

    public float setOtherPlayerVolume(float volume) {
        this.otherPlayerVolume = PFConfig.volumeScaleToInt(volume);
        this.save();
        return this.getOtherPlayerVolume();
    }

    public float setWetSoundsVolume(float volume) {
        this.wetSoundsVolume = PFConfig.volumeScaleToInt(volume);
        this.save();
        return this.getWetSoundsVolume();
    }

    public float setRunningVolumeIncrease(float volume) {
        this.runningVolumeIncrease = volume > 97.0f ? 100 : (volume < -97.0f ? -100 : (int)volume);
        this.save();
        return this.getRunningVolumeIncrease();
    }

    public void populateCrashReport(class_129 section) {
        section.method_578("PF Global Volume", (Object)this.volume);
        section.method_578("PF User's Selected Stance", (Object)(this.stance + " (" + this.getLocomotion() + ")"));
        section.method_578("Enabled Global", (Object)this.global);
        section.method_578("Enabled Multiplayer", (Object)this.multiplayer);
    }

    private static int volumeScaleToInt(float volume) {
        return volume > 97.0f ? 100 : (volume < 3.0f ? 0 : (int)volume);
    }
}

