/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.util;

import com.google.gson.JsonObject;
import eu.ha3.presencefootsteps.util.MathUtil;
import java.util.Random;

public record Range(float min, float max) {
    public static final Range DEFAULT = Range.exactly(1.0f);

    public static Range exactly(float value) {
        return new Range(value, value);
    }

    public Range read(String name, JsonObject json) {
        if (json.has(name)) {
            return Range.exactly(Range.getPercentage(json, name, this.min));
        }
        return new Range(Range.getPercentage(json, name + "_min", this.min), Range.getPercentage(json, name + "_max", this.max));
    }

    public float random(Random rand) {
        return MathUtil.randAB(rand, this.min, this.max);
    }

    public float on(float value) {
        return MathUtil.between(this.min, this.max, value);
    }

    private static float getPercentage(JsonObject object, String param, float fallback) {
        if (!object.has(param)) {
            return fallback;
        }
        return object.get(param).getAsFloat() / 100.0f;
    }
}

