/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import eu.ha3.presencefootsteps.world.Emitter;
import eu.ha3.presencefootsteps.world.Lookup;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class GolemLookup
implements Lookup<class_1299<?>> {
    private final Map<String, Map<class_2960, String>> substrates = new Object2ObjectLinkedOpenHashMap();

    @Override
    public String getAssociation(class_1299<?> key, String substrate) {
        Map<class_2960, String> primitives = this.substrates.get(substrate);
        if (primitives == null) {
            primitives = this.substrates.get("");
        }
        if (primitives == null) {
            return "UNASSIGNED";
        }
        return primitives.getOrDefault(class_1299.method_5890(key), "UNASSIGNED");
    }

    @Override
    public Set<String> getSubstrates() {
        return this.substrates.keySet();
    }

    @Override
    public void add(String key, String value) {
        String[] split = key.trim().split("@");
        String primitive = split[0];
        String substrate = split.length > 1 ? split[1] : "";
        this.substrates.computeIfAbsent(substrate, s -> new Object2ObjectLinkedOpenHashMap()).put(new class_2960(primitive), value);
    }

    @Override
    public boolean contains(class_1299<?> key) {
        class_2960 primitive = class_1299.method_5890(key);
        for (Map<class_2960, String> primitives : this.substrates.values()) {
            if (!primitives.containsKey(primitive)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeToReport(boolean full, JsonObjectWriter writer, Map<String, class_2498> groups) throws IOException {
        writer.each(class_7923.field_41177, type -> {
            if (full || !this.contains((class_1299<?>)type)) {
                writer.object(class_1299.method_5890((class_1299)type).toString(), () -> writer.object("associations", () -> this.getSubstrates().forEach(substrate -> {
                    try {
                        String association = this.getAssociation((class_1299<?>)type, (String)substrate);
                        if (Emitter.isResult(association)) {
                            writer.field((String)substrate, association);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                })));
            }
        });
    }
}

