/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import eu.ha3.presencefootsteps.world.Lookup;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2498;
import net.minecraft.class_2960;

public class PrimitiveLookup
implements Lookup<class_2498> {
    private final Map<String, Map<class_2960, String>> substrates = new Object2ObjectLinkedOpenHashMap();

    @Override
    public String getAssociation(class_2498 sounds, String substrate) {
        class_2960 id = sounds.method_10594().method_14833();
        Map<class_2960, String> primitives = this.substrates.get(substrate);
        if (primitives == null) {
            primitives = this.substrates.get("break_" + id.method_12832());
        }
        if (primitives == null) {
            primitives = this.substrates.get("");
        }
        if (primitives == null) {
            return "UNASSIGNED";
        }
        return primitives.getOrDefault(id, "UNASSIGNED");
    }

    @Override
    public Set<String> getSubstrates() {
        return this.substrates.keySet();
    }

    @Override
    public void add(String key, String value) {
        String[] split = key.trim().split("@");
        String primitive = split[0];
        String substrate = split.length > 1 ? split[1] : "";
        this.substrates.computeIfAbsent(substrate, s -> new Object2ObjectLinkedOpenHashMap()).put(new class_2960(primitive), value);
    }

    @Override
    public boolean contains(class_2498 sounds) {
        class_2960 primitive = sounds.method_10594().method_14833();
        for (Map<class_2960, String> primitives : this.substrates.values()) {
            if (!primitives.containsKey(primitive)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeToReport(boolean full, JsonObjectWriter writer, Map<String, class_2498> groups) throws IOException {
        writer.each(groups.values(), group -> {
            String substrate = String.format(Locale.ENGLISH, "%.2f_%.2f", Float.valueOf(group.field_11540), Float.valueOf(group.field_11539));
            if (full || !this.contains((class_2498)group)) {
                writer.field(group.method_10594().method_14833().toString() + "@" + substrate, this.getAssociation((class_2498)group, substrate));
            }
        });
    }
}

