/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import net.minecraft.class_2561;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.parent.GuiColumn;
import team.creative.creativecore.common.gui.controls.parent.GuiRow;
import team.creative.creativecore.common.gui.controls.simple.GuiButtonHoldSlim;
import team.creative.creativecore.common.gui.controls.simple.GuiColorPlate;
import team.creative.creativecore.common.gui.controls.simple.GuiColoredSteppedSlider;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.type.Color;

public class GuiColorPicker
extends GuiParent {
    public Color color;

    public GuiColorPicker(String name, Color color, boolean hasAlpha, int alphaMin) {
        super(name);
        this.color = color;
        GuiRow row = new GuiRow();
        this.add(row);
        GuiColumn sliders = new GuiColumn(GuiFlow.STACK_Y);
        sliders.spacing = -1;
        row.addColumn(sliders);
        GuiParent red = new GuiParent(GuiFlow.STACK_X).setVAlign(VAlign.CENTER);
        sliders.add(red);
        red.add(new GuiButtonHoldSlim("r-", x -> {
            ((GuiColoredSteppedSlider)this.get("r")).stepDown();
            this.onColorChanged();
        }).setTitle((class_2561)class_2561.method_43470((String)"<")));
        red.add(new GuiColoredSteppedSlider("r", this, ColorUtils.ColorPart.RED).setExpandableX());
        red.add(new GuiButtonHoldSlim("r+", x -> {
            ((GuiColoredSteppedSlider)this.get("r")).stepUp();
            this.onColorChanged();
        }).setTitle((class_2561)class_2561.method_43470((String)">")));
        GuiParent green = new GuiParent(GuiFlow.STACK_X).setVAlign(VAlign.CENTER);
        sliders.add(green);
        green.add(new GuiButtonHoldSlim("g-", x -> {
            ((GuiColoredSteppedSlider)this.get("g")).stepDown();
            this.onColorChanged();
        }).setTitle((class_2561)class_2561.method_43470((String)"<")));
        green.add(new GuiColoredSteppedSlider("g", this, ColorUtils.ColorPart.GREEN).setExpandableX());
        green.add(new GuiButtonHoldSlim("g+", x -> {
            ((GuiColoredSteppedSlider)this.get("g")).stepUp();
            this.onColorChanged();
        }).setTitle((class_2561)class_2561.method_43470((String)">")));
        GuiParent blue = new GuiParent(GuiFlow.STACK_X).setVAlign(VAlign.CENTER);
        sliders.add(blue);
        blue.add(new GuiButtonHoldSlim("b-", x -> {
            ((GuiColoredSteppedSlider)this.get("b")).stepDown();
            this.onColorChanged();
        }).setTitle((class_2561)class_2561.method_43470((String)"<")));
        blue.add(new GuiColoredSteppedSlider("b", this, ColorUtils.ColorPart.BLUE).setExpandableX());
        blue.add(new GuiButtonHoldSlim("b+", x -> {
            ((GuiColoredSteppedSlider)this.get("b")).stepUp();
            this.onColorChanged();
        }).setTitle((class_2561)class_2561.method_43470((String)">")));
        if (hasAlpha) {
            GuiParent alpha = new GuiParent(GuiFlow.STACK_X).setVAlign(VAlign.CENTER);
            sliders.add(alpha);
            alpha.add(new GuiButtonHoldSlim("a-", x -> {
                ((GuiColoredSteppedSlider)this.get("a")).stepDown();
                this.onColorChanged();
            }).setTitle((class_2561)class_2561.method_43470((String)"<")));
            alpha.add(new GuiColoredSteppedSlider("a", this, ColorUtils.ColorPart.ALPHA).setExpandableX());
            alpha.add(new GuiButtonHoldSlim("a+", x -> {
                ((GuiColoredSteppedSlider)this.get("a")).stepUp();
                this.onColorChanged();
            }).setTitle((class_2561)class_2561.method_43470((String)">")));
        } else {
            color.setAlpha(255);
        }
        GuiColumn plate = new GuiColumn(30, (GuiFlow)GuiFlow.STACK_Y);
        plate.align = Align.CENTER;
        plate.valign = VAlign.CENTER;
        row.addColumn(plate);
        plate.add(new GuiColorPlate("plate", color).setDim(20, 20));
        this.registerEventChanged(x -> {
            if (x.control.is("r", "g", "b", "a")) {
                this.onColorChanged();
            }
        });
    }

    public void setColor(Color color) {
        this.color.set(color);
        ((GuiColoredSteppedSlider)this.get((String)"r")).value = color.getRed();
        ((GuiColoredSteppedSlider)this.get((String)"g")).value = color.getGreen();
        ((GuiColoredSteppedSlider)this.get((String)"b")).value = color.getBlue();
        if (this.has("a")) {
            ((GuiColoredSteppedSlider)this.get((String)"a")).value = color.getAlpha();
        }
    }

    public void onColorChanged() {
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }
}

