/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.config.screens.warnings.ETFConfigWarning;
import traben.entity_texture_features.config.screens.warnings.ETFConfigWarnings;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.property_reading.PropertiesRandomProvider;
import traben.entity_texture_features.features.property_reading.TrueRandomProvider;
import traben.entity_texture_features.features.property_reading.properties.RandomProperties;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;

public final class ETFApi {
    public static final int ETFApiVersion = 9;
    @Deprecated
    public static ETFConfig getETFConfigObject = null;
    public static final UUID ETF_GENERIC_UUID = UUID.nameUUIDFromBytes("GENERIC".getBytes());

    public static ETFConfig getETFConfigObject() {
        return ETFClientCommon.ETFConfigData;
    }

    public static void setETFConfigObject(ETFConfig newETFConfig) {
        ETFClientCommon.ETFConfigData = newETFConfig;
        ETFApi.saveETFConfigChangesAndResetETF();
    }

    public static ETFConfig getCopyOfETFConfigObject() {
        return ETFConfig.copyFrom(ETFClientCommon.ETFConfigData);
    }

    public static ETFConfig getDefaultETFConfigObject() {
        return new ETFConfig();
    }

    public static void saveETFConfigChangesAndResetETF() {
        ETFUtils2.saveConfig();
        ETFManager.resetInstance();
    }

    public static void resetETF() {
        ETFManager.resetInstance();
    }

    public static UUID getUUIDForBlockEntity(class_2586 blockEntity) {
        long most = blockEntity.method_11010().hashCode();
        long least = blockEntity.method_11016().hashCode();
        return new UUID(most, least);
    }

    @NotNull
    public static class_2960 getCurrentETFVariantTextureOfEntity(@NotNull class_1297 entity, @NotNull class_2960 defaultTexture) {
        if (entity != null) {
            class_2960 etfIdentifier;
            ETFEntity etfEntity = (ETFEntity)entity;
            ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTexture, etfEntity);
            if (etfTexture != null && (etfIdentifier = etfTexture.getTextureIdentifier(etfEntity)) != null) {
                return etfIdentifier;
            }
        }
        return defaultTexture;
    }

    public static class_2960 getCurrentETFVariantTextureOfBlockEntity(@NotNull class_2586 entity, @NotNull class_2960 defaultTexture) {
        if (entity != null) {
            ETFEntity etfEntity = (ETFEntity)entity;
            return ETFApi.getCurrentETFVariantTextureOfBlockEntityInternal(etfEntity, defaultTexture);
        }
        return defaultTexture;
    }

    public static class_2960 getCurrentETFVariantTextureOfBlockEntity(@NotNull class_2586 entity, @NotNull class_2960 defaultTexture, @NotNull UUID specifiedUUID) {
        if (entity != null) {
            ETFEntity etfEntity = (ETFEntity)entity;
            return ETFApi.getCurrentETFVariantTextureOfBlockEntityInternal(etfEntity, defaultTexture);
        }
        return defaultTexture;
    }

    private static class_2960 getCurrentETFVariantTextureOfBlockEntityInternal(@NotNull ETFEntity etfEntity, @NotNull class_2960 defaultTexture) {
        class_2960 etfIdentifier;
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTexture, etfEntity);
        if (etfTexture != null && (etfIdentifier = etfTexture.getTextureIdentifier(etfEntity)) != null) {
            return etfIdentifier;
        }
        return defaultTexture;
    }

    @Deprecated
    @NotNull
    public static class_2960 getCurrentETFVariantTextureOfEntity(@NotNull class_2586 entity, @NotNull class_2960 defaultTexture, UUID ignore) {
        return ETFApi.getCurrentETFVariantTextureOfBlockEntity(entity, defaultTexture);
    }

    @Nullable
    public static class_2960 getCurrentETFEmissiveTextureOfEntityOrNull(@NotNull class_1297 entity, @NotNull class_2960 defaultTexture) {
        ETFTexture etfTexture;
        if (entity != null && (etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTexture, (ETFEntity)entity)) != null) {
            return etfTexture.getEmissiveIdentifierOfCurrentState();
        }
        return null;
    }

    @Nullable
    public static class_2960 getCurrentETFEmissiveTextureOfBlockEntityOrNull(@NotNull class_2586 entity, @NotNull class_2960 defaultTexture) {
        ETFTexture etfTexture;
        if (entity != null && (etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTexture, (ETFEntity)entity)) != null) {
            return etfTexture.getEmissiveIdentifierOfCurrentState();
        }
        return null;
    }

    public static void renderETFEmissiveModel(@NotNull class_1297 entity, @NotNull class_2960 defaultTextureOfEntity, @NotNull class_4587 matrixStack, @NotNull class_4597 vertexConsumerProvider, @NotNull class_3879 model) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTextureOfEntity, (ETFEntity)entity);
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, model);
        }
    }

    public static void renderETFEmissiveModelPart(@NotNull class_1297 entity, @NotNull class_2960 defaultTextureOfEntity, @NotNull class_4587 matrixStack, @NotNull class_4597 vertexConsumerProvider, @NotNull class_630 modelPart) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTextureOfEntity, (ETFEntity)entity);
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, modelPart);
        }
    }

    public static void renderETFEmissiveModel(@NotNull class_2586 entity, @NotNull class_2960 defaultTextureOfEntity, @NotNull class_4587 matrixStack, @NotNull class_4597 vertexConsumerProvider, @NotNull class_3879 model) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTextureOfEntity, (ETFEntity)entity);
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, model);
        }
    }

    public static void renderETFEmissiveModelPart(@NotNull class_2586 entity, @NotNull class_2960 defaultTextureOfEntity, @NotNull class_4587 matrixStack, @NotNull class_4597 vertexConsumerProvider, @NotNull class_630 modelPart) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTextureOfEntity, (ETFEntity)entity);
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, modelPart);
        }
    }

    @Nullable
    public static ETFVariantSuffixProvider getVariantSupplierOrNull(class_2960 propertiesFileIdentifier, class_2960 vanillaIdentifier, String ... suffixKeys) {
        return ETFVariantSuffixProvider.getVariantProviderOrNull(propertiesFileIdentifier, vanillaIdentifier, suffixKeys);
    }

    public static int getLastMatchingRuleOfEntity(class_1297 entity) {
        Integer ruleIndex = ETFManager.getInstance().LAST_MET_RULE_INDEX.getInt(entity.method_5667());
        return ruleIndex == null ? 0 : ruleIndex;
    }

    public static int getLastMatchingRuleOfBlockEntity(class_2586 entity) {
        Integer ruleIndex = ETFManager.getInstance().LAST_MET_RULE_INDEX.getInt(((ETFEntity)entity).etf$getUuid());
        return ruleIndex == null ? 0 : ruleIndex;
    }

    public static void registerCustomRandomPropertyFactory(String yourModId, RandomProperties.RandomPropertyFactory ... factories) {
        if (factories != null && factories.length != 0) {
            RandomProperties.register(factories);
            ETFUtils2.logMessage(factories.length + " new ETF Random Properties registered by " + yourModId);
        }
    }

    public static void registerCustomETFConfigWarning(String yourModId, ETFConfigWarning ... warnings) {
        if (warnings != null && warnings.length != 0) {
            ETFConfigWarnings.registerConfigWarning(warnings);
            ETFUtils2.logMessage(warnings.length + " new ETF Config Warnings registered by " + yourModId);
        }
    }

    public static interface ETFVariantSuffixProvider {
        @Nullable
        public static ETFVariantSuffixProvider getVariantProviderOrNull(class_2960 propertiesFileIdentifier, class_2960 vanillaIdentifier, String ... suffixKeyName) {
            PropertiesRandomProvider optifine = PropertiesRandomProvider.of(propertiesFileIdentifier, vanillaIdentifier, suffixKeyName);
            TrueRandomProvider random = TrueRandomProvider.of(vanillaIdentifier);
            if (optifine == null && vanillaIdentifier.method_12832().endsWith(".png") && "minecraft".equals(vanillaIdentifier.method_12836()) && vanillaIdentifier.method_12832().contains("_")) {
                String vanId = vanillaIdentifier.method_12832().replaceAll("_(tame|angry|nectar|shooting|cold)", "");
                optifine = PropertiesRandomProvider.of(new class_2960(vanId.replace(".png", ".properties")), new class_2960(vanId), suffixKeyName);
            }
            if (random == null && optifine == null) {
                return null;
            }
            if (optifine == null) {
                return random;
            }
            if (random == null) {
                return optifine;
            }
            if (optifine.getPackName() != null && optifine.getPackName().equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(random.getPackName(), optifine.getPackName()))) {
                return optifine;
            }
            return random;
        }

        public boolean entityCanUpdate(UUID var1);

        public IntOpenHashSet getAllSuffixes();

        public int size();

        default public int getSuffixForEntity(class_1297 entityToBeTested) {
            return this.getSuffixForETFEntity((ETFEntity)entityToBeTested);
        }

        default public int getSuffixForBlockEntity(class_2586 entityToBeTested) {
            return this.getSuffixForETFEntity((ETFEntity)entityToBeTested);
        }

        public int getSuffixForETFEntity(ETFEntity var1);
    }
}

