/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.EntityBooleanLRU;

public class RandomPropertyRule {
    public final int RULE_NUMBER;
    public final String PROPERTY_FILE;
    private final Integer[] SUFFIX_NUMBERS_WEIGHTED;
    private final RandomProperty[] PROPERTIES_TO_TEST;
    private final boolean RULE_ALWAYS_APPROVED;

    public RandomPropertyRule(String propertiesFile, int ruleNumber, Integer[] suffixes, Integer[] weights, RandomProperty ... properties) {
        this.PROPERTY_FILE = propertiesFile;
        this.RULE_NUMBER = ruleNumber;
        this.PROPERTIES_TO_TEST = properties;
        boolean bl = this.RULE_ALWAYS_APPROVED = properties.length == 0;
        if (weights == null || weights.length == 0) {
            this.SUFFIX_NUMBERS_WEIGHTED = suffixes;
        } else if (weights.length == suffixes.length) {
            LinkedList<Integer> weightedSuffixArray = new LinkedList<Integer>();
            try {
                for (int index = 0; index < suffixes.length; ++index) {
                    int suffixValue = suffixes[index];
                    int weightValue = weights[index];
                    for (int i = 0; i < weightValue; ++i) {
                        weightedSuffixArray.add(suffixValue);
                    }
                }
            }
            catch (Exception e) {
                weightedSuffixArray.clear();
                weightedSuffixArray.addAll(List.of(suffixes));
            }
            this.SUFFIX_NUMBERS_WEIGHTED = weightedSuffixArray.toArray(new Integer[0]);
        } else {
            ETFUtils2.logWarn("random texture weights don't match for [" + this.PROPERTY_FILE + "] rule # [" + this.RULE_NUMBER + "] :\n suffixes: " + Arrays.toString((Object[])suffixes) + "\n weights: " + Arrays.toString((Object[])weights), false);
            this.SUFFIX_NUMBERS_WEIGHTED = suffixes;
        }
    }

    public Set<Integer> getSuffixSet() {
        return new HashSet<Integer>(List.of(this.SUFFIX_NUMBERS_WEIGHTED));
    }

    public boolean doesEntityMeetConditionsOfThisCase(ETFEntity etfEntity, boolean isUpdate, EntityBooleanLRU UUID_CaseHasUpdateablesCustom) {
        if (this.RULE_ALWAYS_APPROVED) {
            return true;
        }
        if (etfEntity == null) {
            return false;
        }
        UUID id = etfEntity.etf$getUuid();
        boolean wasEntityTestedByAnUpdatableProperty = false;
        boolean entityMetRequirements = true;
        try {
            for (RandomProperty property : this.PROPERTIES_TO_TEST) {
                if (entityMetRequirements) {
                    if (property.isPropertyUpdatable()) {
                        wasEntityTestedByAnUpdatableProperty = true;
                    }
                    entityMetRequirements = property.testEntity(etfEntity, isUpdate);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            ETFUtils2.logWarn("Random Property file [" + this.PROPERTY_FILE + "] rule # [" + this.RULE_NUMBER + "] failed with Exception:\n" + e.getMessage());
            entityMetRequirements = false;
            wasEntityTestedByAnUpdatableProperty = false;
        }
        if (wasEntityTestedByAnUpdatableProperty && UUID_CaseHasUpdateablesCustom != null) {
            UUID_CaseHasUpdateablesCustom.put(etfEntity.etf$getUuid(), true);
        }
        ETFManager.getInstance().LAST_MET_RULE_INDEX.put(id, entityMetRequirements ? this.RULE_NUMBER : 0);
        return entityMetRequirements;
    }

    public int getVariantSuffixFromThisCase(UUID uuid) {
        int randomSeededByUUID = Math.abs(uuid.hashCode());
        return this.SUFFIX_NUMBERS_WEIGHTED[randomSeededByUUID % this.SUFFIX_NUMBERS_WEIGHTED.length];
    }

    public void cacheEntityInitialResultsOfNonUpdatingProperties(ETFEntity entity) {
        try {
            for (RandomProperty property : this.PROPERTIES_TO_TEST) {
                if (property.isPropertyUpdatable()) continue;
                property.cacheEntityInitialResult(entity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

