/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.optifine_properties;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_2105;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.SimpleIntegerArrayProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;

public class NBTProperty
extends RandomProperty {
    private final Map<String, String> NBT_MAP;

    protected NBTProperty(Properties properties, int propertyNum) throws RandomProperty.RandomPropertyException {
        String keyPrefix = "nbt." + propertyNum + ".";
        this.NBT_MAP = new Object2ObjectLinkedOpenHashMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key != null && ((String)key).startsWith(keyPrefix)) {
                String nbtName = ((String)key).replaceFirst(keyPrefix, "");
                String instruction = ((String)value).trim();
                if (!nbtName.isBlank() && !instruction.isBlank()) {
                    this.NBT_MAP.put(nbtName, instruction);
                }
            }
        }));
        if (this.NBT_MAP.isEmpty()) {
            throw new RandomProperty.RandomPropertyException("NBT failed");
        }
    }

    public static NBTProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new NBTProperty(properties, propertyNum);
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    private static boolean isStringValidInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean testEntityInternal(ETFEntity entity) {
        boolean bl;
        class_2487 entityNBT;
        if (entity instanceof class_1297) {
            class_1297 internal = (class_1297)entity;
            entityNBT = class_2105.method_9076((class_1297)internal);
        } else {
            entityNBT = entity.etf$writeNbt(new class_2487());
        }
        boolean doesEntityMeetThisCaseTest = true;
        if (entityNBT.method_33133()) {
            ETFUtils2.logError("NBT test failed, as could not read entity NBT");
            return false;
        }
        Iterator<Map.Entry<String, String>> iterator = this.NBT_MAP.entrySet().iterator();
        do {
            boolean doesTestPass;
            boolean invertFinalResult;
            block18: {
                Object nbtNumber;
                StringArrayOrRegexProperty.RegexAndPatternPropertyMatcher matcher;
                String nbtTestInstruction;
                block29: {
                    String rawMatchString;
                    String rawStringFromNBT;
                    block30: {
                        String nbtIdentifier;
                        block22: {
                            class_2487 finalNBTElementOrNullIfFailed;
                            block27: {
                                block28: {
                                    class_2483 nbtList;
                                    boolean listIndexInstructionWasWildCard;
                                    block26: {
                                        block25: {
                                            block24: {
                                                String rawStringFromNBT2;
                                                block23: {
                                                    if (!iterator.hasNext()) return doesEntityMeetThisCaseTest;
                                                    Map.Entry<String, String> nbtPropertyEntry = iterator.next();
                                                    nbtIdentifier = nbtPropertyEntry.getKey();
                                                    nbtTestInstruction = nbtPropertyEntry.getValue();
                                                    invertFinalResult = nbtTestInstruction.startsWith("!");
                                                    if ((nbtTestInstruction = nbtTestInstruction.replaceFirst("!", "")).startsWith("print:")) {
                                                        ETFUtils2.logMessage("NBT entity data print: \n" + entityNBT.method_10714());
                                                        nbtTestInstruction = nbtTestInstruction.replaceFirst("print:", "");
                                                    }
                                                    finalNBTElementOrNullIfFailed = null;
                                                    listIndexInstructionWasWildCard = false;
                                                    class_2487 lastIterationNBTElement = entityNBT;
                                                    Iterator nbtPathInstructionIterator = Arrays.stream(nbtIdentifier.split("\\.")).iterator();
                                                    while (nbtPathInstructionIterator.hasNext()) {
                                                        block20: {
                                                            String nextPathInstruction;
                                                            block21: {
                                                                block19: {
                                                                    if (lastIterationNBTElement == null) {
                                                                        ETFUtils2.logWarn("null nbt in ETF");
                                                                        break;
                                                                    }
                                                                    nextPathInstruction = (String)nbtPathInstructionIterator.next();
                                                                    if (!(lastIterationNBTElement instanceof class_2487)) break block19;
                                                                    class_2487 nbtCompound = lastIterationNBTElement;
                                                                    if (!nbtCompound.method_10545(nextPathInstruction)) break;
                                                                    lastIterationNBTElement = nbtCompound.method_10580(nextPathInstruction);
                                                                    break block20;
                                                                }
                                                                if (!(lastIterationNBTElement instanceof class_2483)) break block21;
                                                                nbtList = (class_2483)lastIterationNBTElement;
                                                                if ("*".equals(nextPathInstruction)) {
                                                                    listIndexInstructionWasWildCard = true;
                                                                    break block20;
                                                                } else {
                                                                    if (NBTProperty.isStringValidInt(nextPathInstruction)) {
                                                                        try {
                                                                            int index = Integer.parseInt(nextPathInstruction);
                                                                            lastIterationNBTElement = (class_2520)nbtList.get(index);
                                                                        }
                                                                        catch (IndexOutOfBoundsException e) {
                                                                            break;
                                                                        }
                                                                    }
                                                                    ETFUtils2.logWarn("cannot parse list index of [" + nextPathInstruction + "] in nbt property: " + nbtIdentifier);
                                                                    break;
                                                                }
                                                            }
                                                            ETFUtils2.logError("cannot parse next nbt instruction of [" + nextPathInstruction + "] in nbt property: " + nbtIdentifier + ", as this nbt is not a list or compound and cannot have further instructions");
                                                            break;
                                                        }
                                                        if (nbtPathInstructionIterator.hasNext()) continue;
                                                        finalNBTElementOrNullIfFailed = lastIterationNBTElement;
                                                    }
                                                    doesTestPass = false;
                                                    if (finalNBTElementOrNullIfFailed == null) break block22;
                                                    if (!nbtTestInstruction.startsWith("print_raw:")) break block23;
                                                    rawStringFromNBT2 = finalNBTElementOrNullIfFailed.method_10714();
                                                    String rawMatchString2 = nbtTestInstruction.replaceFirst("print_raw:", "");
                                                    ETFUtils2.logMessage("NBT RAW data of: " + nbtIdentifier + "=" + rawStringFromNBT2);
                                                    matcher = StringArrayOrRegexProperty.getStringMatcher_Regex_Pattern_List_Single(rawMatchString2);
                                                    doesTestPass = matcher != null && matcher.testString(rawStringFromNBT2);
                                                    break block18;
                                                }
                                                if (!nbtTestInstruction.startsWith("raw:")) break block24;
                                                rawStringFromNBT2 = finalNBTElementOrNullIfFailed.method_10714();
                                                String rawMatchString3 = nbtTestInstruction.replaceFirst("raw:", "");
                                                matcher = StringArrayOrRegexProperty.getStringMatcher_Regex_Pattern_List_Single(rawMatchString3);
                                                doesTestPass = matcher != null && matcher.testString(rawStringFromNBT2);
                                                break block18;
                                            }
                                            if (!nbtTestInstruction.startsWith("exists:")) break block25;
                                            doesTestPass = nbtTestInstruction.contains("exists:true");
                                            break block18;
                                        }
                                        if (!nbtTestInstruction.startsWith("range:")) break block26;
                                        if (finalNBTElementOrNullIfFailed instanceof class_2514) {
                                            nbtNumber = (class_2514)finalNBTElementOrNullIfFailed;
                                            String rawRangeString = nbtTestInstruction.replaceFirst("range:", "");
                                            SimpleIntegerArrayProperty.IntRange range = SimpleIntegerArrayProperty.getIntRange(rawRangeString);
                                            doesTestPass = range.isWithinRange(nbtNumber.method_10702().intValue());
                                            break block18;
                                        } else {
                                            ETFUtils2.logWarn("NBT range is not valid for non number nbt types: " + nbtIdentifier + "=" + nbtTestInstruction);
                                        }
                                        break block18;
                                    }
                                    if (!(finalNBTElementOrNullIfFailed instanceof class_2483)) break block27;
                                    nbtList = (class_2483)finalNBTElementOrNullIfFailed;
                                    if (!listIndexInstructionWasWildCard) break block28;
                                    nbtNumber = nbtList.iterator();
                                    break block29;
                                }
                                ETFUtils2.logWarn("NBT list error with: " + nbtIdentifier + "=" + nbtTestInstruction);
                                break block18;
                            }
                            StringArrayOrRegexProperty.RegexAndPatternPropertyMatcher matcher2 = StringArrayOrRegexProperty.getStringMatcher_Regex_Pattern_List_Single(nbtTestInstruction);
                            doesTestPass = matcher2 != null && matcher2.testString(finalNBTElementOrNullIfFailed.method_10714());
                            break block18;
                        }
                        if (!nbtTestInstruction.startsWith("print_raw:")) break block30;
                        rawStringFromNBT = "";
                        rawMatchString = nbtTestInstruction.replaceFirst("print_raw:", "");
                        ETFUtils2.logMessage("NBT RAW data of: " + nbtIdentifier + "=" + rawStringFromNBT);
                        doesTestPass = rawMatchString.equals(rawStringFromNBT);
                        break block18;
                    }
                    if (nbtTestInstruction.startsWith("raw:")) {
                        rawStringFromNBT = "";
                        rawMatchString = nbtTestInstruction.replaceFirst("raw:", "");
                        doesTestPass = rawMatchString.equals(rawStringFromNBT);
                        break block18;
                    } else if (nbtTestInstruction.startsWith("exists:")) {
                        doesTestPass = nbtTestInstruction.contains("exists:false");
                    }
                    break block18;
                }
                while (nbtNumber.hasNext()) {
                    class_2520 element = (class_2520)nbtNumber.next();
                    matcher = StringArrayOrRegexProperty.getStringMatcher_Regex_Pattern_List_Single(nbtTestInstruction);
                    doesTestPass = matcher != null && matcher.testString(element.method_10714());
                    if (!doesTestPass) continue;
                }
            }
            if (invertFinalResult == doesTestPass) return false;
            bl = true;
        } while (doesEntityMeetThisCaseTest = bl);
        return doesEntityMeetThisCaseTest;
    }

    @Override
    public boolean isPropertyUpdatable() {
        return true;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"nbt"};
    }

    @Override
    protected String getPrintableRuleInfo() {
        return null;
    }
}

