/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import journeymap.client.JourneymapClient;
import journeymap.client.api.model.WrappedEntity;
import journeymap.client.model.EntityHelper;
import journeymap.client.properties.CoreProperties;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1068;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1496;
import net.minecraft.class_1498;
import net.minecraft.class_1646;
import net.minecraft.class_1655;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_746;

public class EntityDTO
implements WrappedEntity,
Serializable {
    public final String entityId;
    public transient WeakReference<class_1309> entityLivingRef;
    public transient class_2960 entityIconLocation;
    public String iconLocation;
    public Boolean hostile;
    public double posX;
    public double posY;
    public double posZ;
    public int chunkCoordX;
    public int chunkCoordY;
    public int chunkCoordZ;
    private class_2338 chunkPos;
    public double heading;
    private class_2561 customName;
    public String serializedCustomName;
    public String owner;
    public String profession;
    public String username;
    public String biome;
    public class_5321<class_1937> dimension;
    public Boolean underground;
    public boolean invisible;
    public boolean sneaking;
    public boolean passiveAnimal;
    public boolean npc;
    public int color;
    private List<class_2561> entityToolTips;
    private List<String> serializedTooltips;
    public boolean disabled = false;

    private EntityDTO(class_1309 entity) {
        this.entityLivingRef = new WeakReference<class_1309>(entity);
        this.entityId = entity.method_5667().toString();
    }

    public void update(class_1309 entity, boolean hostile) {
        class_1496 horse;
        class_1309 attackTarget;
        class_1297 ownerEntity;
        class_310 mc = class_310.method_1551();
        class_746 currentPlayer = class_310.method_1551().field_1724;
        this.dimension = DimensionHelper.getDimension((class_1297)entity);
        this.posX = entity.method_19538().method_10216();
        this.posY = entity.method_19538().method_10214();
        this.posZ = entity.method_19538().method_10215();
        this.chunkCoordX = entity.method_31476().field_9181;
        this.chunkCoordY = entity.method_31478() >> 4;
        this.chunkCoordZ = entity.method_31476().field_9180;
        this.chunkPos = new class_2338(this.chunkCoordX, this.chunkCoordY, this.chunkCoordZ);
        this.heading = Math.round(entity.method_36454() % 360.0f);
        this.disabled = false;
        this.customName = null;
        this.serializedCustomName = null;
        this.entityToolTips = null;
        this.invisible = currentPlayer != null ? entity.method_5756((class_1657)currentPlayer) : false;
        this.sneaking = entity.method_5715();
        CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
        class_2960 entityIcon = null;
        int playerColor = coreProperties.getColor(coreProperties.colorPlayer);
        class_268 team = null;
        try {
            team = mc.field_1687.method_8428().method_1164(entity.method_5845());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (entity instanceof class_1657) {
            this.username = class_3544.method_15440((String)entity.method_5477().getString());
            try {
                playerColor = team != null ? team.method_1202().method_536() : (currentPlayer.equals((Object)entity) ? coreProperties.getColor(coreProperties.colorSelf) : coreProperties.getColor(coreProperties.colorPlayer));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            entityIcon = class_1068.method_4649();
            try {
                class_634 client = class_310.method_1551().method_1562();
                class_640 info = client.method_2871(entity.method_5667());
                if (info != null) {
                    entityIcon = info.method_52810().comp_1626();
                }
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Error looking up player skin: " + LogFormatter.toPartialString(t));
            }
        } else {
            this.username = null;
            entityIcon = EntityHelper.getIconTextureLocation((class_1297)entity);
        }
        if (entityIcon != null) {
            this.entityIconLocation = entityIcon;
            this.iconLocation = entityIcon.toString();
        }
        if ((ownerEntity = this.getTamedOwner(entity)) != null) {
            this.owner = ownerEntity.method_5477().getString();
        }
        class_2561 customName = null;
        boolean passive = false;
        class_1309 entityLiving = entity;
        if (entity.method_16914() && entityLiving.method_5733()) {
            customName = entity.method_5797();
        }
        if (!hostile && currentPlayer != null && (attackTarget = entity.method_6124()) != null && attackTarget.method_5667().equals(currentPlayer.method_5667())) {
            hostile = true;
        }
        if (EntityHelper.isPassive(entity)) {
            passive = true;
        }
        if (entity instanceof class_1646) {
            class_1646 villager = (class_1646)entity;
            this.profession = villager.method_7231().method_16924().comp_818();
        } else if (entity instanceof class_1655) {
            this.npc = true;
            this.profession = null;
            this.passiveAnimal = false;
        } else {
            this.profession = null;
            this.passiveAnimal = passive;
        }
        if (customName != null) {
            this.setCustomName(customName);
        }
        this.hostile = hostile;
        this.color = entity instanceof class_1657 ? playerColor : (team != null ? team.method_1202().method_536() : (this.owner != null || entityLiving instanceof class_1496 && (horse = (class_1496)entityLiving).method_6727() ? coreProperties.getColor(coreProperties.colorPet) : (this.profession != null || this.npc ? coreProperties.getColor(coreProperties.colorVillager) : (hostile ? coreProperties.getColor(coreProperties.colorHostile) : coreProperties.getColor(coreProperties.colorPassive)))));
    }

    private class_1297 getTamedOwner(class_1309 livingEntity) {
        class_746 currentPlayer = class_310.method_1551().field_1724;
        if (livingEntity instanceof class_1321) {
            class_1309 ownerEntity = ((class_1321)livingEntity).method_35057();
            if (ownerEntity != null) {
                return ownerEntity;
            }
        } else if (livingEntity instanceof class_1498) {
            UUID ownerUuid = ((class_1498)livingEntity).method_6139();
            if (currentPlayer != null && ownerUuid != null) {
                try {
                    String playerUuid = currentPlayer.method_5667().toString();
                    if (playerUuid.equals(ownerUuid.toString())) {
                        return currentPlayer;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return null;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public WeakReference<class_1309> getEntityLivingRef() {
        return this.entityLivingRef;
    }

    public class_2960 getEntityIconLocation() {
        return this.entityIconLocation;
    }

    public Boolean getHostile() {
        return this.hostile;
    }

    public class_243 getPosition() {
        return ((class_1309)this.entityLivingRef.get()).method_19538();
    }

    public class_2338 getChunkPos() {
        return this.chunkPos;
    }

    public double getHeading() {
        return this.heading;
    }

    public class_2561 getCustomName() {
        return this.customName;
    }

    public class_1297 getOwner() {
        return this.getTamedOwner((class_1309)this.entityLivingRef.get());
    }

    public String getProfession() {
        return this.profession;
    }

    public String getPlayerName() {
        return this.username;
    }

    public class_1959 getBiome() {
        return (class_1959)class_310.method_1551().field_1687.method_23753(((class_1309)this.entityLivingRef.get()).method_24515()).comp_349();
    }

    public class_5321<class_1937> getDimension() {
        return this.dimension;
    }

    public Boolean getUnderground() {
        return this.underground;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public boolean isPassiveAnimal() {
        return this.passiveAnimal;
    }

    public boolean isNpc() {
        return this.npc;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setCustomName(String customName) {
        this.setCustomName((class_2561)class_2561.method_43470((String)customName));
    }

    public void setCustomName(class_2561 customName) {
        this.customName = customName;
        this.serializedCustomName = class_2561.class_2562.method_10867((class_2561)customName);
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setDisable(boolean disable) {
        this.disabled = disable;
    }

    public void setEntityIconLocation(class_2960 entityIconLocation) {
        this.entityIconLocation = entityIconLocation;
        this.iconLocation = entityIconLocation.toString();
    }

    public List<class_2561> getEntityToolTips() {
        return this.entityToolTips;
    }

    public void setEntityToolTips(List<class_2561> entityToolTips) {
        this.entityToolTips = entityToolTips;
        this.serializedTooltips = entityToolTips.stream().map(class_2561.class_2562::method_10867).collect(Collectors.toList());
    }

    public static class EntityDTOExclusionStrategy
    implements ExclusionStrategy {
        List<String> excludedFields = Lists.newArrayList((Object[])new String[]{"customName", "chunkPos", "entityToolTips", "dimension"});

        public boolean shouldSkipField(FieldAttributes f) {
            if (f.getDeclaringClass().equals(EntityDTO.class)) {
                return this.excludedFields.contains(f.getName());
            }
            return false;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }

    public static class SimpleCacheLoader
    extends CacheLoader<class_1309, EntityDTO> {
        public EntityDTO load(class_1309 entity) throws Exception {
            return new EntityDTO(entity);
        }
    }
}

