/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes.renderlayers;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.waveycapes.CapeRenderer;
import dev.tr7zw.waveycapes.PlayerModelAccess;
import dev.tr7zw.waveycapes.VanillaCapeRenderer;
import dev.tr7zw.waveycapes.WaveyCapesBase;
import dev.tr7zw.waveycapes.delegate.PlayerDelegate;
import dev.tr7zw.waveycapes.support.ModSupport;
import dev.tr7zw.waveycapes.support.SupportManager;
import dev.tr7zw.waveycapes.versionless.CapeHolder;
import dev.tr7zw.waveycapes.versionless.CapeMovement;
import dev.tr7zw.waveycapes.versionless.CapeStyle;
import dev.tr7zw.waveycapes.versionless.WindMode;
import dev.tr7zw.waveycapes.versionless.sim.BasicSimulation;
import dev.tr7zw.waveycapes.versionless.util.Vector3;
import net.minecraft.class_1304;
import net.minecraft.class_1664;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class CustomCapeRenderLayer
extends class_3887<class_742, class_591<class_742>> {
    private static int partCount;
    private class_630[] customCape = new class_630[partCount];
    private static VanillaCapeRenderer vanillaCape;
    private static int scale;

    public CustomCapeRenderLayer(class_3883<class_742, class_591<class_742>> renderLayerParent) {
        super(renderLayerParent);
        partCount = 16;
        this.buildMesh();
    }

    private void buildMesh() {
        this.customCape = new class_630[partCount];
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        for (int i = 0; i < partCount; ++i) {
            partDefinition.method_32117("customCape_" + i, class_5606.method_32108().method_32101(0, (int)((float)i * (16.0f / (float)partCount))).method_32099(-5.0f, (float)i * (16.0f / (float)partCount), -1.0f, 10.0f, 16.0f / (float)partCount, 1.0f, class_5605.field_27715, 1.0f, 0.5f), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        }
        class_630 modelPart = partDefinition.method_32112(64, 64);
        for (int i = 0; i < partCount; ++i) {
            this.customCape[i] = modelPart.method_32086("customCape_" + i);
        }
    }

    public void render(class_4587 poseStack, class_4597 multiBufferSource, int i, class_742 abstractClientPlayer, float f, float g, float delta, float j, float k, float l) {
        if (abstractClientPlayer.method_5767()) {
            return;
        }
        CapeRenderer renderer = this.getCapeRenderer(abstractClientPlayer, multiBufferSource);
        if (renderer == null) {
            return;
        }
        class_1799 itemStack = abstractClientPlayer.method_6118(class_1304.field_6174);
        if (itemStack.method_31574(class_1802.field_8833)) {
            return;
        }
        class_583 class_5832 = this.method_17165();
        if (class_5832 instanceof PlayerModelAccess) {
            PlayerModelAccess pma = (PlayerModelAccess)class_5832;
            if (!pma.getCloak().field_3665) {
                return;
            }
        }
        CapeHolder holder = (CapeHolder)abstractClientPlayer;
        holder.updateSimulation(new PlayerDelegate(abstractClientPlayer), partCount);
        if (WaveyCapesBase.config.capeStyle == CapeStyle.SMOOTH && renderer.vanillaUvValues()) {
            this.renderSmoothCape(poseStack, multiBufferSource, renderer, abstractClientPlayer, delta, i);
        } else {
            class_630[] parts = this.customCape;
            for (int part = 0; part < partCount; ++part) {
                class_630 model = parts[part];
                this.modifyPoseStack(poseStack, abstractClientPlayer, delta, part);
                renderer.render(abstractClientPlayer, part, model, poseStack, multiBufferSource, i, class_4608.field_21444);
                poseStack.method_22909();
            }
        }
    }

    private void renderSmoothCape(class_4587 poseStack, class_4597 multiBufferSource, CapeRenderer capeRenderer, class_742 abstractClientPlayer, float delta, int light) {
        class_4588 bufferBuilder = capeRenderer.getVertexConsumer(multiBufferSource, abstractClientPlayer);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Matrix4f oldPositionMatrix = null;
        for (int part = 0; part < partCount; ++part) {
            this.modifyPoseStack(poseStack, abstractClientPlayer, delta, part);
            if (oldPositionMatrix == null) {
                oldPositionMatrix = poseStack.method_23760().method_23761();
            }
            if (part == 0) {
                CustomCapeRenderLayer.addTopVertex(bufferBuilder, poseStack.method_23760().method_23761(), oldPositionMatrix, 0.3f, 0.0f, 0.0f, -0.3f, 0.0f, -0.06f, part, light);
            }
            if (part == partCount - 1) {
                CustomCapeRenderLayer.addBottomVertex(bufferBuilder, poseStack.method_23760().method_23761(), poseStack.method_23760().method_23761(), 0.3f, (float)(part + 1) * (0.96f / (float)partCount), 0.0f, -0.3f, (float)(part + 1) * (0.96f / (float)partCount), -0.06f, part, light);
            }
            CustomCapeRenderLayer.addLeftVertex(bufferBuilder, poseStack.method_23760().method_23761(), oldPositionMatrix, -0.3f, (float)(part + 1) * (0.96f / (float)partCount), 0.0f, -0.3f, (float)part * (0.96f / (float)partCount), -0.06f, part, light);
            CustomCapeRenderLayer.addRightVertex(bufferBuilder, poseStack.method_23760().method_23761(), oldPositionMatrix, 0.3f, (float)(part + 1) * (0.96f / (float)partCount), 0.0f, 0.3f, (float)part * (0.96f / (float)partCount), -0.06f, part, light);
            CustomCapeRenderLayer.addBackVertex(bufferBuilder, poseStack.method_23760().method_23761(), oldPositionMatrix, 0.3f, (float)(part + 1) * (0.96f / (float)partCount), -0.06f, -0.3f, (float)part * (0.96f / (float)partCount), -0.06f, part, light);
            CustomCapeRenderLayer.addFrontVertex(bufferBuilder, oldPositionMatrix, poseStack.method_23760().method_23761(), 0.3f, (float)(part + 1) * (0.96f / (float)partCount), 0.0f, -0.3f, (float)part * (0.96f / (float)partCount), 0.0f, part, light);
            oldPositionMatrix = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            poseStack.method_22909();
        }
    }

    private void modifyPoseStack(class_4587 poseStack, class_742 abstractClientPlayer, float h, int part) {
        if (WaveyCapesBase.config.capeMovement != CapeMovement.VANILLA) {
            this.modifyPoseStackSimulation(poseStack, abstractClientPlayer, h, part);
            return;
        }
        this.modifyPoseStackVanilla(poseStack, abstractClientPlayer, h, part);
    }

    private void modifyPoseStackSimulation(class_4587 poseStack, class_742 abstractClientPlayer, float delta, int part) {
        BasicSimulation simulation = ((CapeHolder)abstractClientPlayer).getSimulation();
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, 0.125);
        float x = simulation.getPoints().get(part).getLerpX(delta) - simulation.getPoints().get(0).getLerpX(delta);
        if (x > 0.0f) {
            x = 0.0f;
        }
        float y = simulation.getPoints().get(0).getLerpY(delta) - (float)part - simulation.getPoints().get(part).getLerpY(delta);
        float z = simulation.getPoints().get(0).getLerpZ(delta) - simulation.getPoints().get(part).getLerpZ(delta);
        float sidewaysRotationOffset = 0.0f;
        float partRotation = this.getRotation(delta, part, simulation);
        float height = 0.0f;
        if (abstractClientPlayer.method_18276()) {
            height += 25.0f;
            poseStack.method_46416(0.0f, 0.15f, 0.0f);
        }
        float naturalWindSwing = this.getNatrualWindSwing(part, abstractClientPlayer.method_5869());
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(6.0f + height + naturalWindSwing));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(sidewaysRotationOffset / 2.0f));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - sidewaysRotationOffset / 2.0f));
        poseStack.method_46416(-z / (float)partCount, y / (float)partCount, x / (float)partCount);
        poseStack.method_22904(0.0, 0.03, -0.03);
        poseStack.method_46416(0.0f, (float)part * 1.0f / (float)partCount, (float)(part * 0 / partCount));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(-partRotation));
        poseStack.method_46416(0.0f, (float)(-part) * 1.0f / (float)partCount, (float)(-part * 0 / partCount));
        poseStack.method_22904(0.0, -0.03, 0.03);
    }

    private float getRotation(float delta, int part, BasicSimulation simulation) {
        if (part == partCount - 1) {
            return this.getRotation(delta, part - 1, simulation);
        }
        float angle = (float)this.getAngle(simulation.getPoints().get(part).getLerpedPos(delta), simulation.getPoints().get(part + 1).getLerpedPos(delta));
        return angle;
    }

    private double getAngle(Vector3 a, Vector3 b) {
        Vector3 angle = b.subtract(a);
        return Math.toDegrees(Math.atan2(angle.x, angle.y)) + 180.0;
    }

    private void modifyPoseStackVanilla(class_4587 poseStack, class_742 abstractClientPlayer, float h, int part) {
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, 0.125);
        double d = class_3532.method_16436((double)h, (double)abstractClientPlayer.field_7524, (double)abstractClientPlayer.field_7500) - class_3532.method_16436((double)h, (double)abstractClientPlayer.field_6014, (double)abstractClientPlayer.method_23317());
        double e = class_3532.method_16436((double)h, (double)abstractClientPlayer.field_7502, (double)abstractClientPlayer.field_7521) - class_3532.method_16436((double)h, (double)abstractClientPlayer.field_6036, (double)abstractClientPlayer.method_23318());
        double m = class_3532.method_16436((double)h, (double)abstractClientPlayer.field_7522, (double)abstractClientPlayer.field_7499) - class_3532.method_16436((double)h, (double)abstractClientPlayer.field_5969, (double)abstractClientPlayer.method_23321());
        float n = abstractClientPlayer.field_6220 + abstractClientPlayer.field_6283 - abstractClientPlayer.field_6220;
        double o = class_3532.method_15374((float)(n * ((float)Math.PI / 180)));
        double p = -class_3532.method_15362((float)(n * ((float)Math.PI / 180)));
        float height = (float)e * 10.0f;
        height = class_3532.method_15363((float)height, (float)-6.0f, (float)32.0f);
        float swing = (float)(d * o + m * p) * CustomCapeRenderLayer.easeOutSine(1.0f / (float)partCount * (float)part) * 100.0f;
        swing = class_3532.method_15363((float)swing, (float)0.0f, (float)(150.0f * CustomCapeRenderLayer.easeOutSine(1.0f / (float)partCount * (float)part)));
        float sidewaysRotationOffset = (float)(d * p - m * o) * 100.0f;
        sidewaysRotationOffset = class_3532.method_15363((float)sidewaysRotationOffset, (float)-20.0f, (float)20.0f);
        float t = class_3532.method_16439((float)h, (float)abstractClientPlayer.field_7505, (float)abstractClientPlayer.field_7483);
        height += class_3532.method_15374((float)(class_3532.method_16439((float)h, (float)abstractClientPlayer.field_6039, (float)abstractClientPlayer.field_5973) * 6.0f)) * 32.0f * t;
        if (abstractClientPlayer.method_18276()) {
            height += 25.0f;
            poseStack.method_46416(0.0f, 0.15f, 0.0f);
        }
        float naturalWindSwing = this.getNatrualWindSwing(part, abstractClientPlayer.method_5869());
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(6.0f + swing / 2.0f + height + naturalWindSwing));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(sidewaysRotationOffset / 2.0f));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - sidewaysRotationOffset / 2.0f));
    }

    private float getNatrualWindSwing(int part, boolean underwater) {
        long highlightedPart = System.currentTimeMillis() / (long)(underwater ? 9 : 3) % 360L;
        float relativePart = (float)(part + 1) / (float)partCount;
        if (WaveyCapesBase.config.windMode == WindMode.WAVES) {
            return (float)(Math.sin(Math.toRadians(relativePart * 360.0f - (float)highlightedPart)) * 3.0);
        }
        return 0.0f;
    }

    private static void addBackVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
            Matrix4f k = matrix;
            matrix = oldMatrix;
            oldMatrix = k;
        }
        float minU = 0.015625f;
        float maxU = 0.171875f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / (float)partCount;
        maxV = minV + vPerPart * (float)(part + 1);
        bufferBuilder.method_22918(oldMatrix, x1, y2, z1).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(maxU, minV += vPerPart * (float)part).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(oldMatrix, x2, y2, z1).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(minU, minV).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, x2, y1, z2).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(minU, maxV).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, x1, y1, z2).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(maxU, maxV).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
    }

    private static void addFrontVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
            Matrix4f k = matrix;
            matrix = oldMatrix;
            oldMatrix = k;
        }
        float minU = 0.1875f;
        float maxU = 0.34375f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / (float)partCount;
        maxV = minV + vPerPart * (float)(part + 1);
        bufferBuilder.method_22918(oldMatrix, x1, y1, z1).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(minU, maxV).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(oldMatrix, x2, y1, z1).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(maxU, maxV).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, x2, y2, z2).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(maxU, minV += vPerPart * (float)part).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, x1, y2, z2).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(minU, minV).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
    }

    private static void addLeftVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.0f;
        float maxU = 0.015625f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / (float)partCount;
        maxV = minV + vPerPart * (float)(part + 1);
        bufferBuilder.method_22918(matrix, x2, y1, z1).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(minU, maxV).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, x2, y1, z2).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(maxU, maxV).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(oldMatrix, x2, y2, z2).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(maxU, minV += vPerPart * (float)part).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(oldMatrix, x2, y2, z1).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(minU, minV).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
    }

    private static void addRightVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.171875f;
        float maxU = 0.1875f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / (float)partCount;
        maxV = minV + vPerPart * (float)(part + 1);
        bufferBuilder.method_22918(matrix, x2, y1, z2).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(minU, maxV).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, x2, y1, z1).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(maxU, maxV).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(oldMatrix, x2, y2, z1).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(maxU, minV += vPerPart * (float)part).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(oldMatrix, x2, y2, z2).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(minU, minV).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
    }

    private static void addBottomVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.171875f;
        float maxU = 0.328125f;
        float minV = 0.0f;
        float maxV = 0.03125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / (float)partCount;
        maxV = minV + vPerPart * (float)(part + 1);
        bufferBuilder.method_22918(oldMatrix, x1, y2, z2).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(maxU, minV += vPerPart * (float)part).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(oldMatrix, x2, y2, z2).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(minU, minV).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, x2, y1, z1).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(minU, maxV).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, x1, y1, z1).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(maxU, maxV).method_22922(class_4608.field_21444).method_22916(light).method_22914(1.0f, 0.0f, 0.0f).method_1344();
    }

    private static void addTopVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.015625f;
        float maxU = 0.171875f;
        float minV = 0.0f;
        float maxV = 0.03125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / (float)partCount;
        maxV = minV + vPerPart * (float)(part + 1);
        bufferBuilder.method_22918(oldMatrix, x1, y2, z1).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(maxU, maxV).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(oldMatrix, x2, y2, z1).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(minU, maxV).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, x2, y1, z2).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(minU, minV += vPerPart * (float)part).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, x1, y1, z2).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(maxU, minV).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
    }

    private CapeRenderer getCapeRenderer(class_742 abstractClientPlayer, class_4597 multiBufferSource) {
        for (ModSupport support : SupportManager.getSupportedMods()) {
            if (!support.shouldBeUsed(abstractClientPlayer)) continue;
            return support.getRenderer();
        }
        if (abstractClientPlayer.method_52814().comp_1627() == null || abstractClientPlayer.method_5767() || !abstractClientPlayer.method_7348(class_1664.field_7559)) {
            return null;
        }
        CustomCapeRenderLayer.vanillaCape.vertexConsumer = multiBufferSource.getBuffer(class_1921.method_23576((class_2960)abstractClientPlayer.method_52814().comp_1627()));
        return vanillaCape;
    }

    private static float easeOutSine(float x) {
        return class_3532.method_15374((float)(x * (float)Math.PI / 2.0f));
    }

    static {
        vanillaCape = new VanillaCapeRenderer();
        scale = 3600000;
    }
}

