/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_630;
import net.minecraft.class_761;
import net.minecraft.class_918;
import traben.entity_model_features.models.EMFModelPartCustom;
import traben.entity_model_features.models.EMFModelPartRoot;
import traben.entity_model_features.models.EMFModelPartVanilla;
import traben.entity_model_features.models.animation.EMFAnimationHelper;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFVertexConsumer;

public abstract class EMFModelPart
extends class_630 {
    public class_2960 textureOverride;
    private long lastTextureOverride = -1L;

    public EMFModelPart(List<class_630.class_628> cuboids, Map<String, class_630> children) {
        super(cuboids, children);
        this.field_3663 = new ObjectArrayList(cuboids);
        this.field_3661 = new Object2ObjectOpenHashMap(children);
    }

    void renderWithTextureOverride(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.textureOverride == null || this.lastTextureOverride == EMFManager.getInstance().entityRenderCount) {
            this.renderLikeETF(matrices, vertices, light, overlay, red, green, blue, alpha);
        } else if (light != 0xF000F1 && !ETFRenderContext.isIsInSpecialRenderOverlayPhase() && vertices instanceof ETFVertexConsumer) {
            ETFVertexConsumer etfVertexConsumer = (ETFVertexConsumer)vertices;
            class_4597 provider = etfVertexConsumer.etf$getProvider();
            if (provider == null) {
                return;
            }
            class_1921 originalLayer = etfVertexConsumer.etf$getRenderLayer();
            if (originalLayer == null) {
                return;
            }
            this.lastTextureOverride = EMFManager.getInstance().entityRenderCount;
            class_1921 layerModified = EMFAnimationHelper.getLayerFromRecentFactoryOrTranslucent(this.textureOverride);
            class_4588 newConsumer = provider.getBuffer(layerModified);
            this.renderLikeVanilla(matrices, newConsumer, light, overlay, red, green, blue, alpha);
            if (newConsumer instanceof ETFVertexConsumer) {
                ETFVertexConsumer newETFConsumer = (ETFVertexConsumer)newConsumer;
                ETFTexture etfTexture = newETFConsumer.etf$getETFTexture();
                if (etfTexture == null) {
                    return;
                }
                this.etf$renderEmissive(etfTexture, provider, matrices, overlay, red, green, blue, alpha);
                this.etf$renderEnchanted(etfTexture, provider, matrices, light, overlay, red, green, blue, alpha);
            }
            provider.getBuffer(originalLayer);
        }
    }

    void renderLikeVanilla(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!(!this.field_3665 || this.field_3663.isEmpty() && this.field_3661.isEmpty())) {
            matrices.method_22903();
            this.method_22703(matrices);
            if (!this.field_38456) {
                this.method_22702(matrices.method_23760(), vertices, light, overlay, red, green, blue, alpha);
            }
            for (class_630 modelPart : this.field_3661.values()) {
                modelPart.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
            }
            matrices.method_22909();
        }
    }

    void renderLikeETF(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        ETFRenderContext.incrementCurrentModelPartDepth();
        this.renderLikeVanilla(matrices, vertices, light, overlay, red, green, blue, alpha);
        if (ETFRenderContext.getCurrentModelPartDepth() != 1) {
            ETFRenderContext.decrementCurrentModelPartDepth();
        } else {
            ETFVertexConsumer etfVertexConsumer;
            ETFTexture texture;
            if (ETFRenderContext.isCurrentlyRenderingEntity() && vertices instanceof ETFVertexConsumer && (texture = (etfVertexConsumer = (ETFVertexConsumer)vertices).etf$getETFTexture()) != null && (texture.isEmissive() || texture.isEnchanted())) {
                class_4597 provider = etfVertexConsumer.etf$getProvider();
                class_1921 layer = etfVertexConsumer.etf$getRenderLayer();
                if (provider != null && layer != null && this.etf$renderEmissive(texture, provider, matrices, overlay, red, green, blue, alpha) | this.etf$renderEnchanted(texture, provider, matrices, light, overlay, red, green, blue, alpha)) {
                    provider.getBuffer(layer);
                }
            }
            ETFRenderContext.resetCurrentModelPartDepth();
        }
    }

    public void renderBoxes(class_4587 matrices, class_4588 vertices) {
        if (!(!this.field_3665 || this.field_3663.isEmpty() && this.field_3661.isEmpty())) {
            matrices.method_22903();
            this.method_22703(matrices);
            if (!this.field_38456) {
                for (class_630.class_628 cuboid : this.field_3663) {
                    class_238 box = new class_238((double)(cuboid.field_3645 / 16.0f), (double)(cuboid.field_3644 / 16.0f), (double)(cuboid.field_3643 / 16.0f), (double)(cuboid.field_3648 / 16.0f), (double)(cuboid.field_3647 / 16.0f), (double)(cuboid.field_3646 / 16.0f));
                    class_761.method_22982((class_4587)matrices, (class_4588)vertices, (class_238)box, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            for (class_630 modelPart : this.field_3661.values()) {
                if (!(modelPart instanceof EMFModelPart)) continue;
                EMFModelPart emf = (EMFModelPart)modelPart;
                emf.renderBoxes(matrices, vertices);
            }
            matrices.method_22909();
        }
    }

    protected void method_22702(class_4587.class_4665 entry, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        for (class_630.class_628 cuboid : this.field_3663) {
            cuboid.method_32089(entry, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
    }

    public String simplePrintChildren(int depth) {
        StringBuilder mapper = new StringBuilder();
        mapper.append("\n  | ");
        mapper.append("- ".repeat(Math.max(0, depth)));
        mapper.append(this.toStringShort());
        for (class_630 child : this.field_3661.values()) {
            if (!(child instanceof EMFModelPart)) continue;
            EMFModelPart emf = (EMFModelPart)child;
            mapper.append(emf.simplePrintChildren(depth + 1));
        }
        return mapper.toString();
    }

    public String toStringShort() {
        return this.toString();
    }

    public String toString() {
        return "generic emf part";
    }

    public class_630 getVanillaModelPartsOfCurrentState() {
        HashMap<String, class_630> children = new HashMap<String, class_630>();
        for (Map.Entry child : this.field_3661.entrySet()) {
            Object v = child.getValue();
            if (!(v instanceof EMFModelPart)) continue;
            EMFModelPart emf = (EMFModelPart)((Object)v);
            children.put((String)child.getKey(), emf.getVanillaModelPartsOfCurrentState());
        }
        List<class_630.class_628> cubes = this.field_3663.isEmpty() ? List.of(new class_630.class_628(0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 0.0f, 0.0f, Set.of())) : this.field_3663;
        class_630 part = new class_630((List)cubes, children);
        part.method_41918(this.method_41921());
        part.field_3654 = this.field_3654;
        part.field_3674 = this.field_3674;
        part.field_3675 = this.field_3675;
        part.field_3655 = this.field_3655;
        part.field_3656 = this.field_3656;
        part.field_3657 = this.field_3657;
        part.field_37938 = this.field_37938;
        part.field_37939 = this.field_37939;
        part.field_37940 = this.field_37940;
        return part;
    }

    public Object2ReferenceOpenHashMap<String, EMFModelPart> getAllChildPartsAsAnimationMap(String prefixableParents, int variantNum, Map<String, String> optifinePartNameMap) {
        Object object = this;
        if (object instanceof EMFModelPartRoot) {
            EMFModelPartRoot root = (EMFModelPartRoot)((Object)object);
            root.setVariantStateTo(variantNum);
        }
        Object2ReferenceOpenHashMap mapOfAll = new Object2ReferenceOpenHashMap();
        for (class_630 part : this.field_3661.values()) {
            boolean addThis;
            String thisKey;
            if (!(part instanceof EMFModelPart)) continue;
            EMFModelPart part3 = (EMFModelPart)part;
            if (part instanceof EMFModelPartCustom) {
                EMFModelPartCustom partc = (EMFModelPartCustom)part;
                thisKey = partc.id;
                addThis = true;
            } else if (part instanceof EMFModelPartVanilla) {
                EMFModelPartVanilla partv = (EMFModelPartVanilla)part;
                thisKey = partv.name;
                addThis = partv.isOptiFinePartSpecified;
            } else {
                thisKey = "NULL_KEY_NAME";
                addThis = false;
            }
            for (Map.Entry<String, String> entry : optifinePartNameMap.entrySet()) {
                if (!entry.getValue().equals(thisKey)) continue;
                thisKey = entry.getKey();
                break;
            }
            if (addThis) {
                mapOfAll.put((Object)thisKey, (Object)part3);
                if (prefixableParents.isBlank()) {
                    mapOfAll.putAll(part3.getAllChildPartsAsAnimationMap(thisKey, variantNum, optifinePartNameMap));
                    continue;
                }
                mapOfAll.put((Object)(prefixableParents + ":" + thisKey), (Object)part3);
                mapOfAll.putAll(part3.getAllChildPartsAsAnimationMap(prefixableParents + ":" + thisKey, variantNum, optifinePartNameMap));
                continue;
            }
            mapOfAll.putAll(part3.getAllChildPartsAsAnimationMap(prefixableParents, variantNum, optifinePartNameMap));
        }
        return mapOfAll;
    }

    private boolean etf$renderEmissive(ETFTexture texture, class_4597 provider, class_4587 matrices, int overlay, float red, float green, float blue, float alpha) {
        class_2960 emissive = texture.getEmissiveIdentifierOfCurrentState();
        if (emissive != null) {
            boolean textureIsAllowedBrightRender;
            boolean wasAllowed = ETFRenderContext.isAllowedToRenderLayerTextureModify();
            ETFRenderContext.preventRenderLayerTextureModify();
            boolean bl = textureIsAllowedBrightRender = ETFManager.getEmissiveMode() == ETFManager.EmissiveRenderModes.BRIGHT && ETFRenderContext.getCurrentEntity().etf$canBeBright();
            class_4588 emissiveConsumer = provider.getBuffer(textureIsAllowedBrightRender ? class_1921.method_23592((class_2960)emissive, (boolean)true) : (ETFRenderContext.getCurrentEntity().etf$isBlockEntity() ? class_1921.method_23689((class_2960)emissive) : class_1921.method_23580((class_2960)emissive)));
            if (wasAllowed) {
                ETFRenderContext.allowRenderLayerTextureModify();
            }
            ETFRenderContext.startSpecialRenderOverlayPhase();
            this.renderLikeVanilla(matrices, emissiveConsumer, 0xF000F2, overlay, red, green, blue, alpha);
            ETFRenderContext.endSpecialRenderOverlayPhase();
            return true;
        }
        return false;
    }

    private boolean etf$renderEnchanted(ETFTexture texture, class_4597 provider, class_4587 matrices, int light, int overlay, float red, float green, float blue, float alpha) {
        class_2960 enchanted = texture.getEnchantIdentifierOfCurrentState();
        if (enchanted != null) {
            boolean wasAllowed = ETFRenderContext.isAllowedToRenderLayerTextureModify();
            ETFRenderContext.preventRenderLayerTextureModify();
            class_4588 enchantedVertex = class_918.method_27952((class_4597)provider, (class_1921)class_1921.method_25448((class_2960)enchanted), (boolean)false, (boolean)true);
            if (wasAllowed) {
                ETFRenderContext.allowRenderLayerTextureModify();
            }
            ETFRenderContext.startSpecialRenderOverlayPhase();
            this.renderLikeVanilla(matrices, enchantedVertex, light, overlay, red, green, blue, alpha);
            ETFRenderContext.endSpecialRenderOverlayPhase();
            return true;
        }
        return false;
    }

    public static class Animator
    implements Runnable {
        private Runnable animation = null;

        Animator() {
        }

        public Runnable getAnimation() {
            return this.animation;
        }

        public void setAnimation(Runnable animation) {
            this.animation = animation;
        }

        @Override
        public void run() {
            if (this.animation != null) {
                this.animation.run();
            }
        }
    }
}

