/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.animation_math_parser;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Iterator;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.animation_math_parser.MathAction;
import traben.entity_model_features.models.animation.animation_math_parser.MathBinaryExpressionComponent;
import traben.entity_model_features.models.animation.animation_math_parser.MathComponent;
import traben.entity_model_features.models.animation.animation_math_parser.MathConstant;
import traben.entity_model_features.models.animation.animation_math_parser.MathMethod;
import traben.entity_model_features.models.animation.animation_math_parser.MathValue;
import traben.entity_model_features.models.animation.animation_math_parser.MathVariable;
import traben.entity_model_features.utils.EMFUtils;

public class MathExpressionParser
extends MathValue
implements MathComponent {
    public static final MathExpressionParser NULL_EXPRESSION = new MathExpressionParser("null"){

        @Override
        public float get() {
            return Float.NaN;
        }

        @Override
        public boolean isValid() {
            return false;
        }
    };
    public final String originalExpression;
    public boolean wasInvertedBooleanExpression = false;
    public MathComponent optimizedAlternativeToThis = null;
    CalculationList components;
    boolean isNegativeValueNext = false;
    CalculationList componentsDuringCalculate;
    private String caughtExceptionString = null;
    private boolean containsBooleansHigherOrder = false;
    private boolean containsBooleansLowerOrder = false;
    private boolean containsMultiplicationLevel = false;
    private boolean containsAdditionLevel = false;

    private MathExpressionParser(String WARNING_ONLY_FOR_NULL_EXPRESSION) {
        this.originalExpression = WARNING_ONLY_FOR_NULL_EXPRESSION;
        this.components = new CalculationList();
    }

    private MathExpressionParser(String expressionString, boolean isNegative, EMFAnimation calculationInstance, boolean invertBoolean) {
        super(isNegative, calculationInstance);
        this.wasInvertedBooleanExpression = invertBoolean;
        expressionString = expressionString.trim();
        this.originalExpression = expressionString = expressionString.replaceAll("\\s*", "");
        this.components = new CalculationList();
        try {
            Object variable;
            StringBuilder rollingRead = new StringBuilder();
            ArrayList<Character> charList = new ArrayList<Character>();
            for (char ch : expressionString.toCharArray()) {
                charList.add(Character.valueOf(ch));
            }
            Iterator charIterator = charList.iterator();
            Character firstBooleanChar = null;
            while (charIterator.hasNext()) {
                char ch = ((Character)charIterator.next()).charValue();
                MathAction action = MathAction.getAction(ch);
                if (firstBooleanChar != null) {
                    if (action == MathAction.BOOLEAN_CHAR) {
                        action = switch ("" + firstBooleanChar + ch) {
                            case "==" -> MathAction.EQUALS;
                            case "!=" -> MathAction.NOT_EQUALS;
                            case "&&" -> MathAction.AND;
                            case "||" -> MathAction.OR;
                            case ">=" -> MathAction.LARGER_THAN_OR_EQUALS;
                            case "<=" -> MathAction.SMALLER_THAN_OR_EQUALS;
                            default -> throw new MathComponent.EMFMathException("ERROR: with boolean processing for operator [" + firstBooleanChar + ch + "] for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "].");
                        };
                        this.components.add(action);
                        ch = ((Character)charIterator.next()).charValue();
                        action = MathAction.getAction(ch);
                    } else if (firstBooleanChar.charValue() == '!') {
                        rollingRead.append('!');
                    } else {
                        this.components.add(switch (firstBooleanChar.charValue()) {
                            case '=' -> MathAction.EQUALS;
                            case '&' -> MathAction.AND;
                            case '|' -> MathAction.OR;
                            case '<' -> MathAction.SMALLER_THAN;
                            case '>' -> MathAction.LARGER_THAN;
                            default -> throw new MathComponent.EMFMathException("ERROR: with boolean processing for operator [" + firstBooleanChar + "] for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "].");
                        });
                    }
                    firstBooleanChar = null;
                }
                if (action == MathAction.BOOLEAN_CHAR) {
                    firstBooleanChar = Character.valueOf(ch);
                }
                if (action == MathAction.SUBTRACT && (this.components.isEmpty() && rollingRead.isEmpty() || !this.components.isEmpty() && this.components.getLast() instanceof MathAction && rollingRead.isEmpty())) {
                    this.isNegativeValueNext = true;
                    continue;
                }
                if (action == MathAction.NONE) {
                    rollingRead.append(ch);
                    continue;
                }
                if (action == MathAction.OPEN_BRACKET) {
                    String functionName = rollingRead.toString();
                    rollingRead = new StringBuilder();
                    StringBuilder bracketContents = new StringBuilder();
                    int bracketsCount = 0;
                    while (charIterator.hasNext()) {
                        char ch2 = ((Character)charIterator.next()).charValue();
                        if (ch2 == '(') {
                            bracketContents.append(ch2);
                            ++bracketsCount;
                            continue;
                        }
                        if (ch2 == ')') {
                            if (bracketsCount == 0) break;
                            bracketContents.append(ch2);
                            --bracketsCount;
                            continue;
                        }
                        bracketContents.append(ch2);
                    }
                    if (functionName.isEmpty() || "!".equals(functionName)) {
                        MathComponent brackets = MathExpressionParser.getOptimizedExpression(bracketContents.toString(), this.getNegativeNext(), this.calculationInstance, "!".equals(functionName));
                        this.components.add(brackets);
                        continue;
                    }
                    MathComponent method = MathMethod.getOptimizedExpression(functionName, bracketContents.toString(), this.getNegativeNext(), this.calculationInstance);
                    this.components.add(method);
                    continue;
                }
                String read2 = rollingRead.toString();
                rollingRead = new StringBuilder();
                if (!read2.isEmpty()) {
                    Float asNumber = null;
                    try {
                        asNumber = Float.valueOf(Float.parseFloat(read2));
                    }
                    catch (NumberFormatException bracketsCount) {
                        // empty catch block
                    }
                    MathComponent variable2 = asNumber == null ? MathVariable.getOptimizedVariable(read2, this.getNegativeNext(), this.calculationInstance) : new MathConstant(asNumber.floatValue(), this.getNegativeNext());
                    this.components.add(variable2);
                }
                if (!rollingRead.isEmpty() || action == MathAction.BOOLEAN_CHAR) continue;
                this.components.add(action);
            }
            if (!rollingRead.isEmpty()) {
                String read = rollingRead.toString();
                Float asNumber = null;
                try {
                    asNumber = Float.valueOf(Float.parseFloat(read));
                }
                catch (NumberFormatException read2) {
                    // empty catch block
                }
                variable = asNumber == null ? MathVariable.getOptimizedVariable(read, this.getNegativeNext(), this.calculationInstance) : new MathConstant(asNumber.floatValue(), this.getNegativeNext());
                this.components.add(variable);
            }
            if (this.components.isEmpty()) {
                throw new MathComponent.EMFMathException("ERROR: math components found to be empty for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "]");
            }
            CalculationList newComponents = new CalculationList();
            MathComponent lastComponent = null;
            variable = this.components.iterator();
            while (variable.hasNext()) {
                MathComponent component = (MathComponent)variable.next();
                if (lastComponent instanceof MathAction && component instanceof MathAction) {
                    MathAction action = (MathAction)component;
                    if (action != MathAction.ADD) {
                        newComponents.add(component);
                    }
                } else {
                    newComponents.add(component);
                }
                lastComponent = component;
            }
            if (newComponents.size() != this.components.size()) {
                this.components = newComponents;
            }
            if (this.components.size() == 1) {
                MathComponent comp = this.components.getLast();
                if (comp instanceof MathConstant) {
                    MathConstant constnt = (MathConstant)comp;
                    if (isNegative) {
                        comp = new MathConstant(-constnt.get());
                    }
                } else if (comp instanceof MathValue) {
                    MathValue val = (MathValue)comp;
                    val.isNegative = isNegative != val.isNegative;
                }
                this.optimizedAlternativeToThis = comp;
            } else {
                if (this.components.get(0) == MathAction.ADD) {
                    this.components.remove(0);
                }
                this.containsBooleansHigherOrder = this.components.contains(MathAction.EQUALS) || this.components.contains(MathAction.LARGER_THAN) || this.components.contains(MathAction.LARGER_THAN_OR_EQUALS) || this.components.contains(MathAction.SMALLER_THAN) || this.components.contains(MathAction.SMALLER_THAN_OR_EQUALS) || this.components.contains(MathAction.NOT_EQUALS);
                this.containsBooleansLowerOrder = this.components.contains(MathAction.AND) || this.components.contains(MathAction.OR);
                this.containsMultiplicationLevel = this.components.contains(MathAction.MULTIPLY) || this.components.contains(MathAction.DIVIDE) || this.components.contains(MathAction.DIVISION_REMAINDER);
                this.containsAdditionLevel = this.components.contains(MathAction.ADD) || this.components.contains(MathAction.SUBTRACT);
                this.isValid();
            }
        }
        catch (MathComponent.EMFMathException e) {
            this.caughtExceptionString = e.toString();
        }
        catch (Exception e) {
            this.caughtExceptionString = "EMF animation ERROR: for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "] cause [" + e + "].";
            e.printStackTrace();
        }
    }

    public static MathComponent getOptimizedExpression(String expressionString, boolean isNegative, EMFAnimation calculationInstance) {
        return MathExpressionParser.getOptimizedExpression(expressionString, isNegative, calculationInstance, false);
    }

    public static MathComponent getOptimizedExpression(String expressionString, boolean isNegative, EMFAnimation calculationInstance, boolean invertBoolean) {
        MathExpressionParser expression = new MathExpressionParser(expressionString, isNegative, calculationInstance, invertBoolean);
        if (expression.optimizedAlternativeToThis == null) {
            if (expression.isValid()) {
                return expression;
            }
            EMFUtils.logWarn("null animation expression: [" + expressionString + "]");
            return NULL_EXPRESSION;
        }
        final MathComponent optimized = expression.optimizedAlternativeToThis;
        if (expression.wasInvertedBooleanExpression) {
            return new MathValue(){

                @Override
                public float get() {
                    return optimized.get() == 1.0f ? 0.0f : 1.0f;
                }

                @Override
                public MathValue.ValueSupplier getSupplier() {
                    return null;
                }
            };
        }
        return optimized;
    }

    public boolean isValid() {
        if (this.caughtExceptionString != null) {
            EMFUtils.logWarn(this.caughtExceptionString);
            return false;
        }
        if (Double.isNaN(this.validateCalculationAndOptimize())) {
            EMFUtils.logWarn("result was NaN, expression not valid: " + this.originalExpression);
            return false;
        }
        return true;
    }

    private boolean getNegativeNext() {
        boolean neg = this.isNegativeValueNext;
        this.isNegativeValueNext = false;
        return neg;
    }

    public float validateCalculationAndOptimize() {
        try {
            ObjectListIterator compIteratorB;
            CalculationList newComponentsB;
            MathComponent next;
            MathComponent last;
            MathAction action;
            MathComponent component;
            this.componentsDuringCalculate = new CalculationList(this.components);
            if (this.containsMultiplicationLevel) {
                CalculationList newComponents = new CalculationList();
                ObjectListIterator compIterator = this.componentsDuringCalculate.iterator();
                while (compIterator.hasNext()) {
                    component = (MathComponent)compIterator.next();
                    if (component instanceof MathAction) {
                        action = (MathAction)component;
                        if (action == MathAction.MULTIPLY) {
                            last = newComponents.getLast();
                            next = (MathComponent)compIterator.next();
                            newComponents.removeLast();
                            newComponents.add(MathBinaryExpressionComponent.getOptimizedExpression(last, action, next));
                            continue;
                        }
                        if (action == MathAction.DIVIDE) {
                            last = newComponents.getLast();
                            next = (MathComponent)compIterator.next();
                            newComponents.removeLast();
                            newComponents.add(MathBinaryExpressionComponent.getOptimizedExpression(last, action, next));
                            continue;
                        }
                        if (action == MathAction.DIVISION_REMAINDER) {
                            last = newComponents.getLast();
                            next = (MathComponent)compIterator.next();
                            newComponents.removeLast();
                            newComponents.add(MathBinaryExpressionComponent.getOptimizedExpression(last, action, next));
                            continue;
                        }
                        newComponents.add(component);
                        continue;
                    }
                    newComponents.add(component);
                }
                this.componentsDuringCalculate = newComponents;
            }
            if (this.containsAdditionLevel) {
                CalculationList newComponents2 = new CalculationList();
                ObjectListIterator compIterator2 = this.componentsDuringCalculate.iterator();
                while (compIterator2.hasNext()) {
                    component = (MathComponent)compIterator2.next();
                    if (component instanceof MathAction) {
                        action = (MathAction)component;
                        if (action == MathAction.ADD) {
                            last = newComponents2.getLast();
                            next = (MathComponent)compIterator2.next();
                            newComponents2.removeLast();
                            newComponents2.add(MathBinaryExpressionComponent.getOptimizedExpression(last, action, next));
                            continue;
                        }
                        if (action == MathAction.SUBTRACT) {
                            last = newComponents2.getLast();
                            next = (MathComponent)compIterator2.next();
                            newComponents2.removeLast();
                            newComponents2.add(MathBinaryExpressionComponent.getOptimizedExpression(last, action, next));
                            continue;
                        }
                        newComponents2.add(component);
                        continue;
                    }
                    newComponents2.add(component);
                }
                this.componentsDuringCalculate = newComponents2;
            }
            if (this.containsBooleansHigherOrder) {
                newComponentsB = new CalculationList();
                compIteratorB = this.componentsDuringCalculate.iterator();
                block10: while (compIteratorB.hasNext()) {
                    component = (MathComponent)compIteratorB.next();
                    if (component instanceof MathAction) {
                        action = (MathAction)component;
                        switch (action) {
                            case EQUALS: 
                            case SMALLER_THAN_OR_EQUALS: 
                            case SMALLER_THAN: 
                            case LARGER_THAN_OR_EQUALS: 
                            case LARGER_THAN: 
                            case NOT_EQUALS: {
                                last = newComponentsB.getLast();
                                next = (MathComponent)compIteratorB.next();
                                newComponentsB.removeLast();
                                newComponentsB.add(MathBinaryExpressionComponent.getOptimizedExpression(last, action, next));
                                continue block10;
                            }
                        }
                        newComponentsB.add(component);
                        continue;
                    }
                    newComponentsB.add(component);
                }
                this.componentsDuringCalculate = newComponentsB;
            }
            if (this.containsBooleansLowerOrder) {
                newComponentsB = new CalculationList();
                compIteratorB = this.componentsDuringCalculate.iterator();
                block11: while (compIteratorB.hasNext()) {
                    component = (MathComponent)compIteratorB.next();
                    if (component instanceof MathAction) {
                        action = (MathAction)component;
                        switch (action) {
                            case AND: 
                            case OR: {
                                last = newComponentsB.getLast();
                                next = (MathComponent)compIteratorB.next();
                                newComponentsB.removeLast();
                                newComponentsB.add(MathBinaryExpressionComponent.getOptimizedExpression(last, action, next));
                                continue block11;
                            }
                        }
                        newComponentsB.add(component);
                        continue;
                    }
                    newComponentsB.add(component);
                }
                this.componentsDuringCalculate = newComponentsB;
            }
            if (this.componentsDuringCalculate.size() == 1) {
                float result = this.componentsDuringCalculate.getLast().get();
                if (Double.isNaN(result)) {
                    System.out.println(" result was NaN in [" + this.calculationInstance.modelName + "] for expression: " + this.originalExpression + " as " + this.components);
                } else {
                    this.optimizedAlternativeToThis = this.componentsDuringCalculate.getLast();
                    MathComponent mathComponent = this.optimizedAlternativeToThis;
                    if (mathComponent instanceof MathValue) {
                        MathValue value = (MathValue)mathComponent;
                        value.makeNegative(this.isNegative);
                    }
                }
                return result;
            }
            System.out.println("ERROR: calculation did not result in 1 component, found: " + this.componentsDuringCalculate + " in [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].");
            System.out.println("\texpression was [" + this.originalExpression + "].");
        }
        catch (Exception e) {
            System.out.println("EMF animation ERROR: expression error in [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "] caused by [" + e + "].");
        }
        return Float.NaN;
    }

    @Override
    public MathValue.ValueSupplier getSupplier() {
        return this::get;
    }

    @Override
    public float get() {
        EMFUtils.logWarn("this should not happen this object should have been optimized");
        float value = this.wasInvertedBooleanExpression ? (super.get() == 1.0f ? 0.0f : 1.0f) : super.get();
        return value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        ObjectListIterator objectListIterator = this.components.iterator();
        while (objectListIterator.hasNext()) {
            MathComponent comp = (MathComponent)objectListIterator.next();
            builder.append(comp.toString()).append(" ");
        }
        builder.append("}");
        return builder.toString();
    }

    private static class CalculationList
    extends ObjectArrayList<MathComponent> {
        public CalculationList(CalculationList components) {
            super((ObjectList)components);
        }

        public CalculationList() {
        }

        public MathComponent getLast() {
            return (MathComponent)super.get(this.size - 1);
        }

        public void removeLast() {
            super.remove(this.size - 1);
        }
    }
}

