/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.client.screen.ScreenKeyEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.inventoryessentials.InventoryEssentials;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.client.ClientOnlyInventoryControls;
import net.blay09.mods.inventoryessentials.client.CreativeInventoryControls;
import net.blay09.mods.inventoryessentials.client.InventoryControls;
import net.blay09.mods.inventoryessentials.client.ModKeyMappings;
import net.blay09.mods.inventoryessentials.client.ServerSupportedInventoryControls;
import net.blay09.mods.inventoryessentials.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.inventoryessentials.mixin.CreativeModeInventoryScreenAccessor;
import net.minecraft.class_1661;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class InventoryEssentialsClient {
    private static final InventoryControls clientOnlyControls = new ClientOnlyInventoryControls();
    private static final InventoryControls creativeControls = new CreativeInventoryControls();
    private static final InventoryControls serverSupportedControls = new ServerSupportedInventoryControls();
    private static class_1735 lastDragHoverSlot;

    public static void initialize() {
        ModKeyMappings.initialize(BalmClient.getKeyMappings());
        Balm.getEvents().onEvent(ScreenMouseEvent.Drag.Pre.class, InventoryEssentialsClient::onMouseDrag);
        Balm.getEvents().onEvent(ScreenMouseEvent.Click.Pre.class, InventoryEssentialsClient::onMouseClick);
        Balm.getEvents().onEvent(ScreenKeyEvent.Press.Pre.class, InventoryEssentialsClient::onKeyPress);
    }

    private static InventoryControls getInventoryControls(class_465<?> screen) {
        if (screen instanceof CreativeModeInventoryScreenAccessor) {
            return creativeControls;
        }
        return InventoryEssentials.isServerSideInstalled && !InventoryEssentialsConfig.getActive().forceClientImplementation ? serverSupportedControls : clientOnlyControls;
    }

    private static boolean shouldHandleInput(class_465<?> screen) {
        class_1735 hoverSlot = ((AbstractContainerScreenAccessor)screen).getHoveredSlot();
        if (hoverSlot instanceof class_1734) {
            return false;
        }
        if (screen instanceof CreativeModeInventoryScreenAccessor) {
            CreativeModeInventoryScreenAccessor accessor = (CreativeModeInventoryScreenAccessor)screen;
            return hoverSlot == null || hoverSlot.field_7871 instanceof class_1661 || hoverSlot.field_7871 != accessor.getCONTAINER();
        }
        return true;
    }

    public static void onMouseDrag(ScreenMouseEvent.Drag.Pre event) {
        if (BalmClient.getKeyMappings().isActiveAndKeyDown(ModKeyMappings.keyDragTransfer)) {
            class_437 class_4372 = event.getScreen();
            if (class_4372 instanceof class_465) {
                class_465 screen = (class_465)class_4372;
                class_1735 hoverSlot = ((AbstractContainerScreenAccessor)screen).getHoveredSlot();
                if (hoverSlot == null || !InventoryEssentialsClient.shouldHandleInput(screen)) {
                    return;
                }
                if (hoverSlot.method_7681() && hoverSlot != lastDragHoverSlot) {
                    InventoryControls controls = InventoryEssentialsClient.getInventoryControls(screen);
                    controls.dragTransfer(screen, hoverSlot);
                    lastDragHoverSlot = hoverSlot;
                }
            }
        } else {
            lastDragHoverSlot = null;
        }
    }

    public static void onMouseClick(ScreenMouseEvent.Click.Pre event) {
        if (InventoryEssentialsClient.onInput(event.getScreen(), class_3675.class_307.field_1672.method_1447(event.getButton()), event.getMouseX(), event.getMouseY())) {
            event.setCanceled(true);
        }
    }

    public static void onKeyPress(ScreenKeyEvent.Press.Pre event) {
        if (InventoryEssentialsClient.onInput(event.getScreen(), class_3675.method_15985((int)event.getKey(), (int)event.getScanCode()), 0.0, 0.0)) {
            event.setCanceled(true);
        }
    }

    public static boolean onInput(class_437 screen, class_3675.class_306 key, double mouseX, double mouseY) {
        if (screen instanceof class_465) {
            class_465 containerScreen = (class_465)screen;
            AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)containerScreen;
            class_1735 hoverSlot = accessor.getHoveredSlot();
            if (!InventoryEssentialsClient.shouldHandleInput(containerScreen)) {
                return false;
            }
            InventoryControls controls = InventoryEssentialsClient.getInventoryControls(containerScreen);
            if (BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBulkTransfer, key)) {
                return hoverSlot != null && controls.bulkTransferByType(containerScreen, hoverSlot);
            }
            if (BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keySingleTransfer, key)) {
                return hoverSlot != null && controls.singleTransfer(containerScreen, hoverSlot);
            }
            if (BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBulkTransferAll, key)) {
                return hoverSlot != null && controls.bulkTransferAll(containerScreen, hoverSlot);
            }
            if (BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyScreenBulkDrop, key)) {
                boolean clickedOutside = accessor.callHasClickedOutside(mouseX, mouseY, accessor.getLeftPos(), accessor.getTopPos(), key.method_1444());
                return clickedOutside && controls.dropByType(containerScreen, containerScreen.method_17577().method_34255());
            }
            if (BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBulkDrop, key)) {
                return hoverSlot != null && controls.dropByType(containerScreen, hoverSlot);
            }
        }
        return false;
    }
}

