/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.config.v2.api.autogen;

import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigField;
import dev.isxander.yacl3.config.v2.api.autogen.CustomDescription;
import dev.isxander.yacl3.config.v2.api.autogen.CustomImage;
import dev.isxander.yacl3.config.v2.api.autogen.CustomName;
import dev.isxander.yacl3.config.v2.api.autogen.OptionAccess;
import dev.isxander.yacl3.config.v2.api.autogen.OptionFactory;
import dev.isxander.yacl3.config.v2.impl.FieldBackedBinding;
import dev.isxander.yacl3.config.v2.impl.autogen.AutoGenUtils;
import dev.isxander.yacl3.config.v2.impl.autogen.EmptyCustomImageFactory;
import dev.isxander.yacl3.config.v2.impl.autogen.YACLAutoGenException;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleOptionFactory<A extends Annotation, T>
implements OptionFactory<A, T> {
    @Override
    public Option<T> createOption(A annotation, ConfigField<T> field, OptionAccess optionAccess) {
        Option<Object> option = Option.createBuilder().name((class_2561)this.name(annotation, field, optionAccess)).description(v -> this.description(v, annotation, field, optionAccess).build()).binding(new FieldBackedBinding<T>(field.access(), field.defaultAccess())).controller(opt -> {
            ControllerBuilder<T> builder = this.createController(annotation, field, optionAccess, (Option<T>)opt);
            AutoGenUtils.addCustomFormatterToController(builder, field.access());
            return builder;
        }).available(this.available(annotation, field, optionAccess)).flags(this.flags(annotation, field, optionAccess)).listener((opt, v) -> this.listener(annotation, field, optionAccess, (Option<T>)opt, (T)v)).build();
        this.postInit(annotation, field, optionAccess, option);
        return option;
    }

    protected abstract ControllerBuilder<T> createController(A var1, ConfigField<T> var2, OptionAccess var3, Option<T> var4);

    protected class_5250 name(A annotation, ConfigField<T> field, OptionAccess storage) {
        Optional<CustomName> customName = field.access().getAnnotation(CustomName.class);
        return class_2561.method_43471((String)customName.map(CustomName::value).orElse(this.getTranslationKey(field, null)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected OptionDescription.Builder description(T value, A annotation, ConfigField<T> field, OptionAccess storage) {
        OptionDescription.Builder builder = OptionDescription.createBuilder();
        Object key = this.getTranslationKey(field, "desc");
        if (class_2477.method_10517().method_4678((String)key)) {
            builder.text(new class_2561[]{class_2561.method_43471((String)key)});
        } else {
            key = (String)key + ".";
            int i = 1;
            while (class_2477.method_10517().method_4678((String)key + i)) {
                builder.text(new class_2561[]{class_2561.method_43471((String)((String)key + i))});
                ++i;
            }
        }
        field.access().getAnnotation(CustomDescription.class).ifPresent(customDescription -> {
            for (String line : customDescription.value()) {
                builder.text(new class_2561[]{class_2561.method_43471((String)line)});
            }
        });
        Optional<CustomImage> imageOverrideOpt = field.access().getAnnotation(CustomImage.class);
        if (imageOverrideOpt.isPresent()) {
            String extension;
            CustomImage imageOverride = imageOverrideOpt.get();
            if (!imageOverride.factory().equals(EmptyCustomImageFactory.class)) {
                CustomImage.CustomImageFactory<?> imageFactory;
                try {
                    imageFactory = AutoGenUtils.constructNoArgsClass(imageOverride.factory(), () -> "'%s': The factory class on @OverrideImage has no no-args constructor.".formatted(field.access().name()), () -> "'%s': Failed to instantiate factory class %s.".formatted(field.access().name(), imageOverride.factory().getName()));
                }
                catch (ClassCastException e) {
                    throw new YACLAutoGenException("'%s': The factory class on @OverrideImage is of incorrect type. Expected %s, got %s.".formatted(field.access().name(), field.access().type().getTypeName(), imageOverride.factory().getTypeParameters()[0].getName()));
                }
                builder.customImage((CompletableFuture<Optional<ImageRenderer>>)imageFactory.createImage(value, field, storage).thenApply(Optional::of));
                return builder;
            }
            if (imageOverride.value().isEmpty()) throw new YACLAutoGenException("'%s': @OverrideImage has no value or factory class.".formatted(field.access().name()));
            String path = imageOverride.value();
            class_2960 imageLocation = new class_2960(field.parent().id().method_12836(), path);
            switch (extension = path.substring(path.lastIndexOf(46) + 1)) {
                case "png": 
                case "jpg": 
                case "jpeg": {
                    builder.image(imageLocation, imageOverride.width(), imageOverride.height());
                    return builder;
                }
                case "webp": {
                    builder.webpImage(imageLocation);
                    return builder;
                }
                case "gif": {
                    builder.gifImage(imageLocation);
                    return builder;
                }
                default: {
                    throw new YACLAutoGenException("'%s': Invalid image extension '%s' on @OverrideImage. Expected: ('png','jpg','webp','gif')".formatted(field.access().name(), extension));
                }
            }
        }
        Object imagePath = "textures/yacl3/" + field.parent().id().method_12832() + "/" + field.access().name() + ".webp";
        imagePath = ((String)imagePath).toLowerCase().replaceAll("[^a-z0-9/._:-]", "_");
        class_2960 imageLocation = new class_2960(field.parent().id().method_12836(), (String)imagePath);
        if (!class_310.method_1551().method_1478().method_14486(imageLocation).isPresent()) return builder;
        builder.webpImage(imageLocation);
        return builder;
    }

    protected boolean available(A annotation, ConfigField<T> field, OptionAccess storage) {
        return true;
    }

    protected Set<OptionFlag> flags(A annotation, ConfigField<T> field, OptionAccess storage) {
        return Set.of();
    }

    protected void listener(A annotation, ConfigField<T> field, OptionAccess storage, Option<T> option, T value) {
    }

    protected void postInit(A annotation, ConfigField<T> field, OptionAccess storage, Option<T> option) {
    }

    protected String getTranslationKey(ConfigField<T> field, @Nullable String suffix) {
        Object key = "yacl3.config.%s.%s".formatted(field.parent().id().toString(), field.access().name());
        if (suffix != null) {
            key = (String)key + "." + suffix;
        }
        return key;
    }
}

