/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.faster_texture_stitching;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1055;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.textures.StbStitcher;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1055.class})
@ClientOnlyMixin
public class StitcherMixin<T extends class_1055.class_7769> {
    @Shadow
    @Final
    private List<class_1055.class_1056<T>> field_5237;
    @Shadow
    private int field_5242;
    @Shadow
    private int field_5241;
    @Shadow
    @Final
    private static Comparator<class_1055.class_1056<?>> field_18030;
    private List<StbStitcher.LoadableSpriteInfo<T>> loadableSpriteInfos;

    @Inject(method={"stitch"}, at={@At(value="HEAD")}, cancellable=true)
    private void stitchFast(CallbackInfo ci) {
        if (!ModernFixPlatformHooks.INSTANCE.isLoadingNormally()) {
            ModernFix.LOGGER.error("Using vanilla stitcher implementation due to invalid loading state");
            return;
        }
        ci.cancel();
        ObjectArrayList holderList = new ObjectArrayList(this.field_5237);
        holderList.sort(field_18030);
        class_1055.class_1056[] aholder = (class_1055.class_1056[])holderList.toArray((Object[])new class_1055.class_1056[0]);
        Pair packingInfo = StbStitcher.packRects(aholder);
        this.field_5242 = (Integer)((Pair)packingInfo.getFirst()).getFirst();
        this.field_5241 = (Integer)((Pair)packingInfo.getFirst()).getSecond();
        this.loadableSpriteInfos = (List)packingInfo.getSecond();
    }

    @Inject(method={"gatherSprites"}, at={@At(value="HEAD")}, cancellable=true)
    private void gatherSpritesFast(class_1055.class_4726<T> spriteLoader, CallbackInfo ci) {
        if (!ModernFixPlatformHooks.INSTANCE.isLoadingNormally()) {
            return;
        }
        ci.cancel();
        for (StbStitcher.LoadableSpriteInfo<T> info : this.loadableSpriteInfos) {
            spriteLoader.load(info.info, info.x, info.y);
        }
    }
}

