/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin.vertices;

import java.nio.ByteBuffer;
import net.caffeinemc.mods.sodium.api.vertex.attributes.CommonVertexAttribute;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatDescription;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatRegistry;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisCommonVertexAttributes;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.vertices.BlockSensitiveBufferBuilder;
import net.coderbot.iris.vertices.BufferBuilderPolygonView;
import net.coderbot.iris.vertices.ExtendedDataHelper;
import net.coderbot.iris.vertices.ExtendingBufferBuilder;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormI8;
import net.coderbot.iris.vertices.NormalHelper;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_4584;
import net.minecraft.class_4585;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_287.class})
public abstract class MixinBufferBuilder
extends class_4585
implements class_4584,
BlockSensitiveBufferBuilder,
ExtendingBufferBuilder {
    @Unique
    private boolean extending;
    @Unique
    private boolean iris$shouldNotExtend = false;
    @Unique
    private boolean iris$isTerrain = false;
    @Unique
    private int vertexCount;
    @Unique
    private final BufferBuilderPolygonView polygon = new BufferBuilderPolygonView();
    @Unique
    private final Vector3f normal = new Vector3f();
    @Unique
    private boolean injectNormalAndUV1;
    @Unique
    private short currentBlock;
    @Unique
    private short currentRenderType;
    @Unique
    private int currentLocalPosX;
    @Unique
    private int currentLocalPosY;
    @Unique
    private int currentLocalPosZ;
    @Shadow
    private boolean field_21594;
    @Shadow
    private boolean field_21595;
    @Shadow
    private ByteBuffer field_1555;
    @Shadow
    private class_293.class_5596 field_1567;
    @Shadow
    private class_293 field_1565;
    @Shadow
    private int field_20884;
    @Shadow
    @Nullable
    private class_296 field_1558;
    @Unique
    private int uv1Offset;
    @Unique
    private int normalOffset;
    @Unique
    private int tangentOffset;
    @Unique
    private int midTexOffset;
    @Unique
    private int midBlockOffset;
    @Unique
    private int blockIdOffset;
    @Unique
    private int entityIdOffset;

    @Shadow
    public abstract void method_1328(class_293.class_5596 var1, class_293 var2);

    @Shadow
    protected abstract void method_23918(class_293 var1);

    @Override
    public void iris$beginWithoutExtending(class_293.class_5596 class_55962, class_293 class_2932) {
        this.iris$shouldNotExtend = true;
        this.method_1328(class_55962, class_2932);
        this.iris$shouldNotExtend = false;
    }

    @Inject(method={"begin"}, at={@At(value="HEAD")})
    private void iris$onBegin(class_293.class_5596 class_55962, class_293 class_2932, CallbackInfo callbackInfo) {
        boolean bl = !this.iris$shouldNotExtend && BlockRenderingSettings.INSTANCE.shouldUseExtendedVertexFormat();
        this.extending = bl && (class_2932 == class_290.field_1590 || class_2932 == class_290.field_1580 || class_2932 == class_290.field_20888);
        this.vertexCount = 0;
        if (this.extending) {
            this.injectNormalAndUV1 = class_2932 == class_290.field_20888;
        }
    }

    @Inject(method={"begin"}, at={@At(value="RETURN")})
    private void iris$afterBegin(class_293.class_5596 class_55962, class_293 class_2932, CallbackInfo callbackInfo) {
        if (this.extending) {
            if (class_2932 == class_290.field_1590) {
                this.method_23918(IrisVertexFormats.TERRAIN);
                this.iris$isTerrain = true;
            } else if (class_2932 == class_290.field_20888) {
                this.method_23918(IrisVertexFormats.GLYPH);
                this.iris$isTerrain = false;
            } else {
                this.method_23918(IrisVertexFormats.ENTITY);
                this.iris$isTerrain = false;
            }
            this.field_1558 = (class_296)this.field_1565.method_1357().get(0);
        }
    }

    @ModifyArg(method={"begin"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/BufferBuilder;switchFormat(Lcom/mojang/blaze3d/vertex/VertexFormat;)V"))
    private class_293 iris$afterBeginSwitchFormat(class_293 class_2932) {
        if (this.extending) {
            if (this.field_1565 == class_290.field_1590) {
                this.method_23918(IrisVertexFormats.TERRAIN);
                this.iris$isTerrain = true;
            } else if (this.field_1565 == class_290.field_20888) {
                this.method_23918(IrisVertexFormats.GLYPH);
                this.iris$isTerrain = false;
            } else {
                this.method_23918(IrisVertexFormats.ENTITY);
                this.iris$isTerrain = false;
            }
        }
        return class_2932;
    }

    @Inject(method={"discard()V"}, at={@At(value="HEAD")})
    private void iris$onDiscard(CallbackInfo callbackInfo) {
        this.extending = false;
        this.injectNormalAndUV1 = false;
        this.vertexCount = 0;
    }

    @Inject(method={"switchFormat"}, at={@At(value="RETURN")})
    private void iris$preventHardcodedVertexWriting(class_293 class_2932, CallbackInfo callbackInfo) {
        if (!this.extending) {
            return;
        }
        VertexFormatDescription vertexFormatDescription = VertexFormatRegistry.instance().get(class_2932);
        if (vertexFormatDescription.containsElement(CommonVertexAttribute.OVERLAY)) {
            this.uv1Offset = vertexFormatDescription.getElementOffset(CommonVertexAttribute.OVERLAY);
        }
        if (vertexFormatDescription.containsElement(CommonVertexAttribute.NORMAL)) {
            this.normalOffset = vertexFormatDescription.getElementOffset(CommonVertexAttribute.NORMAL);
        }
        if (vertexFormatDescription.containsElement(IrisCommonVertexAttributes.TANGENT)) {
            this.tangentOffset = vertexFormatDescription.getElementOffset(IrisCommonVertexAttributes.TANGENT);
        }
        if (vertexFormatDescription.containsElement(IrisCommonVertexAttributes.MID_TEX_COORD)) {
            this.midTexOffset = vertexFormatDescription.getElementOffset(IrisCommonVertexAttributes.MID_TEX_COORD);
        }
        if (vertexFormatDescription.containsElement(IrisCommonVertexAttributes.BLOCK_ID)) {
            this.blockIdOffset = vertexFormatDescription.getElementOffset(IrisCommonVertexAttributes.BLOCK_ID);
        }
        if (vertexFormatDescription.containsElement(IrisCommonVertexAttributes.ENTITY_ID)) {
            this.entityIdOffset = vertexFormatDescription.getElementOffset(IrisCommonVertexAttributes.ENTITY_ID);
        }
        if (vertexFormatDescription.containsElement(IrisCommonVertexAttributes.MID_BLOCK)) {
            this.midBlockOffset = vertexFormatDescription.getElementOffset(IrisCommonVertexAttributes.MID_BLOCK);
        }
        this.field_21594 = false;
        this.field_21595 = false;
    }

    @Inject(method={"endVertex"}, at={@At(value="HEAD")})
    private void iris$beforeNext(CallbackInfo callbackInfo) {
        long l;
        if (!this.extending) {
            return;
        }
        if (this.injectNormalAndUV1) {
            this.method_22914(0.0f, 0.0f, 0.0f);
        }
        if (this.iris$isTerrain) {
            l = MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)(this.field_20884 + this.blockIdOffset));
            MemoryUtil.memPutShort((long)l, (short)this.currentBlock);
            MemoryUtil.memPutShort((long)(l + 2L), (short)this.currentRenderType);
        } else {
            l = MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)(this.field_20884 + this.entityIdOffset));
            MemoryUtil.memPutShort((long)l, (short)((short)CapturedRenderingState.INSTANCE.getCurrentRenderedEntity()));
            MemoryUtil.memPutShort((long)(l + 2L), (short)((short)CapturedRenderingState.INSTANCE.getCurrentRenderedBlockEntity()));
            MemoryUtil.memPutShort((long)(l + 4L), (short)((short)CapturedRenderingState.INSTANCE.getCurrentRenderedItem()));
        }
        if (this.iris$isTerrain) {
            l = MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)this.field_20884);
            float f = MemoryUtil.memGetFloat((long)l);
            float f2 = MemoryUtil.memGetFloat((long)(l + 4L));
            float f3 = MemoryUtil.memGetFloat((long)(l + 8L));
            MemoryUtil.memPutInt((long)MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)(this.field_20884 + this.midBlockOffset)), (int)ExtendedDataHelper.computeMidBlock(f, f2, f3, this.currentLocalPosX, this.currentLocalPosY, this.currentLocalPosZ));
        }
        ++this.vertexCount;
        if (this.field_1567 == class_293.class_5596.field_27382 && this.vertexCount == 4 || this.field_1567 == class_293.class_5596.field_27379 && this.vertexCount == 3) {
            this.fillExtendedData(this.vertexCount);
        }
    }

    @Unique
    private void fillExtendedData(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.vertexCount = 0;
        int n6 = this.field_1565.method_1362();
        int n7 = this.field_20884 + n6;
        this.polygon.setup(this.field_1555, n7, n6, n);
        float f = 0.0f;
        float f2 = 0.0f;
        for (n5 = 0; n5 < n; ++n5) {
            f += this.polygon.u(n5);
            f2 += this.polygon.v(n5);
        }
        f /= (float)n;
        f2 /= (float)n;
        if (this.iris$isTerrain) {
            n5 = 16;
            n4 = 12;
            n3 = 24;
            n2 = 8;
        } else {
            n5 = 14;
            n4 = 10;
            n3 = 24;
            n2 = 6;
        }
        if (n == 3) {
            for (int i = 0; i < n; ++i) {
                int n8 = this.field_1555.getInt(n7 - n3 - n6 * i);
                int n9 = NormalHelper.computeTangentSmooth(NormI8.unpackX(n8), NormI8.unpackY(n8), NormI8.unpackZ(n8), this.polygon);
                this.field_1555.putFloat(n7 - n5 - n6 * i, f);
                this.field_1555.putFloat(n7 - n4 - n6 * i, f2);
                this.field_1555.putInt(n7 - n2 - n6 * i, n9);
            }
        } else {
            NormalHelper.computeFaceNormal(this.normal, this.polygon);
            int n10 = NormI8.pack(this.normal.x, this.normal.y, this.normal.z, 0.0f);
            int n11 = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.polygon);
            for (int i = 0; i < n; ++i) {
                this.field_1555.putFloat(n7 - n5 - n6 * i, f);
                this.field_1555.putFloat(n7 - n4 - n6 * i, f2);
                this.field_1555.putInt(n7 - n3 - n6 * i, n10);
                this.field_1555.putInt(n7 - n2 - n6 * i, n11);
            }
        }
    }

    @Override
    public void beginBlock(short s, short s2, int n, int n2, int n3) {
        this.currentBlock = s;
        this.currentRenderType = s2;
        this.currentLocalPosX = n;
        this.currentLocalPosY = n2;
        this.currentLocalPosZ = n3;
    }

    @Override
    public void endBlock() {
        this.currentBlock = (short)-1;
        this.currentRenderType = (short)-1;
        this.currentLocalPosX = 0;
        this.currentLocalPosY = 0;
        this.currentLocalPosZ = 0;
    }
}

