/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.craftingtweaks.api.ButtonProperties;
import net.blay09.mods.craftingtweaks.api.ButtonStyle;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.TweakType;
import net.blay09.mods.craftingtweaks.client.GuiImageButton;
import net.blay09.mods.craftingtweaks.client.ITooltipProvider;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public abstract class GuiTweakButton
extends GuiImageButton
implements ITooltipProvider {
    private final class_465<?> screen;
    private final CraftingGrid grid;
    private final TweakType tweak;
    private final TweakType altTweak;
    private final class_7919 normalTooltip;
    private final class_7919 altTooltip;
    private final ButtonProperties normalProperties;
    private final ButtonProperties altProperties;
    private int lastGuiLeft;
    private int lastGuiTop;

    public GuiTweakButton(@Nullable class_465<?> screen, int x, int y, ButtonStyle style, CraftingGrid grid, TweakType tweak, TweakType altTweak) {
        super(x, y, style.getTweak(tweak));
        this.screen = screen;
        if (screen != null) {
            this.lastGuiLeft = ((AbstractContainerScreenAccessor)screen).getLeftPos();
            this.lastGuiTop = ((AbstractContainerScreenAccessor)screen).getTopPos();
        }
        this.grid = grid;
        this.tweak = tweak;
        this.altTweak = altTweak;
        this.normalTooltip = this.createTooltip(tweak);
        this.altTooltip = this.createTooltip(altTweak);
        this.normalProperties = this.properties;
        this.altProperties = style.getTweak(altTweak);
    }

    public void method_25348(double mouseX, double mouseY) {
        this.method_25354(class_310.method_1551().method_1483());
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            this.onTweakButtonClicked((class_1657)player, this.screen != null ? this.screen.method_17577() : player.field_7512, this.grid, class_437.method_25442() ? this.altTweak : this.tweak);
        }
    }

    protected abstract void onTweakButtonClicked(class_1657 var1, class_1703 var2, CraftingGrid var3, TweakType var4);

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_47400(class_437.method_25442() ? this.altTooltip : this.normalTooltip);
        if (this.screen != null) {
            int guiLeft = ((AbstractContainerScreenAccessor)this.screen).getLeftPos();
            int guiTop = ((AbstractContainerScreenAccessor)this.screen).getTopPos();
            if (guiLeft != this.lastGuiLeft || guiTop != this.lastGuiTop) {
                this.method_46421(this.method_46426() + guiLeft - this.lastGuiLeft);
                this.method_46419(this.method_46427() + guiTop - this.lastGuiTop);
            }
            this.lastGuiLeft = guiLeft;
            this.lastGuiTop = guiTop;
        }
        this.properties = class_437.method_25442() ? this.altProperties : this.normalProperties;
        super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private class_7919 createTooltip(TweakType tweak) {
        return switch (tweak) {
            default -> throw new IncompatibleClassChangeError();
            case TweakType.Rotate, TweakType.RotateCounterClockwise -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.craftingtweaks.rotate"));
            case TweakType.Clear -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.craftingtweaks.clear"));
            case TweakType.Balance -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.craftingtweaks.balance"));
            case TweakType.ForceClear -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.craftingtweaks.forceClear").method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43471((String)"tooltip.craftingtweaks.forceClearInfo").method_27692(class_124.field_1080)));
            case TweakType.Spread -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.craftingtweaks.spread"));
        };
    }

    @Override
    public List<class_2561> getTooltipComponents() {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        switch (this.tweak) {
            case Rotate: 
            case RotateCounterClockwise: {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.craftingtweaks.rotate"));
                break;
            }
            case Clear: {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.craftingtweaks.clear"));
                break;
            }
            case ForceClear: {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.craftingtweaks.forceClear"));
                class_5250 forceClearInfoText = class_2561.method_43471((String)"tooltip.craftingtweaks.forceClearInfo");
                forceClearInfoText.method_27692(class_124.field_1080);
                tooltip.add((class_2561)forceClearInfoText);
                break;
            }
            case Balance: {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.craftingtweaks.balance"));
                break;
            }
            case Spread: {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.craftingtweaks.spread"));
            }
        }
        return tooltip;
    }
}

