/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.config;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.config.option.BooleanConfigOption;
import com.terraformersmc.modmenu.config.option.ConfigOptionStorage;
import com.terraformersmc.modmenu.config.option.EnumConfigOption;
import com.terraformersmc.modmenu.config.option.StringSetConfigOption;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;

public class ModMenuConfigManager {
    private static Path path;

    private static void prepareConfigPath() {
        if (path != null) {
            return;
        }
        path = FabricLoader.getInstance().getConfigDir().resolve("modmenu.json");
    }

    public static void initializeConfig() {
        ModMenuConfigManager.load();
    }

    private static void load() {
        ModMenuConfigManager.prepareConfigPath();
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                ModMenuConfigManager.save();
            }
            if (Files.exists(path, new LinkOption[0])) {
                BufferedReader br = Files.newBufferedReader(path);
                JsonObject json = new JsonParser().parse((Reader)br).getAsJsonObject();
                for (Field field : ModMenuConfig.class.getDeclaredFields()) {
                    Type generic;
                    JsonPrimitive jsonPrimitive;
                    Object option;
                    if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                    if (StringSetConfigOption.class.isAssignableFrom(field.getType())) {
                        JsonArray jsonArray = json.getAsJsonArray(field.getName().toLowerCase(Locale.ROOT));
                        if (jsonArray == null) continue;
                        option = (StringSetConfigOption)field.get(null);
                        ConfigOptionStorage.setStringSet(((StringSetConfigOption)option).getKey(), Sets.newHashSet((Iterable)jsonArray).stream().map(JsonElement::getAsString).collect(Collectors.toSet()));
                        continue;
                    }
                    if (BooleanConfigOption.class.isAssignableFrom(field.getType())) {
                        jsonPrimitive = json.getAsJsonPrimitive(field.getName().toLowerCase(Locale.ROOT));
                        if (jsonPrimitive == null || !jsonPrimitive.isBoolean()) continue;
                        option = (BooleanConfigOption)field.get(null);
                        ConfigOptionStorage.setBoolean(((BooleanConfigOption)option).getKey(), jsonPrimitive.getAsBoolean());
                        continue;
                    }
                    if (!EnumConfigOption.class.isAssignableFrom(field.getType()) || !(field.getGenericType() instanceof ParameterizedType) || (jsonPrimitive = json.getAsJsonPrimitive(field.getName().toLowerCase(Locale.ROOT))) == null || !jsonPrimitive.isString() || !((generic = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class)) continue;
                    EnumConfigOption option2 = (EnumConfigOption)field.get(null);
                    Enum found = null;
                    for (Enum value : (Enum[])((Class)generic).getEnumConstants()) {
                        if (!value.name().toLowerCase(Locale.ROOT).equals(jsonPrimitive.getAsString())) continue;
                        found = value;
                        break;
                    }
                    if (found == null) continue;
                    ConfigOptionStorage.setEnumTypeless(option2.getKey(), found);
                }
            }
        }
        catch (IOException | IllegalAccessException e) {
            System.err.println("Couldn't load Mod Menu configuration file; reverting to defaults");
            e.printStackTrace();
        }
    }

    public static void save() {
        ModMenu.clearModCountCache();
        ModMenuConfigManager.prepareConfigPath();
        JsonObject config = new JsonObject();
        try {
            for (Field field : ModMenuConfig.class.getDeclaredFields()) {
                Type generic;
                Object option;
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                if (BooleanConfigOption.class.isAssignableFrom(field.getType())) {
                    option = (BooleanConfigOption)field.get(null);
                    config.addProperty(field.getName().toLowerCase(Locale.ROOT), Boolean.valueOf(ConfigOptionStorage.getBoolean(((BooleanConfigOption)option).getKey())));
                    continue;
                }
                if (StringSetConfigOption.class.isAssignableFrom(field.getType())) {
                    option = (StringSetConfigOption)field.get(null);
                    JsonArray array = new JsonArray();
                    ConfigOptionStorage.getStringSet(((StringSetConfigOption)option).getKey()).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                    config.add(field.getName().toLowerCase(Locale.ROOT), (JsonElement)array);
                    continue;
                }
                if (!EnumConfigOption.class.isAssignableFrom(field.getType()) || !(field.getGenericType() instanceof ParameterizedType) || !((generic = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class)) continue;
                EnumConfigOption option2 = (EnumConfigOption)field.get(null);
                config.addProperty(field.getName().toLowerCase(Locale.ROOT), ConfigOptionStorage.getEnumTypeless(option2.getKey(), (Class)generic).name().toLowerCase(Locale.ROOT));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        String jsonString = ModMenu.GSON.toJson((JsonElement)config);
        try (BufferedWriter fileWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save Mod Menu configuration file");
            e.printStackTrace();
        }
    }
}

